# JansConfigApi.JansLinkConfigurationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getJansLinkProperties**](JansLinkConfigurationApi.md#getJansLinkProperties) | **GET** /jans-link/link-config | Gets Jans Link App configuration.
[**putJansLinkProperties**](JansLinkConfigurationApi.md#putJansLinkProperties) | **PUT** /jans-link/link-config | Updates Jans Link configuration properties.



## getJansLinkProperties

> AppConfiguration2 getJansLinkProperties()

Gets Jans Link App configuration.

Gets Jans Link App configuration.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansLinkConfigurationApi();
apiInstance.getJansLinkProperties((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**AppConfiguration2**](AppConfiguration2.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## putJansLinkProperties

> AppConfiguration2 putJansLinkProperties(opts)

Updates Jans Link configuration properties.

Updates Jans Link configuration properties.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansLinkConfigurationApi();
let opts = {
  'appConfiguration2': new JansConfigApi.AppConfiguration2() // AppConfiguration2 | JansLinkConfiguration
};
apiInstance.putJansLinkProperties(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **appConfiguration2** | [**AppConfiguration2**](AppConfiguration2.md)| JansLinkConfiguration | [optional] 

### Return type

[**AppConfiguration2**](AppConfiguration2.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

