"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _CustomScript = _interopRequireDefault(require("../model/CustomScript"));
var _PagedResult = _interopRequireDefault(require("../model/PagedResult"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* CustomScripts service.
* @module api/CustomScriptsApi
* @version OAS Version
*/
var CustomScriptsApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new CustomScriptsApi. 
  * @alias module:api/CustomScriptsApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function CustomScriptsApi(apiClient) {
    _classCallCheck(this, CustomScriptsApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteConfigScriptsByInum operation.
   * @callback module:api/CustomScriptsApi~deleteConfigScriptsByInumCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Deletes a custom script
   * Deletes a custom script
   * @param {String} inum Script identifier
   * @param {module:api/CustomScriptsApi~deleteConfigScriptsByInumCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(CustomScriptsApi, [{
    key: "deleteConfigScriptsByInum",
    value: function deleteConfigScriptsByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteConfigScriptsByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/config/scripts/{inum}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getConfigScripts operation.
     * @callback module:api/CustomScriptsApi~getConfigScriptsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets a list of custom scripts
     * Gets a list of custom scripts
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/CustomScriptsApi~getConfigScriptsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
  }, {
    key: "getConfigScripts",
    value: function getConfigScripts(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PagedResult["default"];
      return this.apiClient.callApi('/api/v1/config/scripts', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getConfigScriptsByInum operation.
     * @callback module:api/CustomScriptsApi~getConfigScriptsByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets a script by Inum
     * Gets a script by Inum
     * @param {String} inum Script identifier
     * @param {module:api/CustomScriptsApi~getConfigScriptsByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
  }, {
    key: "getConfigScriptsByInum",
    value: function getConfigScriptsByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getConfigScriptsByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _CustomScript["default"];
      return this.apiClient.callApi('/api/v1/config/scripts/inum/{inum}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getConfigScriptsByType operation.
     * @callback module:api/CustomScriptsApi~getConfigScriptsByTypeCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of scripts by type
     * Gets list of scripts by type
     * @param {String} type Script type
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/CustomScriptsApi~getConfigScriptsByTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
  }, {
    key: "getConfigScriptsByType",
    value: function getConfigScriptsByType(type, opts, callback) {
      opts = opts || {};
      var postBody = null;
      // verify the required parameter 'type' is set
      if (type === undefined || type === null) {
        throw new Error("Missing the required parameter 'type' when calling getConfigScriptsByType");
      }
      var pathParams = {
        'type': type
      };
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PagedResult["default"];
      return this.apiClient.callApi('/api/v1/config/scripts/type/{type}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getCustomScriptByName operation.
     * @callback module:api/CustomScriptsApi~getCustomScriptByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch custom script by name
     * Fetch custom script by name
     * @param {String} name Script name
     * @param {module:api/CustomScriptsApi~getCustomScriptByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
  }, {
    key: "getCustomScriptByName",
    value: function getCustomScriptByName(name, callback) {
      var postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getCustomScriptByName");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _CustomScript["default"];
      return this.apiClient.callApi('/api/v1/config/scripts/name/{name}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getCustomScriptType operation.
     * @callback module:api/CustomScriptsApi~getCustomScriptTypeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<String>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch custom script types
     * Fetch custom script types
     * @param {module:api/CustomScriptsApi~getCustomScriptTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<String>}
     */
  }, {
    key: "getCustomScriptType",
    value: function getCustomScriptType(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = ['String'];
      return this.apiClient.callApi('/api/v1/config/scripts/types', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getCustomScriptTypes operation.
     * @callback module:api/CustomScriptsApi~getCustomScriptTypesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<String>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch custom script types
     * Fetch custom script types
     * @param {module:api/CustomScriptsApi~getCustomScriptTypesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<String>}
     */
  }, {
    key: "getCustomScriptTypes",
    value: function getCustomScriptTypes(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = ['String'];
      return this.apiClient.callApi('/api/v1/config/scripts/script-types', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchConfigScriptsByInum operation.
     * @callback module:api/CustomScriptsApi~patchConfigScriptsByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patches a custom script
     * Patches a custom script
     * @param {String} inum Script identifier
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody JsonPatch object
     * @param {module:api/CustomScriptsApi~patchConfigScriptsByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
  }, {
    key: "patchConfigScriptsByInum",
    value: function patchConfigScriptsByInum(inum, opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchConfigScriptsByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _CustomScript["default"];
      return this.apiClient.callApi('/api/v1/config/scripts/{inum}', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postConfigScripts operation.
     * @callback module:api/CustomScriptsApi~postConfigScriptsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Adds a new custom script
     * Adds a new custom script
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.addScriptTemplate Boolean flag to indicate if script template is to be added. If CustomScript request object has script populated then script template will not be added. (default to false)
     * @param {module:model/CustomScript} opts.customScript CustomScript object
     * @param {module:api/CustomScriptsApi~postConfigScriptsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
  }, {
    key: "postConfigScripts",
    value: function postConfigScripts(opts, callback) {
      opts = opts || {};
      var postBody = opts['customScript'];
      var pathParams = {};
      var queryParams = {
        'addScriptTemplate': opts['addScriptTemplate']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _CustomScript["default"];
      return this.apiClient.callApi('/api/v1/config/scripts', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putConfigScripts operation.
     * @callback module:api/CustomScriptsApi~putConfigScriptsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates a custom script
     * Updates a custom script
     * @param {Object} opts Optional parameters
     * @param {module:model/CustomScript} opts.customScript CustomScript object
     * @param {module:api/CustomScriptsApi~putConfigScriptsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
  }, {
    key: "putConfigScripts",
    value: function putConfigScripts(opts, callback) {
      opts = opts || {};
      var postBody = opts['customScript'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _CustomScript["default"];
      return this.apiClient.callApi('/api/v1/config/scripts', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();