/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import IdentityProvider from '../model/IdentityProvider';
import IdentityProviderPagedResult from '../model/IdentityProviderPagedResult';

/**
* SAMLIdentityBroker service.
* @module api/SAMLIdentityBrokerApi
* @version OAS Version
*/
export default class SAMLIdentityBrokerApi {

    /**
    * Constructs a new SAMLIdentityBrokerApi. 
    * @alias module:api/SAMLIdentityBrokerApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteSamlIdentityProvider operation.
     * @callback module:api/SAMLIdentityBrokerApi~deleteSamlIdentityProviderCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete SAML Identity Provider
     * Delete SAML Identity Provider
     * @param {String} inum Unique identifier
     * @param {module:api/SAMLIdentityBrokerApi~deleteSamlIdentityProviderCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteSamlIdentityProvider(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteSamlIdentityProvider");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/kc/saml/idp/{inum}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getSamlIdentityProvider operation.
     * @callback module:api/SAMLIdentityBrokerApi~getSamlIdentityProviderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/IdentityProviderPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Retrieves SAML Identity Provider
     * Retrieves SAML Identity Provider
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/SAMLIdentityBrokerApi~getSamlIdentityProviderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/IdentityProviderPagedResult}
     */
    getSamlIdentityProvider(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = IdentityProviderPagedResult;
      return this.apiClient.callApi(
        '/kc/saml/idp', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getSamlIdentityProviderByInum operation.
     * @callback module:api/SAMLIdentityBrokerApi~getSamlIdentityProviderByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/IdentityProvider} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get SAML Identity Provider by Inum
     * Get SAML Identity Provider by Inum
     * @param {String} inum Unique identifier
     * @param {module:api/SAMLIdentityBrokerApi~getSamlIdentityProviderByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/IdentityProvider}
     */
    getSamlIdentityProviderByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getSamlIdentityProviderByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = IdentityProvider;
      return this.apiClient.callApi(
        '/kc/saml/idp/{inum}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getSamlSpMetadataJson operation.
     * @callback module:api/SAMLIdentityBrokerApi~getSamlSpMetadataJsonCallback
     * @param {String} error Error message, if any.
     * @param {Object} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get SAML SP Metadata as Json
     * Get SAML SP Metadata as Json
     * @param {String} inum Unique identifier
     * @param {module:api/SAMLIdentityBrokerApi~getSamlSpMetadataJsonCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Object}
     */
    getSamlSpMetadataJson(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getSamlSpMetadataJson");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Object;
      return this.apiClient.callApi(
        '/kc/saml/idp/sp-metadata/{inum}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getSamlSpMetadataUrl operation.
     * @callback module:api/SAMLIdentityBrokerApi~getSamlSpMetadataUrlCallback
     * @param {String} error Error message, if any.
     * @param {String} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get SAML SP Metadata Endpoint URL
     * Get SAML SP Metadata Endpoint URL
     * @param {String} inum Unique identifier
     * @param {module:api/SAMLIdentityBrokerApi~getSamlSpMetadataUrlCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link String}
     */
    getSamlSpMetadataUrl(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getSamlSpMetadataUrl");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = 'String';
      return this.apiClient.callApi(
        '/kc/saml/idp/sp-metadata-file/{inum}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postSamlIdentityProvider operation.
     * @callback module:api/SAMLIdentityBrokerApi~postSamlIdentityProviderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/IdentityProvider} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create SAML Identity Provider
     * Create SAML Identity Provider
     * @param {module:model/IdentityProvider} identityProvider 
     * @param {File} metaDataFile 
     * @param {module:api/SAMLIdentityBrokerApi~postSamlIdentityProviderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/IdentityProvider}
     */
    postSamlIdentityProvider(identityProvider, metaDataFile, callback) {
      let postBody = null;
      // verify the required parameter 'identityProvider' is set
      if (identityProvider === undefined || identityProvider === null) {
        throw new Error("Missing the required parameter 'identityProvider' when calling postSamlIdentityProvider");
      }
      // verify the required parameter 'metaDataFile' is set
      if (metaDataFile === undefined || metaDataFile === null) {
        throw new Error("Missing the required parameter 'metaDataFile' when calling postSamlIdentityProvider");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
        'identityProvider': identityProvider,
        'metaDataFile': metaDataFile
      };

      let authNames = ['oauth2'];
      let contentTypes = ['multipart/form-data'];
      let accepts = ['application/json-patch+json'];
      let returnType = IdentityProvider;
      return this.apiClient.callApi(
        '/kc/saml/idp/upload', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putSamlIdentityProvider operation.
     * @callback module:api/SAMLIdentityBrokerApi~putSamlIdentityProviderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/IdentityProvider} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update SAML Identity Provider
     * Update SAML Identity Provider
     * @param {module:model/IdentityProvider} identityProvider 
     * @param {File} metaDataFile 
     * @param {module:api/SAMLIdentityBrokerApi~putSamlIdentityProviderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/IdentityProvider}
     */
    putSamlIdentityProvider(identityProvider, metaDataFile, callback) {
      let postBody = null;
      // verify the required parameter 'identityProvider' is set
      if (identityProvider === undefined || identityProvider === null) {
        throw new Error("Missing the required parameter 'identityProvider' when calling putSamlIdentityProvider");
      }
      // verify the required parameter 'metaDataFile' is set
      if (metaDataFile === undefined || metaDataFile === null) {
        throw new Error("Missing the required parameter 'metaDataFile' when calling putSamlIdentityProvider");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
        'identityProvider': identityProvider,
        'metaDataFile': metaDataFile
      };

      let authNames = ['oauth2'];
      let contentTypes = ['multipart/form-data'];
      let accepts = ['application/json-patch+json'];
      let returnType = IdentityProvider;
      return this.apiClient.callApi(
        '/kc/saml/idp/upload', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
