/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import JansAttribute from '../model/JansAttribute';
import PagedResult from '../model/PagedResult';
import PatchRequest from '../model/PatchRequest';

/**
* Attribute service.
* @module api/AttributeApi
* @version OAS Version
*/
export default class AttributeApi {

    /**
    * Constructs a new AttributeApi. 
    * @alias module:api/AttributeApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteAttributesByInum operation.
     * @callback module:api/AttributeApi~deleteAttributesByInumCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Deletes an attribute based on inum
     * Deletes an attribute based on inum
     * @param {String} inum Attribute Id
     * @param {module:api/AttributeApi~deleteAttributesByInumCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteAttributesByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteAttributesByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/attributes/{inum}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAttributes operation.
     * @callback module:api/AttributeApi~getAttributesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets a list of Jans attributes.
     * Gets a list of Jans attributes.
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {String} opts.status Status of the attribute (default to 'all')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/AttributeApi~getAttributesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
    getAttributes(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'status': opts['status'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PagedResult;
      return this.apiClient.callApi(
        '/api/v1/attributes', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAttributesByInum operation.
     * @callback module:api/AttributeApi~getAttributesByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JansAttribute} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets an attribute based on inum
     * Gets an attribute based on inum
     * @param {String} inum Attribute Id
     * @param {module:api/AttributeApi~getAttributesByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JansAttribute}
     */
    getAttributesByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getAttributesByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = JansAttribute;
      return this.apiClient.callApi(
        '/api/v1/attributes/{inum}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchAttributesByInum operation.
     * @callback module:api/AttributeApi~patchAttributesByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JansAttribute} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Partially modify a JansAttribute
     * Partially modify a JansAttribute
     * @param {String} inum Attribute Id
     * @param {Object} opts Optional parameters
     * @param {Array.<module:model/PatchRequest>} opts.patchRequest String representing patch-document.
     * @param {module:api/AttributeApi~patchAttributesByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JansAttribute}
     */
    patchAttributesByInum(inum, opts, callback) {
      opts = opts || {};
      let postBody = opts['patchRequest'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchAttributesByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = JansAttribute;
      return this.apiClient.callApi(
        '/api/v1/attributes/{inum}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postAttributes operation.
     * @callback module:api/AttributeApi~postAttributesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JansAttribute} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Adds a new attribute
     * Adds a new attribute
     * @param {Object} opts Optional parameters
     * @param {module:model/JansAttribute} opts.jansAttribute JansAttribute object
     * @param {module:api/AttributeApi~postAttributesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JansAttribute}
     */
    postAttributes(opts, callback) {
      opts = opts || {};
      let postBody = opts['jansAttribute'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = JansAttribute;
      return this.apiClient.callApi(
        '/api/v1/attributes', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putAttributes operation.
     * @callback module:api/AttributeApi~putAttributesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JansAttribute} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates an existing attribute
     * Updates an existing attribute
     * @param {Object} opts Optional parameters
     * @param {module:model/JansAttribute} opts.jansAttribute JansAttribute object
     * @param {module:api/AttributeApi~putAttributesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JansAttribute}
     */
    putAttributes(opts, callback) {
      opts = opts || {};
      let postBody = opts['jansAttribute'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = JansAttribute;
      return this.apiClient.callApi(
        '/api/v1/attributes', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
