/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import GenericResponse from '../model/GenericResponse';
import RolePermissionMapping from '../model/RolePermissionMapping';

/**
* AdminUIRolePermissionsMapping service.
* @module api/AdminUIRolePermissionsMappingApi
* @version OAS Version
*/
export default class AdminUIRolePermissionsMappingApi {

    /**
    * Constructs a new AdminUIRolePermissionsMappingApi. 
    * @alias module:api/AdminUIRolePermissionsMappingApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the addRolePermissionsMapping operation.
     * @callback module:api/AdminUIRolePermissionsMappingApi~addRolePermissionsMappingCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Add role-permissions mapping
     * Add role-permissions mapping
     * @param {Object} opts Optional parameters
     * @param {module:model/RolePermissionMapping} opts.rolePermissionMapping RolePermissionMapping object
     * @param {module:api/AdminUIRolePermissionsMappingApi~addRolePermissionsMappingCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/RolePermissionMapping>}
     */
    addRolePermissionsMapping(opts, callback) {
      opts = opts || {};
      let postBody = opts['rolePermissionMapping'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = [RolePermissionMapping];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRolePermissionsMapping', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAdminuiRolePermissions operation.
     * @callback module:api/AdminUIRolePermissionsMappingApi~getAdminuiRolePermissionsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get admin ui role-permissions mapping by role-name
     * Get admin ui role-permissions mapping by role-name
     * @param {String} adminUIRole Admin UI Role
     * @param {module:api/AdminUIRolePermissionsMappingApi~getAdminuiRolePermissionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/RolePermissionMapping>}
     */
    getAdminuiRolePermissions(adminUIRole, callback) {
      let postBody = null;
      // verify the required parameter 'adminUIRole' is set
      if (adminUIRole === undefined || adminUIRole === null) {
        throw new Error("Missing the required parameter 'adminUIRole' when calling getAdminuiRolePermissions");
      }

      let pathParams = {
        'adminUIRole': adminUIRole
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [RolePermissionMapping];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRolePermissionsMapping/{adminUIRole}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getAllAdminuiRolePermissions operation.
     * @callback module:api/AdminUIRolePermissionsMappingApi~getAllAdminuiRolePermissionsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get all admin ui role-permissions mapping
     * Get all admin ui role-permissions mapping
     * @param {module:api/AdminUIRolePermissionsMappingApi~getAllAdminuiRolePermissionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/RolePermissionMapping>}
     */
    getAllAdminuiRolePermissions(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [RolePermissionMapping];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRolePermissionsMapping', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the mapPermissionsToRole operation.
     * @callback module:api/AdminUIRolePermissionsMappingApi~mapPermissionsToRoleCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Map permissions to role
     * Map permissions to role
     * @param {Object} opts Optional parameters
     * @param {module:model/RolePermissionMapping} opts.rolePermissionMapping RolePermissionMapping object
     * @param {module:api/AdminUIRolePermissionsMappingApi~mapPermissionsToRoleCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/RolePermissionMapping>}
     */
    mapPermissionsToRole(opts, callback) {
      opts = opts || {};
      let postBody = opts['rolePermissionMapping'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = [RolePermissionMapping];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRolePermissionsMapping', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the removeRolePermissionsPermission operation.
     * @callback module:api/AdminUIRolePermissionsMappingApi~removeRolePermissionsPermissionCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/RolePermissionMapping>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Remove role-permissions mapping by role-name
     * Remove role-permissions mapping by role-name
     * @param {String} adminUIRole role
     * @param {module:api/AdminUIRolePermissionsMappingApi~removeRolePermissionsPermissionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/RolePermissionMapping>}
     */
    removeRolePermissionsPermission(adminUIRole, callback) {
      let postBody = null;
      // verify the required parameter 'adminUIRole' is set
      if (adminUIRole === undefined || adminUIRole === null) {
        throw new Error("Missing the required parameter 'adminUIRole' when calling removeRolePermissionsPermission");
      }

      let pathParams = {
        'adminUIRole': adminUIRole
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [RolePermissionMapping];
      return this.apiClient.callApi(
        '/admin-ui/adminUIRolePermissionsMapping/{adminUIRole}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
