"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _PagedResult = _interopRequireDefault(require("../model/PagedResult"));
var _UmaResource = _interopRequireDefault(require("../model/UmaResource"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* OAuthUMAResources service.
* @module api/OAuthUMAResourcesApi
* @version OAS Version
*/
var OAuthUMAResourcesApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new OAuthUMAResourcesApi. 
  * @alias module:api/OAuthUMAResourcesApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function OAuthUMAResourcesApi(apiClient) {
    _classCallCheck(this, OAuthUMAResourcesApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteOauthUmaResourcesById operation.
   * @callback module:api/OAuthUMAResourcesApi~deleteOauthUmaResourcesByIdCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Deletes an UMA resource
   * Deletes an UMA resource
   * @param {String} id Resource description ID
   * @param {module:api/OAuthUMAResourcesApi~deleteOauthUmaResourcesByIdCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(OAuthUMAResourcesApi, [{
    key: "deleteOauthUmaResourcesById",
    value: function deleteOauthUmaResourcesById(id, callback) {
      var postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling deleteOauthUmaResourcesById");
      }
      var pathParams = {
        'id': id
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/uma/resources/{id}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getOauthUmaResources operation.
     * @callback module:api/OAuthUMAResourcesApi~getOauthUmaResourcesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of UMA resources
     * Gets list of UMA resources
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/OAuthUMAResourcesApi~getOauthUmaResourcesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
  }, {
    key: "getOauthUmaResources",
    value: function getOauthUmaResources(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PagedResult["default"];
      return this.apiClient.callApi('/api/v1/uma/resources', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getOauthUmaResourcesByClientid operation.
     * @callback module:api/OAuthUMAResourcesApi~getOauthUmaResourcesByClientidCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/UmaResource>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch uma resources by client id
     * Fetch uma resources by client id
     * @param {String} clientId Client ID
     * @param {module:api/OAuthUMAResourcesApi~getOauthUmaResourcesByClientidCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/UmaResource>}
     */
  }, {
    key: "getOauthUmaResourcesByClientid",
    value: function getOauthUmaResourcesByClientid(clientId, callback) {
      var postBody = null;
      // verify the required parameter 'clientId' is set
      if (clientId === undefined || clientId === null) {
        throw new Error("Missing the required parameter 'clientId' when calling getOauthUmaResourcesByClientid");
      }
      var pathParams = {
        'clientId': clientId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_UmaResource["default"]];
      return this.apiClient.callApi('/api/v1/uma/resources/clientId/{clientId}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getOauthUmaResourcesById operation.
     * @callback module:api/OAuthUMAResourcesApi~getOauthUmaResourcesByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UmaResource} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets an UMA resource by ID
     * Gets an UMA resource by ID
     * @param {String} id Resource description ID
     * @param {module:api/OAuthUMAResourcesApi~getOauthUmaResourcesByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UmaResource}
     */
  }, {
    key: "getOauthUmaResourcesById",
    value: function getOauthUmaResourcesById(id, callback) {
      var postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling getOauthUmaResourcesById");
      }
      var pathParams = {
        'id': id
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _UmaResource["default"];
      return this.apiClient.callApi('/api/v1/uma/resources/{id}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchOauthUmaResourcesById operation.
     * @callback module:api/OAuthUMAResourcesApi~patchOauthUmaResourcesByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UmaResource} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch UMA resource
     * Patch UMA resource
     * @param {String} id Resource description ID
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/OAuthUMAResourcesApi~patchOauthUmaResourcesByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UmaResource}
     */
  }, {
    key: "patchOauthUmaResourcesById",
    value: function patchOauthUmaResourcesById(id, opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling patchOauthUmaResourcesById");
      }
      var pathParams = {
        'id': id
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _UmaResource["default"];
      return this.apiClient.callApi('/api/v1/uma/resources/{id}', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postOauthUmaResources operation.
     * @callback module:api/OAuthUMAResourcesApi~postOauthUmaResourcesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UmaResource} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Creates an UMA resource
     * Creates an UMA resource
     * @param {Object} opts Optional parameters
     * @param {module:model/UmaResource} opts.umaResource UmaResource object
     * @param {module:api/OAuthUMAResourcesApi~postOauthUmaResourcesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UmaResource}
     */
  }, {
    key: "postOauthUmaResources",
    value: function postOauthUmaResources(opts, callback) {
      opts = opts || {};
      var postBody = opts['umaResource'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _UmaResource["default"];
      return this.apiClient.callApi('/api/v1/uma/resources', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putOauthUmaResources operation.
     * @callback module:api/OAuthUMAResourcesApi~putOauthUmaResourcesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UmaResource} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates an UMA resource
     * Updates an UMA resource
     * @param {Object} opts Optional parameters
     * @param {module:model/UmaResource} opts.umaResource UmaResource object
     * @param {module:api/OAuthUMAResourcesApi~putOauthUmaResourcesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UmaResource}
     */
  }, {
    key: "putOauthUmaResources",
    value: function putOauthUmaResources(opts, callback) {
      opts = opts || {};
      var postBody = opts['umaResource'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _UmaResource["default"];
      return this.apiClient.callApi('/api/v1/uma/resources', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();