# JansConfigApi.AgamaApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAgamaPrj**](AgamaApi.md#deleteAgamaPrj) | **DELETE** /api/v1/agama-deployment/{name} | Undeploy an Agama project from the server.
[**getAgamaPrj**](AgamaApi.md#getAgamaPrj) | **GET** /api/v1/agama-deployment | Retrieve the list of projects deployed currently.
[**getAgamaPrjByName**](AgamaApi.md#getAgamaPrjByName) | **GET** /api/v1/agama-deployment/{name} | Retrieve details of a single deployment by name.
[**getAgamaPrjConfigs**](AgamaApi.md#getAgamaPrjConfigs) | **GET** /api/v1/agama-deployment/configs/{name} | Retrieve the configurations associated to flows that belong to the project of interest. The project must have been already processed fully.
[**getAgamaProject**](AgamaApi.md#getAgamaProject) | **GET** /api/v1/agama-repo/download | Download agama project.
[**getAgamaRepositories**](AgamaApi.md#getAgamaRepositories) | **GET** /api/v1/agama-repo | Gets all agama repositories.
[**postAgamaPrj**](AgamaApi.md#postAgamaPrj) | **POST** /api/v1/agama-deployment/{name} | Add or replace an Agama project to the server.
[**putAgamaPrj**](AgamaApi.md#putAgamaPrj) | **PUT** /api/v1/agama-deployment/configs/{name} | Set or replace the configurations associated to flows that belong to the project. The project must have been already processed fully.



## deleteAgamaPrj

> deleteAgamaPrj(name)

Undeploy an Agama project from the server.

Undeploy an Agama project from the server.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
apiInstance.deleteAgamaPrj(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


## getAgamaPrj

> PagedResult getAgamaPrj(opts)

Retrieve the list of projects deployed currently.

Retrieve the list of projects deployed currently.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let opts = {
  'start': 56, // Number | Start index for the result
  'count': 56 // Number | Search size - count of the results to return
};
apiInstance.getAgamaPrj(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **start** | **Number**| Start index for the result | [optional] 
 **count** | **Number**| Search size - count of the results to return | [optional] 

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAgamaPrjByName

> Deployment getAgamaPrjByName(name)

Retrieve details of a single deployment by name.

Retrieve details of a single deployment by name.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
apiInstance.getAgamaPrjByName(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 

### Return type

[**Deployment**](Deployment.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAgamaPrjConfigs

> String getAgamaPrjConfigs(name)

Retrieve the configurations associated to flows that belong to the project of interest. The project must have been already processed fully.

Retrieve the configurations associated to flows that belong to the project of interest. The project must have been already processed fully.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
apiInstance.getAgamaPrjConfigs(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 

### Return type

**String**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAgamaProject

> File getAgamaProject(opts)

Download agama project.

Download agama project.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let opts = {
  'downloadLink': "downloadLink_example" // String | Agama project download Link
};
apiInstance.getAgamaProject(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **downloadLink** | **String**| Agama project download Link | [optional] 

### Return type

**File**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain


## getAgamaRepositories

> Object getAgamaRepositories()

Gets all agama repositories.

Gets all agama repositories.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
apiInstance.getAgamaRepositories((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

**Object**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## postAgamaPrj

> String postAgamaPrj(name, opts)

Add or replace an Agama project to the server.

Add or replace an Agama project to the server.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
let opts = {
  'autoconfigure': "autoconfigure_example", // String | Boolean value to indicating to auto configure the project 
  'body': null // Blob | Agama gama file
};
apiInstance.postAgamaPrj(name, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 
 **autoconfigure** | **String**| Boolean value to indicating to auto configure the project  | [optional] 
 **body** | **Blob**| Agama gama file | [optional] 

### Return type

**String**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/zip
- **Accept**: application/zip


## putAgamaPrj

> String putAgamaPrj(name, opts)

Set or replace the configurations associated to flows that belong to the project. The project must have been already processed fully.

Set or replace the configurations associated to flows that belong to the project. The project must have been already processed fully.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AgamaApi();
let name = "name_example"; // String | Agama project name
let opts = {
  'body': {
  "org.gluu.agama.ldap.pw.main": {
    "lockConfig": {
      "MAX_LOGIN_ATTEMPT": 6,
      "ENABLE_LOCK": true,
      "LOCK_EXP_TIME": 180
    },
    "useInternalLdapConfig": false,
    "serversConfig": [
      {
        "configId": "ad_1",
        "bindDN": "cn=directory manager",
        "bindPassword": "encoded_password/plain_passowrd",
        "servers": [
          "localhost:1389"
        ],
        "maxConnections": 3,
        "useSSL": false,
        "baseDNs": [
          "ou=people,o=jans"
        ],
        "loginAttributes": [
          "uid"
        ],
        "localLoginAttributes": [
          "uid"
        ]
      }
    ]
  }
}
 // String | JSON object with configurations associated to flows 
};
apiInstance.putAgamaPrj(name, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Agama project name | 
 **body** | **String**| JSON object with configurations associated to flows  | [optional] 

### Return type

**String**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

