"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _Client = _interopRequireDefault(require("../model/Client"));
var _PagedResult = _interopRequireDefault(require("../model/PagedResult"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* OAuthOpenIDConnectClients service.
* @module api/OAuthOpenIDConnectClientsApi
* @version OAS Version
*/
var OAuthOpenIDConnectClientsApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new OAuthOpenIDConnectClientsApi. 
  * @alias module:api/OAuthOpenIDConnectClientsApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function OAuthOpenIDConnectClientsApi(apiClient) {
    _classCallCheck(this, OAuthOpenIDConnectClientsApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteOauthOpenidClientByInum operation.
   * @callback module:api/OAuthOpenIDConnectClientsApi~deleteOauthOpenidClientByInumCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete OpenId Connect client
   * Delete OpenId Connect client
   * @param {String} inum Client identifier
   * @param {module:api/OAuthOpenIDConnectClientsApi~deleteOauthOpenidClientByInumCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(OAuthOpenIDConnectClientsApi, [{
    key: "deleteOauthOpenidClientByInum",
    value: function deleteOauthOpenidClientByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteOauthOpenidClientByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/openid/clients/{inum}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getOauthOpenidClients operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~getOauthOpenidClientsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of OpenID Connect clients
     * Gets list of OpenID Connect clients
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/OAuthOpenIDConnectClientsApi~getOauthOpenidClientsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
  }, {
    key: "getOauthOpenidClients",
    value: function getOauthOpenidClients(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PagedResult["default"];
      return this.apiClient.callApi('/api/v1/openid/clients', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getOauthOpenidClientsByInum operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~getOauthOpenidClientsByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Client} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get OpenId Connect Client by Inum
     * Get OpenId Connect Client by Inum
     * @param {String} inum Client identifier
     * @param {module:api/OAuthOpenIDConnectClientsApi~getOauthOpenidClientsByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Client}
     */
  }, {
    key: "getOauthOpenidClientsByInum",
    value: function getOauthOpenidClientsByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getOauthOpenidClientsByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _Client["default"];
      return this.apiClient.callApi('/api/v1/openid/clients/{inum}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchOauthOpenidClientByInum operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~patchOauthOpenidClientByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Client} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch OpenId Connect client
     * Patch OpenId Connect client
     * @param {String} inum Client identifier
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/OAuthOpenIDConnectClientsApi~patchOauthOpenidClientByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Client}
     */
  }, {
    key: "patchOauthOpenidClientByInum",
    value: function patchOauthOpenidClientByInum(inum, opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchOauthOpenidClientByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _Client["default"];
      return this.apiClient.callApi('/api/v1/openid/clients/{inum}', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postOauthOpenidClient operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~postOauthOpenidClientCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Client} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new OpenId Connect client
     * Create new OpenId Connect client
     * @param {Object} opts Optional parameters
     * @param {module:model/Client} opts.client OpenID Connect Client object
     * @param {module:api/OAuthOpenIDConnectClientsApi~postOauthOpenidClientCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Client}
     */
  }, {
    key: "postOauthOpenidClient",
    value: function postOauthOpenidClient(opts, callback) {
      opts = opts || {};
      var postBody = opts['client'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _Client["default"];
      return this.apiClient.callApi('/api/v1/openid/clients', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putOauthOpenidClient operation.
     * @callback module:api/OAuthOpenIDConnectClientsApi~putOauthOpenidClientCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Client} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update OpenId Connect client
     * Update OpenId Connect client
     * @param {Object} opts Optional parameters
     * @param {module:model/Client} opts.client OpenID Connect Client object
     * @param {module:api/OAuthOpenIDConnectClientsApi~putOauthOpenidClientCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Client}
     */
  }, {
    key: "putOauthOpenidClient",
    value: function putOauthOpenidClient(opts, callback) {
      opts = opts || {};
      var postBody = opts['client'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _Client["default"];
      return this.apiClient.callApi('/api/v1/openid/clients', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();