import PropTypes from 'prop-types';
import React from 'react';
import Highlighter from '../Highlighter';
import Menu from '../Menu';
import MenuItem from '../MenuItem';
import { getOptionLabel, getOptionProperty, isString } from '../../utils';
const propTypes = {
    newSelectionPrefix: PropTypes.node,
    paginationText: PropTypes.node,
    renderMenuItemChildren: PropTypes.func,
};
function renderMenuItemChildrenFn(option, props) {
    return (React.createElement(Highlighter, { search: props.text }, getOptionLabel(option, props.labelKey)));
}
const TypeaheadMenu = (props) => {
    const { labelKey, newSelectionPrefix = 'New selection: ', options, paginationText = 'Display additional results...', renderMenuItemChildren = renderMenuItemChildrenFn, text, ...menuProps } = props;
    const renderMenuItem = (option, position) => {
        const label = getOptionLabel(option, labelKey);
        const menuItemProps = {
            disabled: !!getOptionProperty(option, 'disabled'),
            label,
            option,
            position,
        };
        if (getOptionProperty(option, 'customOption')) {
            return (React.createElement(MenuItem, { ...menuItemProps, className: "rbt-menu-custom-option", key: position, label: label },
                newSelectionPrefix,
                React.createElement(Highlighter, { search: text }, label)));
        }
        if (getOptionProperty(option, 'paginationOption')) {
            return (React.createElement(React.Fragment, { key: "pagination-option-divider" },
                React.createElement(Menu.Divider, null),
                React.createElement(MenuItem, { ...menuItemProps, className: "rbt-menu-pagination-option", label: isString(paginationText) ? paginationText : '' }, paginationText)));
        }
        return (React.createElement(MenuItem, { ...menuItemProps, key: position }, renderMenuItemChildren(option, props, position)));
    };
    return (React.createElement(Menu, { ...menuProps, key: text }, options.map(renderMenuItem)));
};
TypeaheadMenu.propTypes = propTypes;
export default TypeaheadMenu;
