/* tslint:disable */
/* eslint-disable */
/**
 * Create a new instance of the Cedarling application.
 * This function can take as config parameter the eather `Map` other `Object`
 */
export function init(config: any): Promise<Cedarling>;
/**
 * A WASM wrapper for the Rust `cedarling::AuthorizeResult` struct.
 * Represents the result of an authorization request.
 */
export class AuthorizeResult {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  /**
   * Convert `AuthorizeResult` to json string value
   */
  json_string(): string;
  principal(principal: string): AuthorizeResultResponse | undefined;
  /**
   * Result of authorization where principal is `Jans::Workload`
   */
  get workload(): AuthorizeResultResponse | undefined;
  /**
   * Result of authorization where principal is `Jans::Workload`
   */
  set workload(value: AuthorizeResultResponse | null | undefined);
  /**
   * Result of authorization where principal is `Jans::User`
   */
  get person(): AuthorizeResultResponse | undefined;
  /**
   * Result of authorization where principal is `Jans::User`
   */
  set person(value: AuthorizeResultResponse | null | undefined);
  /**
   * Result of authorization
   * true means `ALLOW`
   * false means `Deny`
   *
   * this field is [`bool`] type to be compatible with [authzen Access Evaluation Decision](https://openid.github.io/authzen/#section-6.2.1).
   */
  decision: boolean;
  /**
   * Request ID of the authorization request
   */
  request_id: string;
}
/**
 * A WASM wrapper for the Rust `cedar_policy::Response` struct.
 * Represents the result of an authorization request.
 */
export class AuthorizeResultResponse {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  /**
   * Authorization decision
   */
  readonly decision: boolean;
  /**
   * Diagnostics providing more information on how this decision was reached
   */
  readonly diagnostics: Diagnostics;
}
/**
 * The instance of the Cedarling application.
 */
export class Cedarling {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  /**
   * Create a new instance of the Cedarling application.
   * Assume that config is `Object`
   */
  static new(config: object): Promise<Cedarling>;
  /**
   * Create a new instance of the Cedarling application.
   * Assume that config is `Map`
   */
  static new_from_map(config: Map<any, any>): Promise<Cedarling>;
  /**
   * Authorize request
   * makes authorization decision based on the [`Request`]
   */
  authorize(request: any): Promise<AuthorizeResult>;
  /**
   * Authorize request for unsigned principals.
   * makes authorization decision based on the [`RequestUnsigned`]
   */
  authorize_unsigned(request: any): Promise<AuthorizeResult>;
  /**
   * Get logs and remove them from the storage.
   * Returns `Array` of `Map`
   */
  pop_logs(): Array<any>;
  /**
   * Get specific log entry.
   * Returns `Map` with values or `null`.
   */
  get_log_by_id(id: string): any;
  /**
   * Returns a list of all log ids.
   * Returns `Array` of `String`
   */
  get_log_ids(): Array<any>;
  /**
   * Get logs by tag, like `log_kind` or `log level`.
   * Tag can be `log_kind`, `log_level`.
   */
  get_logs_by_tag(tag: string): any[];
  /**
   * Get logs by request_id.
   * Return log entries that match the given request_id.
   */
  get_logs_by_request_id(request_id: string): any[];
  /**
   * Get log by request_id and tag, like composite key `request_id` + `log_kind`.
   * Tag can be `log_kind`, `log_level`.
   * Return log entries that match the given request_id and tag.
   */
  get_logs_by_request_id_and_tag(request_id: string, tag: string): any[];
  /**
   * Closes the connections to the Lock Server and pushes all available logs.
   */
  shut_down(): Promise<void>;
}
/**
 * Diagnostics
 * ===========
 *
 * Provides detailed information about how a policy decision was made, including policies that contributed to the decision and any errors encountered during evaluation.
 */
export class Diagnostics {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  /**
   * `PolicyId`s of the policies that contributed to the decision.
   * If no policies applied to the request, this set will be empty.
   *
   * The ids should be treated as unordered,
   */
  readonly reason: string[];
  /**
   * Errors that occurred during authorization. The errors should be
   * treated as unordered, since policies may be evaluated in any order.
   */
  readonly errors: PolicyEvaluationError[];
}
export class JsJsonLogic {
  free(): void;
  [Symbol.dispose](): void;
  constructor();
  apply(logic: any, data: any): any;
}
/**
 * PolicyEvaluationError
 * =====================
 *
 * Represents an error that occurred when evaluating a Cedar policy.
 */
export class PolicyEvaluationError {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  /**
   * Id of the policy with an error
   */
  readonly id: string;
  /**
   * Underlying evaluation error string representation
   */
  readonly error: string;
}

export type InitInput = RequestInfo | URL | Response | BufferSource | WebAssembly.Module;

export interface InitOutput {
  readonly memory: WebAssembly.Memory;
  readonly __wbg_cedarling_free: (a: number, b: number) => void;
  readonly init: (a: any) => any;
  readonly cedarling_new: (a: any) => any;
  readonly cedarling_new_from_map: (a: any) => any;
  readonly cedarling_authorize: (a: number, b: any) => any;
  readonly cedarling_authorize_unsigned: (a: number, b: any) => any;
  readonly cedarling_pop_logs: (a: number) => [number, number, number];
  readonly cedarling_get_log_by_id: (a: number, b: number, c: number) => [number, number, number];
  readonly cedarling_get_log_ids: (a: number) => any;
  readonly cedarling_get_logs_by_tag: (a: number, b: number, c: number) => [number, number, number, number];
  readonly cedarling_get_logs_by_request_id: (a: number, b: number, c: number) => [number, number, number, number];
  readonly cedarling_get_logs_by_request_id_and_tag: (a: number, b: number, c: number, d: number, e: number) => [number, number, number, number];
  readonly cedarling_shut_down: (a: number) => any;
  readonly __wbg_authorizeresult_free: (a: number, b: number) => void;
  readonly __wbg_get_authorizeresult_workload: (a: number) => number;
  readonly __wbg_set_authorizeresult_workload: (a: number, b: number) => void;
  readonly __wbg_get_authorizeresult_person: (a: number) => number;
  readonly __wbg_set_authorizeresult_person: (a: number, b: number) => void;
  readonly __wbg_get_authorizeresult_decision: (a: number) => number;
  readonly __wbg_set_authorizeresult_decision: (a: number, b: number) => void;
  readonly __wbg_get_authorizeresult_request_id: (a: number) => [number, number];
  readonly __wbg_set_authorizeresult_request_id: (a: number, b: number, c: number) => void;
  readonly authorizeresult_json_string: (a: number) => [number, number];
  readonly authorizeresult_principal: (a: number, b: number, c: number) => number;
  readonly __wbg_authorizeresultresponse_free: (a: number, b: number) => void;
  readonly authorizeresultresponse_decision: (a: number) => number;
  readonly authorizeresultresponse_diagnostics: (a: number) => number;
  readonly __wbg_diagnostics_free: (a: number, b: number) => void;
  readonly diagnostics_reason: (a: number) => [number, number];
  readonly diagnostics_errors: (a: number) => [number, number];
  readonly __wbg_policyevaluationerror_free: (a: number, b: number) => void;
  readonly policyevaluationerror_id: (a: number) => [number, number];
  readonly policyevaluationerror_error: (a: number) => [number, number];
  readonly __wbg_jsjsonlogic_free: (a: number, b: number) => void;
  readonly jsjsonlogic_new: () => number;
  readonly jsjsonlogic_apply: (a: number, b: any, c: any) => [number, number, number];
  readonly ring_core_0_17_14__bn_mul_mont: (a: number, b: number, c: number, d: number, e: number, f: number) => void;
  readonly wasm_bindgen__convert__closures_____invoke__hf8ac7184f86fbcce: (a: number, b: number) => void;
  readonly wasm_bindgen__closure__destroy__ha0787d3d14449f11: (a: number, b: number) => void;
  readonly wasm_bindgen__convert__closures_____invoke__h1c715d53d5a00020: (a: number, b: number, c: any) => void;
  readonly wasm_bindgen__closure__destroy__h8bb11a3ec59bf31f: (a: number, b: number) => void;
  readonly wasm_bindgen__convert__closures_____invoke__h4b59ba169ea05287: (a: number, b: number, c: any, d: any) => void;
  readonly __wbindgen_malloc: (a: number, b: number) => number;
  readonly __wbindgen_realloc: (a: number, b: number, c: number, d: number) => number;
  readonly __wbindgen_exn_store: (a: number) => void;
  readonly __externref_table_alloc: () => number;
  readonly __wbindgen_externrefs: WebAssembly.Table;
  readonly __externref_table_dealloc: (a: number) => void;
  readonly __externref_drop_slice: (a: number, b: number) => void;
  readonly __wbindgen_free: (a: number, b: number, c: number) => void;
  readonly __wbindgen_start: () => void;
}

export type SyncInitInput = BufferSource | WebAssembly.Module;
/**
* Instantiates the given `module`, which can either be bytes or
* a precompiled `WebAssembly.Module`.
*
* @param {{ module: SyncInitInput }} module - Passing `SyncInitInput` directly is deprecated.
*
* @returns {InitOutput}
*/
export function initSync(module: { module: SyncInitInput } | SyncInitInput): InitOutput;

/**
* If `module_or_path` is {RequestInfo} or {URL}, makes a request and
* for everything else, calls `WebAssembly.instantiate` directly.
*
* @param {{ module_or_path: InitInput | Promise<InitInput> }} module_or_path - Passing `InitInput` directly is deprecated.
*
* @returns {Promise<InitOutput>}
*/
export default function __wbg_init (module_or_path?: { module_or_path: InitInput | Promise<InitInput> } | InitInput | Promise<InitInput>): Promise<InitOutput>;
