# Installation
> `npm install --save @types/circular-dependency-plugin`

# Summary
This package contains type definitions for circular-dependency-plugin (https://github.com/aackerman/circular-dependency-plugin).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/circular-dependency-plugin.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/circular-dependency-plugin/index.d.ts)
````ts
/// <reference types="node" />
import { Compilation, Compiler, Module, WebpackPluginInstance } from "webpack";

export = CircularDependencyPlugin;

/**
 * Detect modules with circular dependencies when bundling with webpack.
 */
declare class CircularDependencyPlugin implements WebpackPluginInstance {
    constructor(options?: CircularDependencyPlugin.Options);

    apply(compiler: Compiler): void;
    // Not exposing `isCyclic` because it isn't meant to be public, I believe
}

declare namespace CircularDependencyPlugin {
    interface Options {
        /**
         * @default false
         */
        allowAsyncCycles?: boolean | undefined;
        /**
         * @default process.cwd()
         */
        cwd?: string | undefined;
        /**
         * @default /$^/
         */
        exclude?: RegExp | undefined;
        /**
         * @default /.*\/
         */
        include?: RegExp | undefined;
        /**
         * @default false
         */
        failOnError?: boolean | undefined;
        /**
         * @default false
         */
        onDetected?:
            | false
            | ((x: {
                module: Module;
                paths: string[];
                compilation: Compilation;
            }) => void)
            | undefined;
        onEnd?: ((x: { compilation: Compilation }) => void) | undefined;
        onStart?: ((x: { compilation: Compilation }) => void) | undefined;
    }
}

````

### Additional Details
 * Last updated: Mon, 06 Nov 2023 22:41:05 GMT
 * Dependencies: [@types/node](https://npmjs.com/package/@types/node), [webpack](https://npmjs.com/package/webpack)

# Credits
These definitions were written by [Olegs Jeremejevs](https://github.com/jeremejevs).
