import warning from 'warning';
let warned = {};
export default function warn(falseToWarn, message, ...args) {
    if (!falseToWarn && message.indexOf('deprecated') !== -1) {
        if (warned[message]) {
            return;
        }
        warned[message] = true;
    }
    warning(falseToWarn, `[react-bootstrap-typeahead] ${message}`, ...args);
}
export function resetWarned() {
    warned = {};
}
