/**
 * Copyright 2017 - 2025 IBM Corporation.
 * SPDX-License-Identifier: Apache2.0
 */

module.exports = {
  acceptAndReturnModels: require('./accept-and-return-models'),
  allowedKeywords: require('./allowed-keywords'),
  anchoredPatterns: require('./anchored-patterns'),
  apiSymmetry: require('./api-symmetry'),
  arrayAttributes: require('./array-attributes'),
  arrayOfArrays: require('./array-of-arrays'),
  arrayResponses: require('./array-responses'),
  avoidMultipleTypes: require('./avoid-multiple-types'),
  binarySchemas: require('./binary-schemas'),
  circularRefs: require('./circular-refs'),
  collectionArrayProperty: require('./collection-array-property'),
  consecutivePathSegments: require('./consecutive-path-segments'),
  deleteBody: require('./delete-body'),
  disallowedHeaderParameter: require('./disallowed-header-parameter'),
  discriminatorPropertyExists: require('./discriminator-property-exists'),
  duplicatePathParameter: require('./duplicate-path-parameter'),
  enumCasingConvention: require('./enum-casing-convention'),
  errorResponseSchemas: require('./error-response-schemas'),
  etagHeaderExists: require('./etag-header-exists'),
  inlineSchemas: require('./inline-schemas'),
  integerAttributes: require('./integer-attributes'),
  majorVersionInPath: require('./major-version-in-path'),
  mergePatchProperties: require('./merge-patch-properties'),
  noAmbiguousPaths: require('./no-ambiguous-paths'),
  noNullableProperties: require('./no-nullable-properties'),
  noOperationRequestBody: require('./no-operation-requestbody'),
  noRefInExample: require('./no-ref-in-example'),
  noSuperfluousAllOf: require('./no-superfluous-allof'),
  noUnsupportedKeywords: require('./no-unsupported-keywords'),
  operationIdCasingConvention: require('./operationid-casing-convention'),
  operationIdNamingConvention: require('./operationid-naming-convention'),
  operationSummaryExists: require('./operation-summary-exists'),
  operationSummaryLength: require('./operation-summary-length'),
  optionalRequestBody: require('./optional-request-body').optionalRequestBody,
  optionalRequestBodyDeprecated: require('./optional-request-body')
    .optionalRequestBodyDeprecated,
  paginationStyle: require('./pagination-style'),
  parameterCasingConvention: require('./parameter-casing-convention'),
  parameterDefault: require('./parameter-default'),
  parameterDescriptionExists: require('./parameter-description-exists'),
  parameterOrder: require('./parameter-order'),
  patchRequestContentType: require('./patch-request-content-type'),
  pathParameterNotCRN: require('./path-parameter-not-crn'),
  pathSegmentCasingConvention: require('./path-segment-casing-convention'),
  patternPropertiesCheck: require('./pattern-properties'),
  preconditionHeader: require('./precondition-header'),
  preferTokenPagination: require('./prefer-token-pagination'),
  propertyAttributes: require('./property-attributes'),
  propertyCasingConvention: require('./property-casing-convention'),
  propertyConsistentNameAndType: require('./property-consistent-name-and-type'),
  propertyDescriptionExists: require('./property-description-exists'),
  propertyNameCollision: require('./property-name-collision'),
  redirectResponseBody: require('./redirect-response-body'),
  refPattern: require('./ref-pattern'),
  refSiblingDuplicateDescription: require('./ref-sibling-duplicate-description'),
  requestAndResponseContent: require('./request-and-response-content'),
  requestBodyName: require('./requestbody-name'),
  requiredArrayPropertiesInResponse: require('./required-array-properties-in-response'),
  requiredEnumPropertiesInResponse: require('./required-enum-properties-in-response'),
  requiredProperty: require('./required-property'),
  resourceResponseConsistency: require('./resource-response-consistency'),
  responseExampleExists: require('./response-example-exists'),
  responseStatusCodes: require('./response-status-codes'),
  schemaCasingConvention: require('./schema-casing-convention'),
  schemaDescriptionExists: require('./schema-description-exists'),
  schemaNamingConvention: require('./schema-naming-convention'),
  schemaOrContentProvided: require('./schema-or-content-provided'),
  schemaTypeExists: require('./schema-type-exists'),
  schemaTypeFormat: require('./schema-type-format'),
  securitySchemeAttributes: require('./securityscheme-attributes'),
  securitySchemes: require('./securityschemes'),
  stringAttributes: require('./string-attributes'),
  unevaluatedProperties: require('./unevaluated-properties'),
  uniqueParameterRequestPropertyNames: require('./unique-parameter-request-property-names'),
  unusedTags: require('./unused-tags'),
  useDateBasedFormat: require('./use-date-based-format'),
  validatePathSegments: require('./valid-path-segments'),
  validSchemaExample: require('./valid-schema-example'),
  wellDefinedDictionaries: require('./well-defined-dictionaries'),
};
