import { classNames, getDisplayName, hasTypeParameters, join } from "../../lib.js";
import { JSX } from "#utils";
import { ReflectionKind } from "../../../../models/index.js";
export const header = (context, props) => {
    const opts = context.options.getValue("headings");
    // Don't render on the index page or the class hierarchy page
    // We should probably someday render on the class hierarchy page, but currently breadcrumbs
    // are entirely dependent on the reflection hierarchy, so it doesn't make sense today.
    const renderBreadcrumbs = props.url !== "index.html" && props.url !== "hierarchy.html";
    // Titles are always rendered on DeclarationReflection pages and the modules page for the project.
    // They are also rendered on the readme + document pages if configured to do so by the user.
    let renderTitle;
    let titleKindString = "";
    if (props.model.isProject()) {
        if (props.url === "index.html" && props.model.readme?.length) {
            renderTitle = opts.readme;
        }
        else {
            renderTitle = true;
        }
    }
    else if (props.model.isDocument()) {
        renderTitle = opts.document;
    }
    else {
        renderTitle = true;
        titleKindString = ReflectionKind.singularString(props.model.kind) + " ";
    }
    return (JSX.createElement("div", { class: "tsd-page-title" },
        renderBreadcrumbs && context.breadcrumbs(props.model),
        renderTitle && (JSX.createElement("h1", { class: classNames({ deprecated: props.model.isDeprecated() }) },
            titleKindString,
            getDisplayName(props.model),
            hasTypeParameters(props.model) && (JSX.createElement(JSX.Fragment, null,
                "<",
                join(", ", props.model.typeParameters, (item) => item.name),
                ">")),
            context.reflectionFlags(props.model)))));
};
