import invariant from 'invariant';
import getStringLabelKey from './getStringLabelKey';
import hasOwnProperty from './hasOwnProperty';
import { isFunction, isString } from './nodash';
function getOptionLabel(option, labelKey) {
    if (!isString(option) &&
        (hasOwnProperty(option, 'paginationOption') ||
            hasOwnProperty(option, 'customOption'))) {
        return option[getStringLabelKey(labelKey)];
    }
    let optionLabel;
    if (isFunction(labelKey)) {
        optionLabel = labelKey(option);
    }
    else if (isString(option)) {
        optionLabel = option;
    }
    else {
        optionLabel = option[labelKey];
    }
    invariant(isString(optionLabel), 'One or more options does not have a valid label string. Check the ' +
        '`labelKey` prop to ensure that it matches the correct option key and ' +
        'provides a string for filtering and display.');
    return optionLabel;
}
export default getOptionLabel;
