import React from 'react';
import TypeaheadMenu from './TypeaheadMenu';
import options from '../../tests/data';
import { getOptionProperty } from '../../utils';
export default {
    title: 'Components/TypeaheadMenu',
    component: TypeaheadMenu,
};
const defaultProps = {
    id: 'typeahead-menu',
    labelKey: 'name',
    options,
    text: '',
};
const Template = (args) => (React.createElement("div", { style: { minHeight: '300px' } },
    React.createElement("div", { style: { position: 'relative' } },
        React.createElement(TypeaheadMenu, { ...args }))));
export const Default = Template.bind({});
Default.args = {
    ...defaultProps,
};
export const CustomOption = Template.bind({});
CustomOption.args = {
    ...defaultProps,
    options: [{ customOption: true, name: 'custom option' }],
    text: 'custom option',
};
export const Pagination = Template.bind({});
Pagination.args = {
    ...defaultProps,
    options: [...options.slice(0, 5), { paginationOption: true }],
};
export const CustomChildren = Template.bind({});
CustomChildren.args = {
    ...defaultProps,
    renderMenuItemChildren: (option) => {
        const name = getOptionProperty(option, 'name');
        const population = getOptionProperty(option, 'population');
        return (React.createElement(React.Fragment, null,
            React.createElement("div", null, name),
            React.createElement("div", null,
                React.createElement("small", null,
                    "Population: ",
                    population.toString()))));
    },
};
