# JansConfigApi.CacheConfigurationRedisApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigCacheRedis**](CacheConfigurationRedisApi.md#getConfigCacheRedis) | **GET** /api/v1/config/cache/redis | Returns Redis cache configuration.
[**patchConfigCacheRedis**](CacheConfigurationRedisApi.md#patchConfigCacheRedis) | **PATCH** /api/v1/config/cache/redis | Patch Redis cache configuration.
[**putConfigCacheRedis**](CacheConfigurationRedisApi.md#putConfigCacheRedis) | **PUT** /api/v1/config/cache/redis | Updates Redis cache configuration.



## getConfigCacheRedis

> RedisConfiguration getConfigCacheRedis()

Returns Redis cache configuration.

Returns Redis cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationRedisApi();
apiInstance.getConfigCacheRedis((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**RedisConfiguration**](RedisConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigCacheRedis

> RedisConfiguration patchConfigCacheRedis(opts)

Patch Redis cache configuration.

Patch Redis cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationRedisApi();
let opts = {
  'requestBody': [{ "op": "replace", "path": "/defaultPutExpiration", "value":80}] 
 // [Object] | String representing patch-document.
};
apiInstance.patchConfigCacheRedis(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**RedisConfiguration**](RedisConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## putConfigCacheRedis

> RedisConfiguration putConfigCacheRedis(opts)

Updates Redis cache configuration.

Updates Redis cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationRedisApi();
let opts = {
  'redisConfiguration': {
    "redisProviderType": "STANDALONE",
    "servers": "localhost:6379",
    "defaultPutExpiration": 60,
    "useSSL": false,
    "maxIdleConnections": 10,
    "maxTotalConnections": 500,
    "connectionTimeout": 3000,
    "soTimeout": 3000,
    "maxRetryAttempts": 5
}
 // RedisConfiguration | RedisConfiguration object
};
apiInstance.putConfigCacheRedis(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **redisConfiguration** | [**RedisConfiguration**](RedisConfiguration.md)| RedisConfiguration object | [optional] 

### Return type

[**RedisConfiguration**](RedisConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

