import { formatDistance } from "./de/_lib/formatDistance.mjs";
import { formatLong } from "./de/_lib/formatLong.mjs";
import { formatRelative } from "./de/_lib/formatRelative.mjs";
import { localize } from "./de/_lib/localize.mjs";
import { match } from "./de/_lib/match.mjs";

/**
 * @category Locales
 * @summary German locale.
 * @language German
 * @iso-639-2 deu
 * @author Thomas Eilmsteiner [@DeMuu](https://github.com/DeMuu)
 * @author Asia [@asia-t](https://github.com/asia-t)
 * @author Van Vuong Ngo [@vanvuongngo](https://github.com/vanvuongngo)
 * @author RomanErnst [@pex](https://github.com/pex)
 * @author Philipp Keck [@Philipp91](https://github.com/Philipp91)
 */
export const de = {
  code: "de",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
};

// Fallback for modularized imports:
export default de;
