Object.defineProperty(exports, '__esModule', { value: true });
//#region rolldown:runtime
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
	if (from && typeof from === "object" || typeof from === "function") for (var keys = __getOwnPropNames(from), i = 0, n = keys.length, key; i < n; i++) {
		key = keys[i];
		if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
			get: ((k) => from[k]).bind(null, key),
			enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
		});
	}
	return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
	value: mod,
	enumerable: true
}) : target, mod));

//#endregion
let __orval_core = require("@orval/core");
__orval_core = __toESM(__orval_core);
let __orval_zod = require("@orval/zod");
__orval_zod = __toESM(__orval_zod);
let fs_extra = require("fs-extra");
fs_extra = __toESM(fs_extra);
require("openapi3-ts/oas30");

//#region src/route.ts
const hasParam = (path) => /[^{]*{[\w*_-]*}.*/.test(path);
const getRoutePath = (path) => {
	const matches = /([^{]*){?([\w*_-]*)}?(.*)/.exec(path);
	if (!matches?.length) return path;
	const prev = matches[1];
	const param = (0, __orval_core.sanitize)(matches[2], {
		es5keyword: true,
		underscore: true,
		dash: true,
		dot: true
	});
	const next = hasParam(matches[3]) ? getRoutePath(matches[3]) : matches[3];
	return hasParam(path) ? `${prev}\:${param}${next}` : `${prev}${param}${next}`;
};
const getRoute = (route) => {
	return route.split("/").reduce((acc, path, i) => {
		if (!path && !i) return acc;
		if (!path.includes("{")) return `${acc}/${path}`;
		return `${acc}/${getRoutePath(path)}`;
	}, "");
};

//#endregion
//#region src/index.ts
const HONO_DEPENDENCIES = [{
	exports: [
		{
			name: "Hono",
			values: true
		},
		{ name: "Context" },
		{ name: "Env" }
	],
	dependency: "hono"
}];
const getHonoDependencies = () => HONO_DEPENDENCIES;
const getHonoHeader = ({ verbOptions, output, tag, clientImplementation }) => {
	const targetInfo = (0, __orval_core.getFileInfo)(output.target);
	let handlers = "";
	const importHandlers = Object.values(verbOptions).filter((verbOption) => clientImplementation.includes(`${verbOption.operationName}Handlers`));
	if (output.override.hono.handlers) {
		const handlerFileInfo = (0, __orval_core.getFileInfo)(output.override.hono.handlers);
		handlers = importHandlers.map((verbOption) => {
			const isTagMode = output.mode === "tags" || output.mode === "tags-split";
			const tag$1 = (0, __orval_core.kebab)(verbOption.tags[0] ?? "default");
			const handlersPath = __orval_core.upath.relativeSafe(__orval_core.upath.join(targetInfo.dirname ?? "", isTagMode ? tag$1 : ""), __orval_core.upath.join(handlerFileInfo.dirname ?? "", `./${verbOption.operationName}`));
			return `import { ${verbOption.operationName}Handlers } from '${handlersPath}';`;
		}).join("\n");
	} else handlers = `import {\n${importHandlers.map((verbOption) => ` ${verbOption.operationName}Handlers`).join(`, \n`)}\n} from './${tag ?? targetInfo.filename}.handlers';`;
	return `${handlers}\n\n
const app = new Hono()\n\n`;
};
const getHonoFooter = () => "export default app";
const generateHonoRoute = ({ operationName, verb }, pathRoute) => {
	const path = getRoute(pathRoute);
	return `
app.${verb.toLowerCase()}('${path}',...${operationName}Handlers)`;
};
const generateHono = async (verbOptions, options) => {
	if (options.override.hono.compositeRoute) return {
		implementation: "",
		imports: []
	};
	const routeImplementation = generateHonoRoute(verbOptions, options.pathRoute);
	return {
		implementation: routeImplementation ? `${routeImplementation}\n\n` : "",
		imports: [
			...verbOptions.params.flatMap((param) => param.imports),
			...verbOptions.body.imports,
			...verbOptions.queryParams ? [{ name: verbOptions.queryParams.schema.name }] : []
		]
	};
};
const getHonoHandlers = ({ handlerName, contextTypeName, verbOption, validator }) => {
	let currentValidator = "";
	if (validator) {
		if (verbOption.headers) currentValidator += `zValidator('header', ${verbOption.operationName}Header),\n`;
		if (verbOption.params.length > 0) currentValidator += `zValidator('param', ${verbOption.operationName}Params),\n`;
		if (verbOption.queryParams) currentValidator += `zValidator('query', ${verbOption.operationName}QueryParams),\n`;
		if (verbOption.body.definition) currentValidator += `zValidator('json', ${verbOption.operationName}Body),\n`;
		if (validator !== "hono" && verbOption.response.originalSchema?.["200"]?.content?.["application/json"]) currentValidator += `zValidator('response', ${verbOption.operationName}Response),\n`;
	}
	return `
export const ${handlerName} = factory.createHandlers(
${currentValidator}async (c: ${contextTypeName}) => {

  },
);`;
};
const getValidatorOutputRelativePath = (validatorOutputPath, handlerPath) => {
	const { pathWithoutExtension } = (0, __orval_core.getFileInfo)(validatorOutputPath);
	return __orval_core.upath.relativeSafe(__orval_core.upath.dirname(handlerPath), pathWithoutExtension);
};
const getZvalidatorImports = (verbOptions, importPath, isHonoValidator) => {
	const importImplementation = verbOptions.flatMap((verbOption) => {
		const imports = [];
		if (verbOption.headers) imports.push(`${verbOption.operationName}Header`);
		if (verbOption.params.length > 0) imports.push(`${verbOption.operationName}Params`);
		if (verbOption.queryParams) imports.push(`${verbOption.operationName}QueryParams`);
		if (verbOption.body.definition) imports.push(`${verbOption.operationName}Body`);
		if (!isHonoValidator && !!verbOption.response.originalSchema?.["200"]?.content?.["application/json"]) imports.push(`${verbOption.operationName}Response`);
		return imports.join(",\n");
	}).join(",\n");
	return importImplementation ? `import {\n${importImplementation}\n} from '${importPath}'` : "";
};
const getVerbOptionGroupByTag = (verbOptions) => {
	return Object.values(verbOptions).reduce((acc, value) => {
		const tag = value.tags[0];
		if (!acc[tag]) acc[tag] = [];
		acc[tag].push(value);
		return acc;
	}, {});
};
const generateHandlers = async (verbOptions, output) => {
	const { pathWithoutExtension, extension, dirname, filename } = (0, __orval_core.getFileInfo)(output.target);
	if (output.override.hono.handlers) return Promise.all(Object.values(verbOptions).map(async (verbOption) => {
		const isTagMode = output.mode === "tags" || output.mode === "tags-split";
		const tag = (0, __orval_core.kebab)(verbOption.tags[0] ?? "default");
		const outputPath = __orval_core.upath.relativeSafe(output.override.hono.handlers ?? "", isTagMode ? `${dirname}/${tag}/${tag}` : pathWithoutExtension);
		const handlerPath$1 = __orval_core.upath.join(output.override.hono.handlers ?? "", `./${verbOption.operationName}` + extension);
		const hasZValidator$1 = !!verbOption.headers || verbOption.params.length > 0 || !!verbOption.queryParams || !!verbOption.body.definition;
		const isExist = fs_extra.default.existsSync(handlerPath$1);
		const handlerName = `${verbOption.operationName}Handlers`;
		const contextTypeName = `${(0, __orval_core.pascal)(verbOption.operationName)}Context`;
		if (isExist) {
			const rawFile = await fs_extra.default.readFile(handlerPath$1, "utf8");
			let content$1 = rawFile;
			if (!rawFile.includes(handlerName)) content$1 += getHonoHandlers({
				handlerName,
				contextTypeName,
				verbOption,
				validator: output.override.hono.validator
			});
			return {
				content: content$1,
				path: handlerPath$1
			};
		}
		let validatorImport$1 = "";
		if (hasZValidator$1) {
			if (output.override.hono.validator === true) validatorImport$1 = `\nimport { zValidator } from '${output.override.hono.validatorOutputPath ? getValidatorOutputRelativePath(output.override.hono.validatorOutputPath, handlerPath$1) : `${outputPath}.validator`}';`;
			else if (output.override.hono.validator === "hono") validatorImport$1 = `\nimport { zValidator } from '@hono/zod-validator';`;
		}
		const zodImports$1 = output.override.hono.validator ? getZvalidatorImports([verbOption], `${outputPath}.zod`, output.override.hono.validator === "hono") : "";
		return {
			content: `import { createFactory } from 'hono/factory';${validatorImport$1}
import { ${contextTypeName} } from '${outputPath}.context';
${zodImports$1}

const factory = createFactory();

${getHonoHandlers({
				handlerName,
				contextTypeName,
				verbOption,
				validator: output.override.hono.validator
			})}
`,
			path: handlerPath$1
		};
	}));
	if (output.mode === "tags" || output.mode === "tags-split") {
		const groupByTags = getVerbOptionGroupByTag(verbOptions);
		return Promise.all(Object.entries(groupByTags).map(async ([tag, verbs]) => {
			const handlerPath$1 = output.mode === "tags" ? __orval_core.upath.join(dirname, `${(0, __orval_core.kebab)(tag)}.handlers${extension}`) : __orval_core.upath.join(dirname, tag, tag + ".handlers" + extension);
			const hasZValidator$1 = verbs.some((verb) => !!verb.headers || verb.params.length > 0 || !!verb.queryParams || !!verb.body.definition);
			if (fs_extra.default.existsSync(handlerPath$1)) {
				const rawFile = await fs_extra.default.readFile(handlerPath$1, "utf8");
				let content$2 = rawFile;
				content$2 += Object.values(verbs).reduce((acc, verbOption) => {
					const handlerName = `${verbOption.operationName}Handlers`;
					const contextTypeName = `${(0, __orval_core.pascal)(verbOption.operationName)}Context`;
					if (!rawFile.includes(handlerName)) acc += getHonoHandlers({
						handlerName,
						contextTypeName,
						verbOption,
						validator: output.override.hono.validator
					});
					return acc;
				}, "");
				return {
					content: content$2,
					path: handlerPath$1
				};
			}
			let validatorImport$1 = "";
			if (hasZValidator$1) {
				if (output.override.hono.validator === true) {
					const validatorOutputPath = output.override.hono.validatorOutputPath || `${dirname}/${filename}.validator${extension}`;
					validatorImport$1 = `\nimport { zValidator } from '${getValidatorOutputRelativePath(validatorOutputPath, handlerPath$1)}';`;
				} else if (output.override.hono.validator === "hono") validatorImport$1 = `\nimport { zValidator } from '@hono/zod-validator';`;
			}
			const outputRelativePath$1 = `./${(0, __orval_core.kebab)(tag)}`;
			const zodImports$1 = output.override.hono.validator ? getZvalidatorImports(Object.values(verbs), `${outputRelativePath$1}.zod`, output.override.hono.validator === "hono") : "";
			let content$1 = `import { createFactory } from 'hono/factory';${validatorImport$1}
import { ${Object.values(verbs).map((verb) => `${(0, __orval_core.pascal)(verb.operationName)}Context`).join(",\n")} } from '${outputRelativePath$1}.context';
${zodImports$1}

const factory = createFactory();`;
			content$1 += Object.values(verbs).reduce((acc, verbOption) => {
				const handlerName = `${verbOption.operationName}Handlers`;
				const contextTypeName = `${(0, __orval_core.pascal)(verbOption.operationName)}Context`;
				acc += getHonoHandlers({
					handlerName,
					contextTypeName,
					verbOption,
					validator: output.override.hono.validator
				});
				return acc;
			}, "");
			return {
				content: content$1,
				path: handlerPath$1
			};
		}));
	}
	const hasZValidator = Object.values(verbOptions).some((verb) => !!verb.headers || verb.params.length > 0 || !!verb.queryParams || !!verb.body.definition || verb.response.contentTypes.length === 1 && verb.response.contentTypes[0] === "application/json");
	const handlerPath = __orval_core.upath.join(dirname, `${filename}.handlers${extension}`);
	if (fs_extra.default.existsSync(handlerPath)) {
		const rawFile = await fs_extra.default.readFile(handlerPath, "utf8");
		let content$1 = rawFile;
		content$1 += Object.values(verbOptions).reduce((acc, verbOption) => {
			const handlerName = `${verbOption.operationName}Handlers`;
			const contextTypeName = `${(0, __orval_core.pascal)(verbOption.operationName)}Context`;
			if (!rawFile.includes(handlerName)) acc += getHonoHandlers({
				handlerName,
				contextTypeName,
				verbOption,
				validator: output.override.hono.validator
			});
			return acc;
		}, "");
		return [{
			content: content$1,
			path: handlerPath
		}];
	}
	const outputRelativePath = `./${filename}`;
	let validatorImport = "";
	if (hasZValidator) {
		if (output.override.hono.validator === true) validatorImport = `\nimport { zValidator } from '${output.override.hono.validatorOutputPath ? getValidatorOutputRelativePath(output.override.hono.validatorOutputPath, handlerPath) : `${outputRelativePath}.validator`}';`;
		else if (output.override.hono.validator === "hono") validatorImport = `\nimport { zValidator } from '@hono/zod-validator';`;
	}
	const zodImports = output.override.hono.validator ? getZvalidatorImports(Object.values(verbOptions), `${outputRelativePath}.zod`, output.override.hono.validator === "hono") : "";
	let content = `import { createFactory } from 'hono/factory';${validatorImport}
import { ${Object.values(verbOptions).map((verb) => `${(0, __orval_core.pascal)(verb.operationName)}Context`).join(",\n")} } from '${outputRelativePath}.context';
${zodImports}

const factory = createFactory();`;
	content += Object.values(verbOptions).reduce((acc, verbOption) => {
		const handlerName = `${verbOption.operationName}Handlers`;
		const contextTypeName = `${(0, __orval_core.pascal)(verbOption.operationName)}Context`;
		acc += getHonoHandlers({
			handlerName,
			contextTypeName,
			verbOption,
			validator: output.override.hono.validator
		});
		return acc;
	}, "");
	return [{
		content,
		path: handlerPath
	}];
};
const getContext = (verbOption) => {
	let paramType = "";
	if (verbOption.params.length > 0) paramType = `param: {\n ${(0, __orval_core.getParamsInPath)(verbOption.pathRoute).map((name) => {
		const param = verbOption.params.find((p) => p.name === (0, __orval_core.sanitize)((0, __orval_core.camel)(name), { es5keyword: true }));
		const definition = param?.definition.split(":")[1];
		const required = param?.required ?? false;
		return { definition: `${name}${required ? "" : "?"}:${definition}` };
	}).map((property) => property.definition).join(",\n    ")},\n },`;
	const queryType = verbOption.queryParams ? `query: ${verbOption.queryParams?.schema.name},` : "";
	const bodyType = verbOption.body.definition ? `json: ${verbOption.body.definition},` : "";
	const hasIn = !!paramType || !!queryType || !!bodyType;
	return `export type ${(0, __orval_core.pascal)(verbOption.operationName)}Context<E extends Env = any> = Context<E, '${getRoute(verbOption.pathRoute)}'${hasIn ? `, { in: { ${paramType}${queryType}${bodyType} }, out: { ${paramType}${queryType}${bodyType} } }` : ""}>`;
};
const getHeader = (option, info) => {
	if (!option) return "";
	const header = option(info);
	return Array.isArray(header) ? (0, __orval_core.jsDoc)({ description: header }) : header;
};
const generateContext = async (verbOptions, output, context) => {
	const header = getHeader(output.override.header, context.specs[context.specKey].info);
	const { extension, dirname, filename } = (0, __orval_core.getFileInfo)(output.target);
	if (output.mode === "tags" || output.mode === "tags-split") {
		const groupByTags = getVerbOptionGroupByTag(verbOptions);
		let relativeSchemasPath$1 = output.mode === "tags-split" ? "../" : "";
		relativeSchemasPath$1 += output.schemas ? __orval_core.upath.relativeSafe(dirname, (0, __orval_core.getFileInfo)(output.schemas).dirname) : `${filename}.schemas`;
		return Promise.all(Object.entries(groupByTags).map(async ([tag, verbs]) => {
			let content$1 = `${header}import type { Context, Env } from 'hono';\n\n`;
			const contexts$1 = verbs.map((verb) => getContext(verb)).join("\n");
			const imps$1 = verbs.flatMap((verb) => {
				const imports = [];
				if (verb.params.length > 0) imports.push(...verb.params.flatMap((param) => param.imports));
				if (verb.queryParams) imports.push({ name: verb.queryParams.schema.name });
				if (verb.body.definition) imports.push(...verb.body.imports);
				return imports;
			}).filter((imp) => contexts$1.includes(imp.name)).filter((imp, i, arr) => arr.findIndex((v) => v.name === imp.name) === i);
			if (contexts$1.includes("NonReadonly<")) {
				content$1 += (0, __orval_core.getOrvalGeneratedTypes)();
				content$1 += "\n";
			}
			if (imps$1.length > 0) {
				const importSchemas = imps$1.map((imp) => imp.name).join(",\n  ");
				content$1 += `import {\n  ${importSchemas}\n} from '${relativeSchemasPath$1}';\n\n`;
			}
			content$1 += contexts$1;
			const contextPath$1 = output.mode === "tags" ? __orval_core.upath.join(dirname, `${(0, __orval_core.kebab)(tag)}.context${extension}`) : __orval_core.upath.join(dirname, tag, tag + ".context" + extension);
			return {
				content: content$1,
				path: contextPath$1
			};
		}));
	}
	let content = `${header}import type { Context, Env } from 'hono';\n\n`;
	const contextPath = __orval_core.upath.join(dirname, `${filename}.context${extension}`);
	const contexts = Object.values(verbOptions).map((verbOption) => getContext(verbOption)).join("\n");
	const imps = Object.values(verbOptions).flatMap((verb) => {
		const imports = [];
		if (verb.params.length > 0) imports.push(...verb.params.flatMap((param) => param.imports));
		if (verb.queryParams) imports.push({ name: verb.queryParams.schema.name });
		if (verb.body.definition) imports.push(...verb.body.imports);
		return imports;
	}).filter((imp) => contexts.includes(imp.name)).filter((imp, i, arr) => arr.findIndex((v) => v.name === imp.name) === i);
	if (contexts.includes("NonReadonly<")) {
		content += (0, __orval_core.getOrvalGeneratedTypes)();
		content += "\n";
	}
	const relativeSchemasPath = output.schemas ? __orval_core.upath.relativeSafe(dirname, (0, __orval_core.getFileInfo)(output.schemas).dirname) : "./" + filename + ".schemas";
	content += `import { ${imps.map((imp) => imp.name).join(",\n")} } from '${relativeSchemasPath}';\n\n`;
	content += contexts;
	return [{
		content,
		path: contextPath
	}];
};
const generateZodFiles = async (verbOptions, output, context) => {
	const { extension, dirname, filename } = (0, __orval_core.getFileInfo)(output.target);
	const header = getHeader(output.override.header, context.specs[context.specKey].info);
	if (output.mode === "tags" || output.mode === "tags-split") {
		const groupByTags = getVerbOptionGroupByTag(verbOptions);
		const builderContexts = await Promise.all(Object.entries(groupByTags).map(async ([tag, verbs]) => {
			const zods$1 = await Promise.all(verbs.map((verbOption) => (0, __orval_zod.generateZod)(verbOption, {
				route: verbOption.route,
				pathRoute: verbOption.pathRoute,
				override: output.override,
				context,
				mock: output.mock,
				output: output.target
			}, output.client)));
			if (zods$1.every((z) => z.implementation === "")) return {
				content: "",
				path: ""
			};
			const allMutators$1 = zods$1.reduce((acc, z) => {
				for (const mutator of z.mutators ?? []) acc[mutator.name] = mutator;
				return acc;
			}, {});
			const mutatorsImports$1 = (0, __orval_core.generateMutatorImports)({ mutators: Object.values(allMutators$1) });
			let content$1 = `${header}import { z as zod } from 'zod';\n${mutatorsImports$1}\n`;
			const zodPath$1 = output.mode === "tags" ? __orval_core.upath.join(dirname, `${(0, __orval_core.kebab)(tag)}.zod${extension}`) : __orval_core.upath.join(dirname, tag, tag + ".zod" + extension);
			content$1 += zods$1.map((zod) => zod.implementation).join("\n");
			return {
				content: content$1,
				path: zodPath$1
			};
		}));
		return Promise.all(builderContexts.filter((context$1) => context$1.content !== ""));
	}
	const zods = await Promise.all(Object.values(verbOptions).map((verbOption) => (0, __orval_zod.generateZod)(verbOption, {
		route: verbOption.route,
		pathRoute: verbOption.pathRoute,
		override: output.override,
		context,
		mock: output.mock,
		output: output.target
	}, output.client)));
	const allMutators = zods.reduce((acc, z) => {
		for (const mutator of z.mutators ?? []) acc[mutator.name] = mutator;
		return acc;
	}, {});
	const mutatorsImports = (0, __orval_core.generateMutatorImports)({ mutators: Object.values(allMutators) });
	let content = `${header}import { z as zod } from 'zod';\n${mutatorsImports}\n`;
	const zodPath = __orval_core.upath.join(dirname, `${filename}.zod${extension}`);
	content += zods.map((zod) => zod.implementation).join("\n");
	return [{
		content,
		path: zodPath
	}];
};
const generateZvalidator = (output, context) => {
	const header = getHeader(output.override.header, context.specs[context.specKey].info);
	const content = `
// based on https://github.com/honojs/middleware/blob/main/packages/zod-validator/src/index.ts
import type { z, ZodSchema, ZodError } from 'zod';
import {
  Context,
  Env,
  Input,
  MiddlewareHandler,
  TypedResponse,
  ValidationTargets,
} from 'hono';

type HasUndefined<T> = undefined extends T ? true : false;

type Hook<T, E extends Env, P extends string, O = {}> = (
  result:
    | { success: true; data: T }
    | { success: false; error: ZodError; data: T },
  c: Context<E, P>,
) =>
  | Response
  | Promise<Response>
  | void
  | Promise<Response | void>
  | TypedResponse<O>;
import { zValidator as zValidatorBase } from '@hono/zod-validator';

type ValidationTargetsWithResponse = ValidationTargets & { response: any };

export const zValidator =
  <
    T extends ZodSchema,
    Target extends keyof ValidationTargetsWithResponse,
    E extends Env,
    P extends string,
    In = z.input<T>,
    Out = z.output<T>,
    I extends Input = {
      in: HasUndefined<In> extends true
        ? {
            [K in Target]?: K extends 'json'
              ? In
              : HasUndefined<
                  keyof ValidationTargetsWithResponse[K]
                > extends true
              ? { [K2 in keyof In]?: ValidationTargetsWithResponse[K][K2] }
              : { [K2 in keyof In]: ValidationTargetsWithResponse[K][K2] };
          }
        : {
            [K in Target]: K extends 'json'
              ? In
              : HasUndefined<
                  keyof ValidationTargetsWithResponse[K]
                > extends true
              ? { [K2 in keyof In]?: ValidationTargetsWithResponse[K][K2] }
              : { [K2 in keyof In]: ValidationTargetsWithResponse[K][K2] };
          };
      out: { [K in Target]: Out };
    },
    V extends I = I,
  >(
    target: Target,
    schema: T,
    hook?: Hook<z.infer<T>, E, P>,
  ): MiddlewareHandler<E, P, V> =>
  async (c, next) => {
    if (target !== 'response') {
      const value = await zValidatorBase<
        T,
        keyof ValidationTargets,
        E,
        P,
        In,
        Out,
        I,
        V
      >(
        target,
        schema,
        hook,
      )(c, next);

      if (value instanceof Response) {
        return value;
      }
    } else {
      await next();

      if (
        c.res.status !== 200 ||
       !c.res.headers.get('Content-Type')?.includes('application/json')
      ) {
        return;
      }

      let value: unknown;
      try {
        value = await c.res.json();
      } catch {
        const message = 'Malformed JSON in response';
        c.res = new Response(message, { status: 400 });

        return;
      }

      const result = await schema.safeParseAsync(value);

      if (hook) {
        const hookResult = hook({ data: value, ...result }, c);
        if (hookResult) {
          if (hookResult instanceof Response || hookResult instanceof Promise) {
            const hookResponse = await hookResult;

            if (hookResponse instanceof Response) {
              c.res = new Response(hookResponse.body, hookResponse);
            }
          }
          if (
            'response' in hookResult &&
            hookResult.response instanceof Response
          ) {
            c.res = new Response(hookResult.response.body, hookResult.response);
          }
        }
      }

      if (!result.success) {
        c.res = new Response(JSON.stringify(result), {
          status: 400,
          headers: {
            'Content-Type': 'application/json',
          },
        });
      } else {
        c.res = new Response(JSON.stringify(result.data), c.res);
      }
    }
    
    return;
  };
`;
	let validatorPath = output.override.hono.validatorOutputPath;
	if (!output.override.hono.validatorOutputPath) {
		const { extension, dirname, filename } = (0, __orval_core.getFileInfo)(output.target);
		validatorPath = __orval_core.upath.join(dirname, `${filename}.validator${extension}`);
	}
	return {
		content: `${header}${content}`,
		path: validatorPath
	};
};
const generateCompositeRoutes = async (verbOptions, output, context) => {
	const targetInfo = (0, __orval_core.getFileInfo)(output.target);
	const compositeRouteInfo = (0, __orval_core.getFileInfo)(output.override.hono.compositeRoute);
	const header = getHeader(output.override.header, context.specs[context.specKey].info);
	const routes = Object.values(verbOptions).map((verbOption) => {
		return generateHonoRoute(verbOption, verbOption.pathRoute);
	}).join(";");
	const importHandlers = Object.values(verbOptions);
	let ImportHandlersImplementation = "";
	if (output.override.hono.handlers) {
		const handlerFileInfo = (0, __orval_core.getFileInfo)(output.override.hono.handlers);
		ImportHandlersImplementation = importHandlers.map((verbOption) => verbOption.operationName).map((operationName) => {
			const importHandlerName = `${operationName}Handlers`;
			const handlersPath = __orval_core.upath.relativeSafe(compositeRouteInfo.dirname, __orval_core.upath.join(handlerFileInfo.dirname ?? "", `./${operationName}`));
			return `import { ${importHandlerName} } from '${handlersPath}';`;
		}).join("\n");
	} else {
		const tags = importHandlers.map((verbOption) => (0, __orval_core.kebab)(verbOption.tags[0] ?? "default"));
		ImportHandlersImplementation = tags.filter((t, i) => tags.indexOf(t) === i).map((tag) => {
			const importHandlerNames = importHandlers.filter((verbOption) => verbOption.tags[0] === tag).map((verbOption) => ` ${verbOption.operationName}Handlers`).join(`, \n`);
			const handlersPath = __orval_core.upath.relativeSafe(compositeRouteInfo.dirname, __orval_core.upath.join(targetInfo.dirname ?? "", tag));
			return `import {\n${importHandlerNames}\n} from '${handlersPath}/${tag}.handlers';`;
		}).join("\n");
	}
	return [{
		content: `${header}import { Hono } from 'hono';
${ImportHandlersImplementation}

const app = new Hono()
${routes}

export default app
`,
		path: output.override.hono.compositeRoute || ""
	}];
};
const generateExtraFiles = async (verbOptions, output, context) => {
	const [handlers, contexts, zods, validator, compositeRoutes] = await Promise.all([
		generateHandlers(verbOptions, output),
		generateContext(verbOptions, output, context),
		generateZodFiles(verbOptions, output, context),
		generateZvalidator(output, context),
		output.override.hono.compositeRoute ? generateCompositeRoutes(verbOptions, output, context) : []
	]);
	return [
		...handlers,
		...contexts,
		...zods,
		...output.override.hono.validator && output.override.hono.validator !== "hono" ? [validator] : [],
		...compositeRoutes
	];
};
const honoClientBuilder = {
	client: generateHono,
	dependencies: getHonoDependencies,
	header: getHonoHeader,
	footer: getHonoFooter,
	extraFiles: generateExtraFiles
};
const builder = () => () => honoClientBuilder;
var src_default = builder;

//#endregion
exports.builder = builder;
exports.default = src_default;
exports.generateExtraFiles = generateExtraFiles;
exports.generateHono = generateHono;
exports.getHonoDependencies = getHonoDependencies;
exports.getHonoFooter = getHonoFooter;
exports.getHonoHeader = getHonoHeader;
//# sourceMappingURL=index.js.map