# JansConfigApi.TrustRelationship

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**dn** | **String** |  | [optional] 
**inum** | **String** | Unique identifier | [optional] 
**owner** | **String** | Creator of Trust Relationship. | [optional] 
**name** | **String** | The alphanumeric ID string that is used to identify the Trust Relationship. | 
**displayName** | **String** | Trust Relationship display name. | 
**description** | **String** | Description of the Trust Relationship. | 
**baseUrl** | **String** | URL to use when the auth server needs to redirect. | [optional] 
**enabled** | **Boolean** | Indicates if Trust Relationship is enabled. | [optional] 
**alwaysDisplayInConsole** | **Boolean** | Indicates if Trust Relationship should always be listed in the UI. | [optional] 
**clientAuthenticatorType** | **String** | Preferred Authenticator Type. | [optional] 
**secret** | **String** | Client secret. | [optional] 
**registrationAccessToken** | **String** | Registration access token. | [optional] 
**consentRequired** | **Boolean** | Boolean value if consent is required. | [optional] 
**spMetaDataSourceType** | **String** | Trust Relationship SP metadata type - file, URI. | 
**samlMetadata** | [**SAMLMetadata**](SAMLMetadata.md) |  | [optional] 
**redirectUris** | **[String]** | List of valid Redirect URI. | [optional] 
**spMetaDataURL** | **String** | SAML entity metadata file URL. | [optional] 
**metaLocation** | **String** | Trust Relationship metadata file location. | [optional] 
**releasedAttributes** | **[String]** | Trust Relationship attributes that will be released to SAML server. | [optional] 
**spLogoutURL** | **String** | Logout request URL. | [optional] 
**status** | **String** | Trust Relationship setup status. | [optional] 
**validationStatus** | **String** | Trust Relationship validation status. | [optional] 
**validationLog** | **[String]** | Validation log. | [optional] 
**profileConfigurations** | [**{String: ProfileConfiguration}**](ProfileConfiguration.md) | List of profile configuration. | [optional] 
**baseDn** | **String** |  | [optional] 



## Enum: SpMetaDataSourceTypeEnum


* `file` (value: `"file"`)

* `manual` (value: `"manual"`)





## Enum: StatusEnum


* `active` (value: `"active"`)

* `inactive` (value: `"inactive"`)

* `expired` (value: `"expired"`)

* `register` (value: `"register"`)





## Enum: ValidationStatusEnum


* `In Progress` (value: `"In Progress"`)

* `Success` (value: `"Success"`)

* `Scheduled` (value: `"Scheduled"`)

* `Failed` (value: `"Failed"`)




