# JansConfigApi.AdminUILicenseApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**activateAdminuiLicense**](AdminUILicenseApi.md#activateAdminuiLicense) | **POST** /admin-ui/license/activate | Activate license using license-key
[**adminuiPostSsa**](AdminUILicenseApi.md#adminuiPostSsa) | **POST** /admin-ui/license/ssa | Save SSA in configuration
[**checkAdminuiLicenseConfig**](AdminUILicenseApi.md#checkAdminuiLicenseConfig) | **GET** /admin-ui/license/isConfigValid | Is license configuration valid
[**getAdminuiLicense**](AdminUILicenseApi.md#getAdminuiLicense) | **GET** /admin-ui/license/details | Get admin ui license details
[**getTrialLicense**](AdminUILicenseApi.md#getTrialLicense) | **GET** /admin-ui/license/trial | Generate trial license
[**isLicenseActive**](AdminUILicenseApi.md#isLicenseActive) | **GET** /admin-ui/license/isActive | Check if admin-ui license is active
[**licenseConfigDelete**](AdminUILicenseApi.md#licenseConfigDelete) | **DELETE** /admin-ui/license/deleteConfig | Delete license details in admin-ui configuration
[**retrieveLicense**](AdminUILicenseApi.md#retrieveLicense) | **GET** /admin-ui/license/retrieve | Retrieve license from SCAN



## activateAdminuiLicense

> GenericResponse activateAdminuiLicense(opts)

Activate license using license-key

Activate license using license-key

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUILicenseApi();
let opts = {
  'licenseRequest': new JansConfigApi.LicenseRequest() // LicenseRequest | LicenseRequest object
};
apiInstance.activateAdminuiLicense(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **licenseRequest** | [**LicenseRequest**](LicenseRequest.md)| LicenseRequest object | [optional] 

### Return type

[**GenericResponse**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## adminuiPostSsa

> GenericResponse adminuiPostSsa(opts)

Save SSA in configuration

Save SSA in configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUILicenseApi();
let opts = {
  'sSARequest': new JansConfigApi.SSARequest() // SSARequest | SSARequest object
};
apiInstance.adminuiPostSsa(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sSARequest** | [**SSARequest**](SSARequest.md)| SSARequest object | [optional] 

### Return type

[**GenericResponse**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## checkAdminuiLicenseConfig

> GenericResponse checkAdminuiLicenseConfig()

Is license configuration valid

Is license configuration valid

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUILicenseApi();
apiInstance.checkAdminuiLicenseConfig((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GenericResponse**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAdminuiLicense

> LicenseResponse getAdminuiLicense()

Get admin ui license details

Get admin ui license details

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUILicenseApi();
apiInstance.getAdminuiLicense((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**LicenseResponse**](LicenseResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getTrialLicense

> GenericResponse getTrialLicense()

Generate trial license

Generate trial license

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUILicenseApi();
apiInstance.getTrialLicense((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GenericResponse**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## isLicenseActive

> GenericResponse isLicenseActive()

Check if admin-ui license is active

Check if admin-ui license is active

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUILicenseApi();
apiInstance.isLicenseActive((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GenericResponse**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## licenseConfigDelete

> GenericResponse licenseConfigDelete()

Delete license details in admin-ui configuration

Delete license details in admin-ui configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUILicenseApi();
apiInstance.licenseConfigDelete((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GenericResponse**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## retrieveLicense

> GenericResponse retrieveLicense()

Retrieve license from SCAN

Retrieve license from SCAN

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUILicenseApi();
apiInstance.retrieveLicense((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GenericResponse**](GenericResponse.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

