import React, { useState } from 'react';
import TypeaheadInputSingle from './TypeaheadInputSingle';
import { HintProvider, noop } from '../../tests/helpers';
export default {
    title: 'Components/TypeaheadInputSingle',
    component: TypeaheadInputSingle,
};
const Template = ({ hintText = '', ...args }) => {
    const [inputNode, setInputNode] = useState(null);
    return (React.createElement(HintProvider, { hintText: hintText, inputNode: inputNode },
        React.createElement(TypeaheadInputSingle, { ...args, inputRef: setInputNode, referenceElementRef: noop })));
};
export const Default = Template.bind({});
Default.args = {
    placeholder: 'This is a default input...',
};
export const Disabled = Template.bind({});
Disabled.args = {
    disabled: true,
    placeholder: 'This is a disabled input...',
};
export const Small = Template.bind({});
Small.args = {
    placeholder: 'This is a small input...',
    size: 'sm',
};
export const Large = Template.bind({});
Large.args = {
    placeholder: 'This is a large input...',
    size: 'lg',
};
export const Valid = Template.bind({});
Valid.args = {
    placeholder: 'This is a valid input...',
    isValid: true,
};
export const Invalid = Template.bind({});
Invalid.args = {
    placeholder: 'This is an invalid input...',
    isInvalid: true,
};
export const WithHint = Template.bind({});
WithHint.args = {
    hintText: 'California',
    onChange: noop,
    value: 'Ca',
};
