import cx from 'classnames';
import { isSizeLarge, isSizeSmall } from './size';
export default function propsWithBsClassName({ className, isInvalid, isValid, size, ...props }) {
    return {
        ...props,
        className: cx('form-control', 'rbt-input', {
            'form-control-lg': isSizeLarge(size),
            'form-control-sm': isSizeSmall(size),
            'is-invalid': isInvalid,
            'is-valid': isValid,
        }, className),
    };
}
