import PropTypes from 'prop-types';
import React, { ComponentType, HTMLProps, MouseEvent, MouseEventHandler } from 'react';
import { preventInputBlur } from '../utils';
import { Option } from '../types';
export interface UseItemProps<T> extends HTMLProps<T> {
    onClick?: MouseEventHandler<T>;
    option: Option;
    position: number;
}
export declare function useItem<T extends HTMLElement>({ label, onClick, option, position, ...props }: UseItemProps<T>): {
    active: boolean;
    'aria-label': string | undefined;
    'aria-selected': boolean;
    id: string;
    onClick: (e: MouseEvent<T>) => void;
    onMouseDown: typeof preventInputBlur;
    ref: React.RefObject<T>;
    role: string;
    accept?: string | undefined;
    acceptCharset?: string | undefined;
    action?: string | undefined;
    allowFullScreen?: boolean | undefined;
    allowTransparency?: boolean | undefined;
    alt?: string | undefined;
    as?: string | undefined;
    async?: boolean | undefined;
    autoComplete?: string | undefined;
    autoPlay?: boolean | undefined;
    capture?: boolean | "user" | "environment" | undefined;
    cellPadding?: string | number | undefined;
    cellSpacing?: string | number | undefined;
    charSet?: string | undefined;
    challenge?: string | undefined;
    checked?: boolean | undefined;
    cite?: string | undefined;
    classID?: string | undefined;
    cols?: number | undefined;
    colSpan?: number | undefined;
    controls?: boolean | undefined;
    coords?: string | undefined;
    crossOrigin?: "" | "anonymous" | "use-credentials" | undefined;
    data?: string | undefined;
    dateTime?: string | undefined;
    default?: boolean | undefined;
    defer?: boolean | undefined;
    disabled?: boolean | undefined;
    download?: any;
    encType?: string | undefined;
    form?: string | undefined;
    formAction?: string | undefined;
    formEncType?: string | undefined;
    formMethod?: string | undefined;
    formNoValidate?: boolean | undefined;
    formTarget?: string | undefined;
    frameBorder?: string | number | undefined;
    headers?: string | undefined;
    height?: string | number | undefined;
    high?: number | undefined;
    href?: string | undefined;
    hrefLang?: string | undefined;
    htmlFor?: string | undefined;
    httpEquiv?: string | undefined;
    integrity?: string | undefined;
    keyParams?: string | undefined;
    keyType?: string | undefined;
    kind?: string | undefined;
    list?: string | undefined;
    loop?: boolean | undefined;
    low?: number | undefined;
    manifest?: string | undefined;
    marginHeight?: number | undefined;
    marginWidth?: number | undefined;
    max?: string | number | undefined;
    maxLength?: number | undefined;
    media?: string | undefined;
    mediaGroup?: string | undefined;
    method?: string | undefined;
    min?: string | number | undefined;
    minLength?: number | undefined;
    multiple?: boolean | undefined;
    muted?: boolean | undefined;
    name?: string | undefined;
    noValidate?: boolean | undefined;
    open?: boolean | undefined;
    optimum?: number | undefined;
    pattern?: string | undefined;
    placeholder?: string | undefined;
    playsInline?: boolean | undefined;
    poster?: string | undefined;
    preload?: string | undefined;
    readOnly?: boolean | undefined;
    required?: boolean | undefined;
    reversed?: boolean | undefined;
    rows?: number | undefined;
    rowSpan?: number | undefined;
    sandbox?: string | undefined;
    scope?: string | undefined;
    scoped?: boolean | undefined;
    scrolling?: string | undefined;
    seamless?: boolean | undefined;
    selected?: boolean | undefined;
    shape?: string | undefined;
    size?: number | undefined;
    sizes?: string | undefined;
    span?: number | undefined;
    src?: string | undefined;
    srcDoc?: string | undefined;
    srcLang?: string | undefined;
    srcSet?: string | undefined;
    start?: number | undefined;
    step?: string | number | undefined;
    summary?: string | undefined;
    target?: string | undefined;
    type?: string | undefined;
    useMap?: string | undefined;
    value?: string | number | readonly string[] | undefined;
    width?: string | number | undefined;
    wmode?: string | undefined;
    wrap?: string | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    autoFocus?: boolean | undefined;
    className?: string | undefined;
    contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "true" | "false") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    nonce?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "true" | "false") | undefined;
    style?: React.CSSProperties | undefined;
    tabIndex?: number | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    content?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    rel?: string | undefined;
    resource?: string | undefined;
    rev?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "off" | "on" | undefined;
    inputMode?: "text" | "none" | "search" | "email" | "tel" | "url" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    "aria-activedescendant"?: string | undefined;
    "aria-atomic"?: (boolean | "true" | "false") | undefined;
    "aria-autocomplete"?: "list" | "none" | "both" | "inline" | undefined;
    "aria-busy"?: (boolean | "true" | "false") | undefined;
    "aria-checked"?: boolean | "true" | "false" | "mixed" | undefined;
    "aria-colcount"?: number | undefined;
    "aria-colindex"?: number | undefined;
    "aria-colspan"?: number | undefined;
    "aria-controls"?: string | undefined;
    "aria-current"?: boolean | "step" | "time" | "date" | "true" | "false" | "page" | "location" | undefined;
    "aria-describedby"?: string | undefined;
    "aria-details"?: string | undefined;
    "aria-disabled"?: (boolean | "true" | "false") | undefined;
    "aria-dropeffect"?: "none" | "link" | "copy" | "execute" | "move" | "popup" | undefined;
    "aria-errormessage"?: string | undefined;
    "aria-expanded"?: (boolean | "true" | "false") | undefined;
    "aria-flowto"?: string | undefined;
    "aria-grabbed"?: (boolean | "true" | "false") | undefined;
    "aria-haspopup"?: boolean | "listbox" | "dialog" | "menu" | "true" | "false" | "grid" | "tree" | undefined;
    "aria-hidden"?: (boolean | "true" | "false") | undefined;
    "aria-invalid"?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
    "aria-keyshortcuts"?: string | undefined;
    "aria-labelledby"?: string | undefined;
    "aria-level"?: number | undefined;
    "aria-live"?: "off" | "assertive" | "polite" | undefined;
    "aria-modal"?: (boolean | "true" | "false") | undefined;
    "aria-multiline"?: (boolean | "true" | "false") | undefined;
    "aria-multiselectable"?: (boolean | "true" | "false") | undefined;
    "aria-orientation"?: "horizontal" | "vertical" | undefined;
    "aria-owns"?: string | undefined;
    "aria-placeholder"?: string | undefined;
    "aria-posinset"?: number | undefined;
    "aria-pressed"?: boolean | "true" | "false" | "mixed" | undefined;
    "aria-readonly"?: (boolean | "true" | "false") | undefined;
    "aria-relevant"?: "text" | "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    "aria-required"?: (boolean | "true" | "false") | undefined;
    "aria-roledescription"?: string | undefined;
    "aria-rowcount"?: number | undefined;
    "aria-rowindex"?: number | undefined;
    "aria-rowspan"?: number | undefined;
    "aria-setsize"?: number | undefined;
    "aria-sort"?: "none" | "ascending" | "descending" | "other" | undefined;
    "aria-valuemax"?: number | undefined;
    "aria-valuemin"?: number | undefined;
    "aria-valuenow"?: number | undefined;
    "aria-valuetext"?: string | undefined;
    children?: React.ReactNode;
    dangerouslySetInnerHTML?: {
        __html: string | TrustedHTML;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<T> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<T> | undefined;
    onCut?: React.ClipboardEventHandler<T> | undefined;
    onCutCapture?: React.ClipboardEventHandler<T> | undefined;
    onPaste?: React.ClipboardEventHandler<T> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<T> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<T> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<T> | undefined;
    onCompositionStart?: React.CompositionEventHandler<T> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<T> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<T> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<T> | undefined;
    onFocus?: React.FocusEventHandler<T> | undefined;
    onFocusCapture?: React.FocusEventHandler<T> | undefined;
    onBlur?: React.FocusEventHandler<T> | undefined;
    onBlurCapture?: React.FocusEventHandler<T> | undefined;
    onChange?: React.FormEventHandler<T> | undefined;
    onChangeCapture?: React.FormEventHandler<T> | undefined;
    onBeforeInput?: React.FormEventHandler<T> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<T> | undefined;
    onInput?: React.FormEventHandler<T> | undefined;
    onInputCapture?: React.FormEventHandler<T> | undefined;
    onReset?: React.FormEventHandler<T> | undefined;
    onResetCapture?: React.FormEventHandler<T> | undefined;
    onSubmit?: React.FormEventHandler<T> | undefined;
    onSubmitCapture?: React.FormEventHandler<T> | undefined;
    onInvalid?: React.FormEventHandler<T> | undefined;
    onInvalidCapture?: React.FormEventHandler<T> | undefined;
    onLoad?: React.ReactEventHandler<T> | undefined;
    onLoadCapture?: React.ReactEventHandler<T> | undefined;
    onError?: React.ReactEventHandler<T> | undefined;
    onErrorCapture?: React.ReactEventHandler<T> | undefined;
    onKeyDown?: React.KeyboardEventHandler<T> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<T> | undefined;
    onKeyPress?: React.KeyboardEventHandler<T> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<T> | undefined;
    onKeyUp?: React.KeyboardEventHandler<T> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<T> | undefined;
    onAbort?: React.ReactEventHandler<T> | undefined;
    onAbortCapture?: React.ReactEventHandler<T> | undefined;
    onCanPlay?: React.ReactEventHandler<T> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<T> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<T> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<T> | undefined;
    onDurationChange?: React.ReactEventHandler<T> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<T> | undefined;
    onEmptied?: React.ReactEventHandler<T> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<T> | undefined;
    onEncrypted?: React.ReactEventHandler<T> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<T> | undefined;
    onEnded?: React.ReactEventHandler<T> | undefined;
    onEndedCapture?: React.ReactEventHandler<T> | undefined;
    onLoadedData?: React.ReactEventHandler<T> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<T> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<T> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<T> | undefined;
    onLoadStart?: React.ReactEventHandler<T> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<T> | undefined;
    onPause?: React.ReactEventHandler<T> | undefined;
    onPauseCapture?: React.ReactEventHandler<T> | undefined;
    onPlay?: React.ReactEventHandler<T> | undefined;
    onPlayCapture?: React.ReactEventHandler<T> | undefined;
    onPlaying?: React.ReactEventHandler<T> | undefined;
    onPlayingCapture?: React.ReactEventHandler<T> | undefined;
    onProgress?: React.ReactEventHandler<T> | undefined;
    onProgressCapture?: React.ReactEventHandler<T> | undefined;
    onRateChange?: React.ReactEventHandler<T> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<T> | undefined;
    onSeeked?: React.ReactEventHandler<T> | undefined;
    onSeekedCapture?: React.ReactEventHandler<T> | undefined;
    onSeeking?: React.ReactEventHandler<T> | undefined;
    onSeekingCapture?: React.ReactEventHandler<T> | undefined;
    onStalled?: React.ReactEventHandler<T> | undefined;
    onStalledCapture?: React.ReactEventHandler<T> | undefined;
    onSuspend?: React.ReactEventHandler<T> | undefined;
    onSuspendCapture?: React.ReactEventHandler<T> | undefined;
    onTimeUpdate?: React.ReactEventHandler<T> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<T> | undefined;
    onVolumeChange?: React.ReactEventHandler<T> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<T> | undefined;
    onWaiting?: React.ReactEventHandler<T> | undefined;
    onWaitingCapture?: React.ReactEventHandler<T> | undefined;
    onAuxClick?: React.MouseEventHandler<T> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<T> | undefined;
    onClickCapture?: React.MouseEventHandler<T> | undefined;
    onContextMenu?: React.MouseEventHandler<T> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<T> | undefined;
    onDoubleClick?: React.MouseEventHandler<T> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<T> | undefined;
    onDrag?: React.DragEventHandler<T> | undefined;
    onDragCapture?: React.DragEventHandler<T> | undefined;
    onDragEnd?: React.DragEventHandler<T> | undefined;
    onDragEndCapture?: React.DragEventHandler<T> | undefined;
    onDragEnter?: React.DragEventHandler<T> | undefined;
    onDragEnterCapture?: React.DragEventHandler<T> | undefined;
    onDragExit?: React.DragEventHandler<T> | undefined;
    onDragExitCapture?: React.DragEventHandler<T> | undefined;
    onDragLeave?: React.DragEventHandler<T> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<T> | undefined;
    onDragOver?: React.DragEventHandler<T> | undefined;
    onDragOverCapture?: React.DragEventHandler<T> | undefined;
    onDragStart?: React.DragEventHandler<T> | undefined;
    onDragStartCapture?: React.DragEventHandler<T> | undefined;
    onDrop?: React.DragEventHandler<T> | undefined;
    onDropCapture?: React.DragEventHandler<T> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<T> | undefined;
    onMouseEnter?: React.MouseEventHandler<T> | undefined;
    onMouseLeave?: React.MouseEventHandler<T> | undefined;
    onMouseMove?: React.MouseEventHandler<T> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<T> | undefined;
    onMouseOut?: React.MouseEventHandler<T> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<T> | undefined;
    onMouseOver?: React.MouseEventHandler<T> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<T> | undefined;
    onMouseUp?: React.MouseEventHandler<T> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<T> | undefined;
    onSelect?: React.ReactEventHandler<T> | undefined;
    onSelectCapture?: React.ReactEventHandler<T> | undefined;
    onTouchCancel?: React.TouchEventHandler<T> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<T> | undefined;
    onTouchEnd?: React.TouchEventHandler<T> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<T> | undefined;
    onTouchMove?: React.TouchEventHandler<T> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<T> | undefined;
    onTouchStart?: React.TouchEventHandler<T> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<T> | undefined;
    onPointerDown?: React.PointerEventHandler<T> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<T> | undefined;
    onPointerMove?: React.PointerEventHandler<T> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<T> | undefined;
    onPointerUp?: React.PointerEventHandler<T> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<T> | undefined;
    onPointerCancel?: React.PointerEventHandler<T> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<T> | undefined;
    onPointerEnter?: React.PointerEventHandler<T> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<T> | undefined;
    onPointerLeave?: React.PointerEventHandler<T> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<T> | undefined;
    onPointerOver?: React.PointerEventHandler<T> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<T> | undefined;
    onPointerOut?: React.PointerEventHandler<T> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<T> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<T> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<T> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<T> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<T> | undefined;
    onScroll?: React.UIEventHandler<T> | undefined;
    onScrollCapture?: React.UIEventHandler<T> | undefined;
    onWheel?: React.WheelEventHandler<T> | undefined;
    onWheelCapture?: React.WheelEventHandler<T> | undefined;
    onAnimationStart?: React.AnimationEventHandler<T> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<T> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<T> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<T> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<T> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<T> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<T> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<T> | undefined;
    key?: React.Key | null | undefined;
};
export declare function withItem<T extends UseItemProps<HTMLElement>>(Component: ComponentType<T>): {
    (props: T): React.JSX.Element;
    displayName: string;
    propTypes: {
        option: PropTypes.Validator<NonNullable<NonNullable<string | object | null | undefined>>>;
        position: PropTypes.Requireable<number>;
    };
};
