import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import React, { useEffect, useRef } from 'react';
import { TypeaheadContext } from './Context';
import { defaultSelectHint, getHintText, getInputProps, getInputText, getIsOnlyResult, isFunction, pick } from '../utils';
var inputPropKeys = ['activeIndex', 'disabled', 'id', 'inputRef', 'isFocused', 'isMenuShown', 'multiple', 'onBlur', 'onChange', 'onClick', 'onFocus', 'onKeyDown', 'placeholder'];
var propKeys = ['activeIndex', 'hideMenu', 'isMenuShown', 'labelKey', 'onClear', 'onHide', 'onRemove', 'results', 'selected', 'text', 'toggleMenu'];
var contextKeys = ['activeIndex', 'id', 'initialItem', 'inputNode', 'onActiveItemChange', 'onAdd', 'onInitialItemChange', 'onMenuItemClick', 'setItem'];
var TypeaheadManager = function TypeaheadManager(props) {
  var allowNew = props.allowNew,
    children = props.children,
    initialItem = props.initialItem,
    isMenuShown = props.isMenuShown,
    onAdd = props.onAdd,
    onInitialItemChange = props.onInitialItemChange,
    onKeyDown = props.onKeyDown,
    onMenuToggle = props.onMenuToggle,
    results = props.results,
    selectHint = props.selectHint;
  var hintText = getHintText(props);
  useEffect(function () {
    // Clear the initial item when there are no results.
    if (!(allowNew || results.length)) {
      onInitialItemChange();
    }
  });
  var isInitialRender = useRef(true);
  useEffect(function () {
    if (isInitialRender.current) {
      isInitialRender.current = false;
      return;
    }
    onMenuToggle(isMenuShown);
  }, [isMenuShown, onMenuToggle]);
  var handleKeyDown = function handleKeyDown(e) {
    onKeyDown(e);
    if (!initialItem) {
      return;
    }
    var addOnlyResult = e.key === 'Enter' && getIsOnlyResult(props);
    var shouldSelectHint = hintText && defaultSelectHint(e, selectHint);
    if (addOnlyResult || shouldSelectHint) {
      onAdd(initialItem);
    }
  };
  var childProps = _objectSpread(_objectSpread({}, pick(props, propKeys)), {}, {
    getInputProps: getInputProps(_objectSpread(_objectSpread({}, pick(props, inputPropKeys)), {}, {
      onKeyDown: handleKeyDown,
      value: getInputText(props)
    }))
  });
  var contextValue = _objectSpread(_objectSpread({}, pick(props, contextKeys)), {}, {
    hintText: hintText,
    isOnlyResult: getIsOnlyResult(props)
  });
  return /*#__PURE__*/React.createElement(TypeaheadContext.Provider, {
    value: contextValue
  }, isFunction(children) ? children(childProps) : children);
};
export default TypeaheadManager;