import cx from 'classnames';
import React, { forwardRef } from 'react';
import ClearButton from '../ClearButton';
import { useToken } from '../../behaviors/token';
import { isFunction } from '../../utils';
const InteractiveToken = forwardRef(({ active, children, className, onRemove, tabIndex, ...props }, ref) => (React.createElement("div", { ...props, className: cx('rbt-token', 'rbt-token-removeable', {
        'rbt-token-active': !!active,
    }, className), ref: ref, tabIndex: tabIndex || 0 },
    children,
    React.createElement(ClearButton, { className: "rbt-token-remove-button", label: "Remove", onClick: onRemove, tabIndex: -1 }))));
const StaticToken = ({ children, className, disabled, href, }) => {
    const classnames = cx('rbt-token', {
        'rbt-token-disabled': disabled,
    }, className);
    if (href && !disabled) {
        return (React.createElement("a", { className: classnames, href: href }, children));
    }
    return React.createElement("div", { className: classnames }, children);
};
const Token = ({ children, option, readOnly, ...props }) => {
    const { ref, ...tokenProps } = useToken({ ...props, option });
    const child = React.createElement("div", { className: "rbt-token-label" }, children);
    return !props.disabled && !readOnly && isFunction(tokenProps.onRemove) ? (React.createElement(InteractiveToken, { ...props, ...tokenProps, ref: ref }, child)) : (React.createElement(StaticToken, { ...props }, child));
};
export default Token;
