/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import AttributeValidation from './AttributeValidation';

/**
 * The JansAttribute model module.
 * @module model/JansAttribute
 * @version OAS Version
 */
class JansAttribute {
    /**
     * Constructs a new <code>JansAttribute</code>.
     * @alias module:model/JansAttribute
     * @param name {String} 
     * @param displayName {String} 
     * @param description {String} 
     * @param dataType {module:model/JansAttribute.DataTypeEnum} 
     * @param editType {Array.<module:model/JansAttribute.EditTypeEnum>} 
     * @param viewType {Array.<module:model/JansAttribute.ViewTypeEnum>} 
     */
    constructor(name, displayName, description, dataType, editType, viewType) { 
        
        JansAttribute.initialize(this, name, displayName, description, dataType, editType, viewType);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, name, displayName, description, dataType, editType, viewType) { 
        obj['name'] = name;
        obj['displayName'] = displayName;
        obj['description'] = description;
        obj['dataType'] = dataType;
        obj['editType'] = editType;
        obj['viewType'] = viewType;
    }

    /**
     * Constructs a <code>JansAttribute</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/JansAttribute} obj Optional instance to populate.
     * @return {module:model/JansAttribute} The populated <code>JansAttribute</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new JansAttribute();

            if (data.hasOwnProperty('dn')) {
                obj['dn'] = ApiClient.convertToType(data['dn'], 'String');
            }
            if (data.hasOwnProperty('inum')) {
                obj['inum'] = ApiClient.convertToType(data['inum'], 'String');
            }
            if (data.hasOwnProperty('sourceAttribute')) {
                obj['sourceAttribute'] = ApiClient.convertToType(data['sourceAttribute'], 'String');
            }
            if (data.hasOwnProperty('nameIdType')) {
                obj['nameIdType'] = ApiClient.convertToType(data['nameIdType'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('displayName')) {
                obj['displayName'] = ApiClient.convertToType(data['displayName'], 'String');
            }
            if (data.hasOwnProperty('description')) {
                obj['description'] = ApiClient.convertToType(data['description'], 'String');
            }
            if (data.hasOwnProperty('origin')) {
                obj['origin'] = ApiClient.convertToType(data['origin'], 'String');
            }
            if (data.hasOwnProperty('dataType')) {
                obj['dataType'] = ApiClient.convertToType(data['dataType'], 'String');
            }
            if (data.hasOwnProperty('editType')) {
                obj['editType'] = ApiClient.convertToType(data['editType'], ['String']);
            }
            if (data.hasOwnProperty('viewType')) {
                obj['viewType'] = ApiClient.convertToType(data['viewType'], ['String']);
            }
            if (data.hasOwnProperty('usageType')) {
                obj['usageType'] = ApiClient.convertToType(data['usageType'], ['String']);
            }
            if (data.hasOwnProperty('claimName')) {
                obj['claimName'] = ApiClient.convertToType(data['claimName'], 'String');
            }
            if (data.hasOwnProperty('seeAlso')) {
                obj['seeAlso'] = ApiClient.convertToType(data['seeAlso'], 'String');
            }
            if (data.hasOwnProperty('status')) {
                obj['status'] = ApiClient.convertToType(data['status'], 'String');
            }
            if (data.hasOwnProperty('saml1Uri')) {
                obj['saml1Uri'] = ApiClient.convertToType(data['saml1Uri'], 'String');
            }
            if (data.hasOwnProperty('saml2Uri')) {
                obj['saml2Uri'] = ApiClient.convertToType(data['saml2Uri'], 'String');
            }
            if (data.hasOwnProperty('urn')) {
                obj['urn'] = ApiClient.convertToType(data['urn'], 'String');
            }
            if (data.hasOwnProperty('scimCustomAttr')) {
                obj['scimCustomAttr'] = ApiClient.convertToType(data['scimCustomAttr'], 'Boolean');
            }
            if (data.hasOwnProperty('oxMultiValuedAttribute')) {
                obj['oxMultiValuedAttribute'] = ApiClient.convertToType(data['oxMultiValuedAttribute'], 'Boolean');
            }
            if (data.hasOwnProperty('jansHideOnDiscovery')) {
                obj['jansHideOnDiscovery'] = ApiClient.convertToType(data['jansHideOnDiscovery'], 'Boolean');
            }
            if (data.hasOwnProperty('required')) {
                obj['required'] = ApiClient.convertToType(data['required'], 'Boolean');
            }
            if (data.hasOwnProperty('custom')) {
                obj['custom'] = ApiClient.convertToType(data['custom'], 'Boolean');
            }
            if (data.hasOwnProperty('attributeValidation')) {
                obj['attributeValidation'] = AttributeValidation.constructFromObject(data['attributeValidation']);
            }
            if (data.hasOwnProperty('tooltip')) {
                obj['tooltip'] = ApiClient.convertToType(data['tooltip'], 'String');
            }
            if (data.hasOwnProperty('selected')) {
                obj['selected'] = ApiClient.convertToType(data['selected'], 'Boolean');
            }
            if (data.hasOwnProperty('adminCanAccess')) {
                obj['adminCanAccess'] = ApiClient.convertToType(data['adminCanAccess'], 'Boolean');
            }
            if (data.hasOwnProperty('userCanAccess')) {
                obj['userCanAccess'] = ApiClient.convertToType(data['userCanAccess'], 'Boolean');
            }
            if (data.hasOwnProperty('whitePagesCanView')) {
                obj['whitePagesCanView'] = ApiClient.convertToType(data['whitePagesCanView'], 'Boolean');
            }
            if (data.hasOwnProperty('adminCanView')) {
                obj['adminCanView'] = ApiClient.convertToType(data['adminCanView'], 'Boolean');
            }
            if (data.hasOwnProperty('adminCanEdit')) {
                obj['adminCanEdit'] = ApiClient.convertToType(data['adminCanEdit'], 'Boolean');
            }
            if (data.hasOwnProperty('userCanView')) {
                obj['userCanView'] = ApiClient.convertToType(data['userCanView'], 'Boolean');
            }
            if (data.hasOwnProperty('userCanEdit')) {
                obj['userCanEdit'] = ApiClient.convertToType(data['userCanEdit'], 'Boolean');
            }
            if (data.hasOwnProperty('baseDn')) {
                obj['baseDn'] = ApiClient.convertToType(data['baseDn'], 'String');
            }
        }
        return obj;
    }


}

/**
 * @member {String} dn
 */
JansAttribute.prototype['dn'] = undefined;

/**
 * @member {String} inum
 */
JansAttribute.prototype['inum'] = undefined;

/**
 * @member {String} sourceAttribute
 */
JansAttribute.prototype['sourceAttribute'] = undefined;

/**
 * @member {String} nameIdType
 */
JansAttribute.prototype['nameIdType'] = undefined;

/**
 * @member {String} name
 */
JansAttribute.prototype['name'] = undefined;

/**
 * @member {String} displayName
 */
JansAttribute.prototype['displayName'] = undefined;

/**
 * @member {String} description
 */
JansAttribute.prototype['description'] = undefined;

/**
 * @member {String} origin
 */
JansAttribute.prototype['origin'] = undefined;

/**
 * @member {module:model/JansAttribute.DataTypeEnum} dataType
 */
JansAttribute.prototype['dataType'] = undefined;

/**
 * @member {Array.<module:model/JansAttribute.EditTypeEnum>} editType
 */
JansAttribute.prototype['editType'] = undefined;

/**
 * @member {Array.<module:model/JansAttribute.ViewTypeEnum>} viewType
 */
JansAttribute.prototype['viewType'] = undefined;

/**
 * @member {Array.<module:model/JansAttribute.UsageTypeEnum>} usageType
 */
JansAttribute.prototype['usageType'] = undefined;

/**
 * @member {String} claimName
 */
JansAttribute.prototype['claimName'] = undefined;

/**
 * @member {String} seeAlso
 */
JansAttribute.prototype['seeAlso'] = undefined;

/**
 * @member {module:model/JansAttribute.StatusEnum} status
 */
JansAttribute.prototype['status'] = undefined;

/**
 * @member {String} saml1Uri
 */
JansAttribute.prototype['saml1Uri'] = undefined;

/**
 * @member {String} saml2Uri
 */
JansAttribute.prototype['saml2Uri'] = undefined;

/**
 * @member {String} urn
 */
JansAttribute.prototype['urn'] = undefined;

/**
 * @member {Boolean} scimCustomAttr
 */
JansAttribute.prototype['scimCustomAttr'] = undefined;

/**
 * @member {Boolean} oxMultiValuedAttribute
 */
JansAttribute.prototype['oxMultiValuedAttribute'] = undefined;

/**
 * @member {Boolean} jansHideOnDiscovery
 */
JansAttribute.prototype['jansHideOnDiscovery'] = undefined;

/**
 * @member {Boolean} required
 */
JansAttribute.prototype['required'] = undefined;

/**
 * @member {Boolean} custom
 */
JansAttribute.prototype['custom'] = undefined;

/**
 * @member {module:model/AttributeValidation} attributeValidation
 */
JansAttribute.prototype['attributeValidation'] = undefined;

/**
 * @member {String} tooltip
 */
JansAttribute.prototype['tooltip'] = undefined;

/**
 * @member {Boolean} selected
 */
JansAttribute.prototype['selected'] = undefined;

/**
 * @member {Boolean} adminCanAccess
 */
JansAttribute.prototype['adminCanAccess'] = undefined;

/**
 * @member {Boolean} userCanAccess
 */
JansAttribute.prototype['userCanAccess'] = undefined;

/**
 * @member {Boolean} whitePagesCanView
 */
JansAttribute.prototype['whitePagesCanView'] = undefined;

/**
 * @member {Boolean} adminCanView
 */
JansAttribute.prototype['adminCanView'] = undefined;

/**
 * @member {Boolean} adminCanEdit
 */
JansAttribute.prototype['adminCanEdit'] = undefined;

/**
 * @member {Boolean} userCanView
 */
JansAttribute.prototype['userCanView'] = undefined;

/**
 * @member {Boolean} userCanEdit
 */
JansAttribute.prototype['userCanEdit'] = undefined;

/**
 * @member {String} baseDn
 */
JansAttribute.prototype['baseDn'] = undefined;





/**
 * Allowed values for the <code>dataType</code> property.
 * @enum {String}
 * @readonly
 */
JansAttribute['DataTypeEnum'] = {

    /**
     * value: "string"
     * @const
     */
    "string": "string",

    /**
     * value: "numeric"
     * @const
     */
    "numeric": "numeric",

    /**
     * value: "boolean"
     * @const
     */
    "boolean": "boolean",

    /**
     * value: "binary"
     * @const
     */
    "binary": "binary",

    /**
     * value: "certificate"
     * @const
     */
    "certificate": "certificate",

    /**
     * value: "generalizedTime"
     * @const
     */
    "generalizedTime": "generalizedTime",

    /**
     * value: "json"
     * @const
     */
    "json": "json"
};


/**
 * Allowed values for the <code>editType</code> property.
 * @enum {String}
 * @readonly
 */
JansAttribute['EditTypeEnum'] = {

    /**
     * value: "admin"
     * @const
     */
    "admin": "admin",

    /**
     * value: "owner"
     * @const
     */
    "owner": "owner",

    /**
     * value: "manager"
     * @const
     */
    "manager": "manager",

    /**
     * value: "user"
     * @const
     */
    "user": "user",

    /**
     * value: "whitePages"
     * @const
     */
    "whitePages": "whitePages"
};


/**
 * Allowed values for the <code>viewType</code> property.
 * @enum {String}
 * @readonly
 */
JansAttribute['ViewTypeEnum'] = {

    /**
     * value: "admin"
     * @const
     */
    "admin": "admin",

    /**
     * value: "owner"
     * @const
     */
    "owner": "owner",

    /**
     * value: "manager"
     * @const
     */
    "manager": "manager",

    /**
     * value: "user"
     * @const
     */
    "user": "user",

    /**
     * value: "whitePages"
     * @const
     */
    "whitePages": "whitePages"
};


/**
 * Allowed values for the <code>usageType</code> property.
 * @enum {String}
 * @readonly
 */
JansAttribute['UsageTypeEnum'] = {

    /**
     * value: "openid"
     * @const
     */
    "openid": "openid"
};


/**
 * Allowed values for the <code>status</code> property.
 * @enum {String}
 * @readonly
 */
JansAttribute['StatusEnum'] = {

    /**
     * value: "active"
     * @const
     */
    "active": "active",

    /**
     * value: "inactive"
     * @const
     */
    "inactive": "inactive",

    /**
     * value: "expired"
     * @const
     */
    "expired": "expired",

    /**
     * value: "register"
     * @const
     */
    "register": "register"
};



export default JansAttribute;

