/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import CustomScript from '../model/CustomScript';
import PagedResult from '../model/PagedResult';

/**
* CustomScripts service.
* @module api/CustomScriptsApi
* @version OAS Version
*/
export default class CustomScriptsApi {

    /**
    * Constructs a new CustomScriptsApi. 
    * @alias module:api/CustomScriptsApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteConfigScriptsByInum operation.
     * @callback module:api/CustomScriptsApi~deleteConfigScriptsByInumCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Deletes a custom script
     * Deletes a custom script
     * @param {String} inum Script identifier
     * @param {module:api/CustomScriptsApi~deleteConfigScriptsByInumCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteConfigScriptsByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteConfigScriptsByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/config/scripts/{inum}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getConfigScripts operation.
     * @callback module:api/CustomScriptsApi~getConfigScriptsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets a list of custom scripts
     * Gets a list of custom scripts
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/CustomScriptsApi~getConfigScriptsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
    getConfigScripts(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PagedResult;
      return this.apiClient.callApi(
        '/api/v1/config/scripts', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getConfigScriptsByInum operation.
     * @callback module:api/CustomScriptsApi~getConfigScriptsByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets a script by Inum
     * Gets a script by Inum
     * @param {String} inum Script identifier
     * @param {module:api/CustomScriptsApi~getConfigScriptsByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
    getConfigScriptsByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getConfigScriptsByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = CustomScript;
      return this.apiClient.callApi(
        '/api/v1/config/scripts/inum/{inum}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getConfigScriptsByType operation.
     * @callback module:api/CustomScriptsApi~getConfigScriptsByTypeCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of scripts by type
     * Gets list of scripts by type
     * @param {String} type Script type
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/CustomScriptsApi~getConfigScriptsByTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
    getConfigScriptsByType(type, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'type' is set
      if (type === undefined || type === null) {
        throw new Error("Missing the required parameter 'type' when calling getConfigScriptsByType");
      }

      let pathParams = {
        'type': type
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PagedResult;
      return this.apiClient.callApi(
        '/api/v1/config/scripts/type/{type}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getCustomScriptByName operation.
     * @callback module:api/CustomScriptsApi~getCustomScriptByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch custom script by name
     * Fetch custom script by name
     * @param {String} name Script name
     * @param {module:api/CustomScriptsApi~getCustomScriptByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
    getCustomScriptByName(name, callback) {
      let postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getCustomScriptByName");
      }

      let pathParams = {
        'name': name
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = CustomScript;
      return this.apiClient.callApi(
        '/api/v1/config/scripts/name/{name}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getCustomScriptType operation.
     * @callback module:api/CustomScriptsApi~getCustomScriptTypeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<String>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch custom script types
     * Fetch custom script types
     * @param {module:api/CustomScriptsApi~getCustomScriptTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<String>}
     */
    getCustomScriptType(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ['String'];
      return this.apiClient.callApi(
        '/api/v1/config/scripts/types', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getCustomScriptTypes operation.
     * @callback module:api/CustomScriptsApi~getCustomScriptTypesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<String>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch custom script types
     * Fetch custom script types
     * @param {module:api/CustomScriptsApi~getCustomScriptTypesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<String>}
     */
    getCustomScriptTypes(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ['String'];
      return this.apiClient.callApi(
        '/api/v1/config/scripts/script-types', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchConfigScriptsByInum operation.
     * @callback module:api/CustomScriptsApi~patchConfigScriptsByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patches a custom script
     * Patches a custom script
     * @param {String} inum Script identifier
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody JsonPatch object
     * @param {module:api/CustomScriptsApi~patchConfigScriptsByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
    patchConfigScriptsByInum(inum, opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchConfigScriptsByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = CustomScript;
      return this.apiClient.callApi(
        '/api/v1/config/scripts/{inum}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postConfigScripts operation.
     * @callback module:api/CustomScriptsApi~postConfigScriptsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Adds a new custom script
     * Adds a new custom script
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.addScriptTemplate Boolean flag to indicate if script template is to be added. If CustomScript request object has script populated then script template will not be added. (default to false)
     * @param {module:model/CustomScript} opts.customScript CustomScript object
     * @param {module:api/CustomScriptsApi~postConfigScriptsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
    postConfigScripts(opts, callback) {
      opts = opts || {};
      let postBody = opts['customScript'];

      let pathParams = {
      };
      let queryParams = {
        'addScriptTemplate': opts['addScriptTemplate']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CustomScript;
      return this.apiClient.callApi(
        '/api/v1/config/scripts', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putConfigScripts operation.
     * @callback module:api/CustomScriptsApi~putConfigScriptsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScript} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates a custom script
     * Updates a custom script
     * @param {Object} opts Optional parameters
     * @param {module:model/CustomScript} opts.customScript CustomScript object
     * @param {module:api/CustomScriptsApi~putConfigScriptsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScript}
     */
    putConfigScripts(opts, callback) {
      opts = opts || {};
      let postBody = opts['customScript'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CustomScript;
      return this.apiClient.callApi(
        '/api/v1/config/scripts', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
