/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import JSONWebKey from '../model/JSONWebKey';
import WebKeysConfiguration from '../model/WebKeysConfiguration';

/**
* ConfigurationJWKJSONWebKeyJWK service.
* @module api/ConfigurationJWKJSONWebKeyJWKApi
* @version OAS Version
*/
export default class ConfigurationJWKJSONWebKeyJWKApi {

    /**
    * Constructs a new ConfigurationJWKJSONWebKeyJWKApi. 
    * @alias module:api/ConfigurationJWKJSONWebKeyJWKApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteConfigJwkKid operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~deleteConfigJwkKidCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete a JSON Web Key based on kid
     * Delete a JSON Web Key based on kid
     * @param {String} kid The unique identifier for the key
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~deleteConfigJwkKidCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteConfigJwkKid(kid, callback) {
      let postBody = null;
      // verify the required parameter 'kid' is set
      if (kid === undefined || kid === null) {
        throw new Error("Missing the required parameter 'kid' when calling deleteConfigJwkKid");
      }

      let pathParams = {
        'kid': kid
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/config/jwks/{kid}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getConfigJwks operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~getConfigJwksCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebKeysConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of JSON Web Key (JWK) used by server
     * Gets list of JSON Web Key (JWK) used by server
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~getConfigJwksCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebKeysConfiguration}
     */
    getConfigJwks(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = WebKeysConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/jwks', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getJwkByKid operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~getJwkByKidCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JSONWebKey} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a JSON Web Key based on kid
     * Get a JSON Web Key based on kid
     * @param {String} kid The unique identifier for the key
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~getJwkByKidCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JSONWebKey}
     */
    getJwkByKid(kid, callback) {
      let postBody = null;
      // verify the required parameter 'kid' is set
      if (kid === undefined || kid === null) {
        throw new Error("Missing the required parameter 'kid' when calling getJwkByKid");
      }

      let pathParams = {
        'kid': kid
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = JSONWebKey;
      return this.apiClient.callApi(
        '/api/v1/config/jwks/{kid}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchConfigJwkKid operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~patchConfigJwkKidCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JSONWebKey} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch a specific JSON Web Key based on kid
     * Patch a specific JSON Web Key based on kid
     * @param {String} kid The unique identifier for the key
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody JsonPatch object
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~patchConfigJwkKidCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JSONWebKey}
     */
    patchConfigJwkKid(kid, opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];
      // verify the required parameter 'kid' is set
      if (kid === undefined || kid === null) {
        throw new Error("Missing the required parameter 'kid' when calling patchConfigJwkKid");
      }

      let pathParams = {
        'kid': kid
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = JSONWebKey;
      return this.apiClient.callApi(
        '/api/v1/config/jwks/{kid}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchConfigJwks operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~patchConfigJwksCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebKeysConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patches JSON Web Keys
     * Patches JSON Web Keys
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody JsonPatch object
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~patchConfigJwksCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebKeysConfiguration}
     */
    patchConfigJwks(opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = WebKeysConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/jwks', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postConfigJwksKey operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~postConfigJwksKeyCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JSONWebKey} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Configuration – JWK - JSON Web Key (JWK)
     * Configuration – JWK - JSON Web Key (JWK)
     * @param {Object} opts Optional parameters
     * @param {module:model/JSONWebKey} opts.jSONWebKey JSONWebKey object
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~postConfigJwksKeyCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JSONWebKey}
     */
    postConfigJwksKey(opts, callback) {
      opts = opts || {};
      let postBody = opts['jSONWebKey'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = JSONWebKey;
      return this.apiClient.callApi(
        '/api/v1/config/jwks/key', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putConfigJwks operation.
     * @callback module:api/ConfigurationJWKJSONWebKeyJWKApi~putConfigJwksCallback
     * @param {String} error Error message, if any.
     * @param {module:model/WebKeysConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Replaces JSON Web Keys
     * Replaces JSON Web Keys
     * @param {Object} opts Optional parameters
     * @param {module:model/WebKeysConfiguration} opts.webKeysConfiguration JSON Web Keys object
     * @param {module:api/ConfigurationJWKJSONWebKeyJWKApi~putConfigJwksCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/WebKeysConfiguration}
     */
    putConfigJwks(opts, callback) {
      opts = opts || {};
      let postBody = opts['webKeysConfiguration'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = WebKeysConfiguration;
      return this.apiClient.callApi(
        '/api/v1/config/jwks', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
