# JansConfigApi.MessageConfigurationRedisApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigMessageRedis**](MessageConfigurationRedisApi.md#getConfigMessageRedis) | **GET** /api/v1/config/message/redis | Returns Redis message configuration.
[**patchConfigMessageRedis**](MessageConfigurationRedisApi.md#patchConfigMessageRedis) | **PATCH** /api/v1/config/message/redis | Patch Redis message configuration.
[**putConfigMessageRedis**](MessageConfigurationRedisApi.md#putConfigMessageRedis) | **PUT** /api/v1/config/message/redis | Updates Redis message configuration.



## getConfigMessageRedis

> RedisMessageConfiguration getConfigMessageRedis()

Returns Redis message configuration.

Returns Redis message configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.MessageConfigurationRedisApi();
apiInstance.getConfigMessageRedis((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**RedisMessageConfiguration**](RedisMessageConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigMessageRedis

> RedisMessageConfiguration patchConfigMessageRedis(opts)

Patch Redis message configuration.

Patch Redis message configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.MessageConfigurationRedisApi();
let opts = {
  'requestBody':  // [Object] | String representing patch-document.
};
apiInstance.patchConfigMessageRedis(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**RedisMessageConfiguration**](RedisMessageConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## putConfigMessageRedis

> RedisMessageConfiguration putConfigMessageRedis(opts)

Updates Redis message configuration.

Updates Redis message configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.MessageConfigurationRedisApi();
let opts = {
  'redisMessageConfiguration':  // RedisMessageConfiguration | RedisMessageConfiguration object
};
apiInstance.putConfigMessageRedis(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **redisMessageConfiguration** | [**RedisMessageConfiguration**](RedisMessageConfiguration.md)| RedisMessageConfiguration object | [optional] 

### Return type

[**RedisMessageConfiguration**](RedisMessageConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

