"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
exports.getMiddleware = getMiddleware;
exports.getPlacement = getPlacement;
exports.useOverlay = useOverlay;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _reactDom = require("@floating-ui/react-dom");
var _react = require("react");
function getMiddleware(props) {
  var middleware = [];
  if (props.flip) {
    middleware.push((0, _reactDom.flip)());
  }
  if (props.align !== 'right' && props.align !== 'left') {
    middleware.push((0, _reactDom.size)({
      apply: function apply(_ref) {
        var rects = _ref.rects,
          elements = _ref.elements;
        Object.assign(elements.floating.style, {
          width: "".concat(rects.reference.width, "px")
        });
      }
    }));
  }
  return middleware;
}
function getPlacement(props) {
  var x = props.align === 'right' ? 'end' : 'start';
  var y = props.dropup ? 'top' : 'bottom';
  return "".concat(y, "-").concat(x);
}
function useOverlay(referenceElement, options) {
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
    floatingElement = _useState2[0],
    attachRef = _useState2[1];
  var _useFloating = (0, _reactDom.useFloating)({
      elements: {
        floating: floatingElement,
        reference: referenceElement
      },
      middleware: getMiddleware(options),
      placement: getPlacement(options),
      strategy: options.positionFixed ? 'fixed' : 'absolute',
      whileElementsMounted: _reactDom.autoUpdate
    }),
    floatingStyles = _useFloating.floatingStyles;
  return {
    innerRef: attachRef,
    style: floatingStyles
  };
}
var _default = exports["default"] = useOverlay;