"use strict";

exports.__esModule = true;
exports.default = _default;

var _module2 = _interopRequireDefault(require("module"));

var _path = _interopRequireDefault(require("path"));

var _fs = _interopRequireDefault(require("fs"));

var babelParser = _interopRequireWildcard(require("@babel/parser"));

var _traverse = _interopRequireDefault(require("@babel/traverse"));

var t = _interopRequireWildcard(require("@babel/types"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var recharts = 'recharts';
var rechartsLib = 'recharts/lib';

var _module = new _module2.default();

var rechartsLibPath = _path.default.dirname(_module2.default._resolveFilename('recharts', _extends({}, _module, {
  paths: _module2.default._nodeModulePaths(process.cwd())
})));

var rechartsPath = _path.default.join(rechartsLibPath, '..');

var rechartsSrcPath = _path.default.join(rechartsPath, 'src');

var rechartsSrcIndexPath = _path.default.join(rechartsSrcPath, 'index.ts');

var srcCode = _fs.default.readFileSync(rechartsSrcIndexPath, 'utf-8');

var srcAst = babelParser.parse(srcCode, {
  sourceType: 'module',
  plugins: ['exportExtensions', 'typescript']
});

function findPath(source) {
  var finalModule = _extends({}, _module, {
    paths: _module2.default._nodeModulePaths(rechartsSrcPath)
  });

  var nodeMajorVersion = process.versions.node.split('.')[0];
  var paths;
  var id; // This internal API has changed it's functionality

  if (nodeMajorVersion < 12) {
    // Node.js version < 12: use _resolveLookupPaths
    var _Module$_resolveLooku = _module2.default._resolveLookupPaths(source, finalModule);

    id = _Module$_resolveLooku[0];
    paths = _Module$_resolveLooku[1];
  } else {
    // Node.js version >= 12: use _nodeModulePaths from above
    paths = finalModule.paths;
  }

  var finalPaths = [].concat(paths, [rechartsSrcPath]);
  var sourceFullPath;

  try {
    // All components use the `*.tsx` file extension
    var fullTSXPath = _path.default.resolve(rechartsSrcPath, source.indexOf('.tsx') >= 0 ? source : `${source}.tsx`);

    require.resolve(fullTSXPath);

    sourceFullPath = fullTSXPath;
  } catch (err) {}

  try {
    // Files under `utils` use the `*.ts` file extension
    var fulllTSPath = _path.default.resolve(rechartsSrcPath, source.indexOf('.ts') >= 0 ? source : `${source}.ts`);

    require.resolve(fulllTSPath);

    sourceFullPath = fulllTSPath;
  } catch (err) {}

  if (sourceFullPath) {
    // parse the component of project src
    // full quote path
    var sourceLibPath = `${rechartsLib}/${_path.default.relative(rechartsSrcPath, sourceFullPath)}`;
    return sourceLibPath.replace('.tsx', '.js').replace('.ts', '.js');
  }

  var absPath = _module2.default._findPath(source, finalPaths);

  if (absPath && absPath.indexOf(_path.default.join(rechartsPath, 'node_modules')) >= 0 || absPath.indexOf('node_modules') >= 0) {
    // node_modules source
    return source;
  }

  return '';
}

var pkgMap = {};
var commonImport = [];
(0, _traverse.default)(srcAst, {
  ImportDeclaration(path) {
    var _path$node = path.node,
        source = _path$node.source,
        specifiers = _path$node.specifiers;

    if (!specifiers.length) {
      // get common import like import 'polyfill'
      commonImport = [].concat(commonImport, [source.value]);
    }
  },

  ExportNamedDeclaration(path) {
    var _path$node2 = path.node,
        source = _path$node2.source,
        specifiers = _path$node2.specifiers;
    specifiers.forEach(function (spec) {
      var exported = spec.exported,
          local = spec.local;

      if (t.isExportDefaultSpecifier(spec)) {
        pkgMap = _extends({}, pkgMap, {
          [exported.name]: source.value
        });
      } else {
        pkgMap = _extends({}, pkgMap, {
          [exported.name]: [source.value, local.name]
        });
      }
    });
  }

});
Object.keys(pkgMap).forEach(function (key) {
  var pkgMapVal = pkgMap[key];
  pkgMap[key] = findPath(Array.isArray(pkgMapVal) ? pkgMapVal[0] : pkgMapVal);
});
commonImport = commonImport.map(function (source) {
  return findPath(source);
});

function _default(_ref) {
  var t = _ref.types;
  // import common code once in a file
  var hasAddCommonCode = false;
  return {
    visitor: {
      ImportDeclaration(path) {
        var node = path.node;
        var specifiers = node.specifiers,
            source = node.source;
        var pkgId = source.value;
        var specs = [];

        if (pkgId !== recharts) {
          return;
        }

        if (!specifiers.filter(t.isImportSpecifier).length) {
          return;
        }

        specifiers.forEach(function (spec) {
          var _spec = spec,
              local = _spec.local,
              imported = _spec.imported;
          var localName = local.name;
          var importedPath = recharts;

          if (t.isImportSpecifier(spec)) {
            var importedName = imported.name;
            spec = t.importDefaultSpecifier(t.identifier(localName));

            if (!pkgMap[importedName]) {
              throw new Error(`Recharts ${importedName} was not in known modules.`);
            }

            importedPath = pkgMap[importedName];
          }

          if (!hasAddCommonCode) {
            hasAddCommonCode = true;
            commonImport.forEach(function (cPath) {
              path.insertBefore(t.importDeclaration([], t.stringLiteral(cPath)));
            });
          }

          path.insertAfter(t.importDeclaration([spec], t.stringLiteral(importedPath)));
        });
        path.remove();
      }

    }
  };
}

module.exports = exports.default;