/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ApiError from '../model/ApiError';
import Fido2RegistrationEntry from '../model/Fido2RegistrationEntry';
import Fido2RegistrationEntryPagedResult from '../model/Fido2RegistrationEntryPagedResult';

/**
* Fido2Registration service.
* @module api/Fido2RegistrationApi
* @version OAS Version
*/
export default class Fido2RegistrationApi {

    /**
    * Constructs a new Fido2RegistrationApi. 
    * @alias module:api/Fido2RegistrationApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteFido2Data operation.
     * @callback module:api/Fido2RegistrationApi~deleteFido2DataCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete Fido2 Device Data based on device UID
     * Delete Fido2 Device Data based on device UID
     * @param {String} jansId Fido2Registration Unique identifier.
     * @param {module:api/Fido2RegistrationApi~deleteFido2DataCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteFido2Data(jansId, callback) {
      let postBody = null;
      // verify the required parameter 'jansId' is set
      if (jansId === undefined || jansId === null) {
        throw new Error("Missing the required parameter 'jansId' when calling deleteFido2Data");
      }

      let pathParams = {
        'jansId': jansId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = null;
      return this.apiClient.callApi(
        '/fido2/registration/id/{jansId}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getFido2ById operation.
     * @callback module:api/Fido2RegistrationApi~getFido2ByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Fido2RegistrationEntry} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch Fido2RegistrationEntry by Id.
     * Fetch Fido2RegistrationEntry by Id.
     * @param {String} jansId Fido2Registration identifier
     * @param {module:api/Fido2RegistrationApi~getFido2ByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Fido2RegistrationEntry}
     */
    getFido2ById(jansId, callback) {
      let postBody = null;
      // verify the required parameter 'jansId' is set
      if (jansId === undefined || jansId === null) {
        throw new Error("Missing the required parameter 'jansId' when calling getFido2ById");
      }

      let pathParams = {
        'jansId': jansId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Fido2RegistrationEntry;
      return this.apiClient.callApi(
        '/fido2/registration/id/{jansId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getRegistrationEntriesFido2 operation.
     * @callback module:api/Fido2RegistrationApi~getRegistrationEntriesFido2Callback
     * @param {String} error Error message, if any.
     * @param {module:model/Fido2RegistrationEntryPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get details of connected FIDO2 devices registered to user
     * Get details of connected FIDO2 devices registered to user
     * @param {String} username User name
     * @param {module:api/Fido2RegistrationApi~getRegistrationEntriesFido2Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Fido2RegistrationEntryPagedResult}
     */
    getRegistrationEntriesFido2(username, callback) {
      let postBody = null;
      // verify the required parameter 'username' is set
      if (username === undefined || username === null) {
        throw new Error("Missing the required parameter 'username' when calling getRegistrationEntriesFido2");
      }

      let pathParams = {
        'username': username
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Fido2RegistrationEntryPagedResult;
      return this.apiClient.callApi(
        '/fido2/registration/entries/{username}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the searchFido2RegistrationData operation.
     * @callback module:api/Fido2RegistrationApi~searchFido2RegistrationDataCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Fido2RegistrationEntryPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a list of Fido2RegistrationEntry.
     * Get a list of Fido2RegistrationEntry.
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Data whose value will be used to order the returned response (default to 'jansId')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/Fido2RegistrationApi~searchFido2RegistrationDataCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Fido2RegistrationEntryPagedResult}
     */
    searchFido2RegistrationData(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Fido2RegistrationEntryPagedResult;
      return this.apiClient.callApi(
        '/fido2/registration', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
