# JansConfigApi.PluginsApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getPluginByName**](PluginsApi.md#getPluginByName) | **GET** /api/v1/plugin/{pluginName} | Get plugin by name
[**getPlugins**](PluginsApi.md#getPlugins) | **GET** /api/v1/plugin | Gets list of Plugins



## getPluginByName

> Boolean getPluginByName(pluginName)

Get plugin by name

Get plugin by name

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.PluginsApi();
let pluginName = "pluginName_example"; // String | Plugin name
apiInstance.getPluginByName(pluginName, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pluginName** | **String**| Plugin name | 

### Return type

**Boolean**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getPlugins

> [PluginConf] getPlugins()

Gets list of Plugins

Gets list of Plugins

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.PluginsApi();
apiInstance.getPlugins((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[PluginConf]**](PluginConf.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

