"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _ClientAuth = _interopRequireDefault(require("../model/ClientAuth"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* ClientAuthorization service.
* @module api/ClientAuthorizationApi
* @version OAS Version
*/
var ClientAuthorizationApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new ClientAuthorizationApi. 
  * @alias module:api/ClientAuthorizationApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function ClientAuthorizationApi(apiClient) {
    _classCallCheck(this, ClientAuthorizationApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteClientAuthorization operation.
   * @callback module:api/ClientAuthorizationApi~deleteClientAuthorizationCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Revoke client authorization
   * Revoke client authorizations
   * @param {String} userId User identifier
   * @param {String} clientId Client identifier
   * @param {String} username User name
   * @param {module:api/ClientAuthorizationApi~deleteClientAuthorizationCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(ClientAuthorizationApi, [{
    key: "deleteClientAuthorization",
    value: function deleteClientAuthorization(userId, clientId, username, callback) {
      var postBody = null;
      // verify the required parameter 'userId' is set
      if (userId === undefined || userId === null) {
        throw new Error("Missing the required parameter 'userId' when calling deleteClientAuthorization");
      }
      // verify the required parameter 'clientId' is set
      if (clientId === undefined || clientId === null) {
        throw new Error("Missing the required parameter 'clientId' when calling deleteClientAuthorization");
      }
      // verify the required parameter 'username' is set
      if (username === undefined || username === null) {
        throw new Error("Missing the required parameter 'username' when calling deleteClientAuthorization");
      }
      var pathParams = {
        'userId': userId,
        'clientId': clientId,
        'username': username
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/clients/authorizations/{userId}/{clientId}/{username}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getClientAuthorization operation.
     * @callback module:api/ClientAuthorizationApi~getClientAuthorizationCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ClientAuth} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of client authorization
     * Gets list of client authorizations
     * @param {String} userId User identifier
     * @param {module:api/ClientAuthorizationApi~getClientAuthorizationCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ClientAuth}
     */
  }, {
    key: "getClientAuthorization",
    value: function getClientAuthorization(userId, callback) {
      var postBody = null;
      // verify the required parameter 'userId' is set
      if (userId === undefined || userId === null) {
        throw new Error("Missing the required parameter 'userId' when calling getClientAuthorization");
      }
      var pathParams = {
        'userId': userId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _ClientAuth["default"];
      return this.apiClient.callApi('/api/v1/clients/authorizations/{userId}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();