import React, { useState } from 'react';
import Token from '../Token';
import TypeaheadInputMulti from './TypeaheadInputMulti';
import options from '../../tests/data';
import { HintProvider, noop } from '../../tests/helpers';
export default {
    title: 'Components/TypeaheadInputMulti',
    component: TypeaheadInputMulti,
};
const selected = options.slice(1, 4);
const defaultProps = {
    children: selected.map((option) => (React.createElement(Token, { key: option.name, option: option, onRemove: noop }, option.name))),
    selected,
};
const Template = ({ hintText = '', ...args }) => {
    const [value, setValue] = useState(args.value);
    const [inputNode, setInputNode] = useState(null);
    return (React.createElement(HintProvider, { hintText: hintText, inputNode: inputNode },
        React.createElement(TypeaheadInputMulti, { ...args, inputRef: setInputNode, onChange: (e) => setValue(e.target.value), referenceElementRef: noop, value: value })));
};
export const Default = Template.bind({});
Default.args = {
    ...defaultProps,
};
export const FocusState = Template.bind({});
FocusState.args = {
    ...defaultProps,
    className: 'focus',
};
export const Disabled = Template.bind({});
Disabled.args = {
    ...defaultProps,
    children: selected.map((option) => (React.createElement(Token, { disabled: true, key: option.name, option: option, onRemove: noop }, option.name))),
    disabled: true,
};
export const Small = Template.bind({});
Small.args = {
    ...defaultProps,
    size: 'sm',
};
export const Large = Template.bind({});
Large.args = {
    ...defaultProps,
    size: 'lg',
};
export const Valid = Template.bind({});
Valid.args = {
    ...defaultProps,
    className: 'focus',
    isValid: true,
};
export const Invalid = Template.bind({});
Invalid.args = {
    ...defaultProps,
    className: 'focus',
    isInvalid: true,
};
export const WithHint = Template.bind({});
WithHint.args = {
    ...defaultProps,
    hintText: 'california',
    value: 'cali',
};
