/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import TokenEntity from '../model/TokenEntity';
import TokenEntityPagedResult from '../model/TokenEntityPagedResult';

/**
* Token service.
* @module api/TokenApi
* @version OAS Version
*/
export default class TokenApi {

    /**
    * Constructs a new TokenApi. 
    * @alias module:api/TokenApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the getTokenByClient operation.
     * @callback module:api/TokenApi~getTokenByClientCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TokenEntityPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get token details by client.
     * Get token details by client.
     * @param {String} clientId Client identifier
     * @param {module:api/TokenApi~getTokenByClientCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TokenEntityPagedResult}
     */
    getTokenByClient(clientId, callback) {
      let postBody = null;
      // verify the required parameter 'clientId' is set
      if (clientId === undefined || clientId === null) {
        throw new Error("Missing the required parameter 'clientId' when calling getTokenByClient");
      }

      let pathParams = {
        'clientId': clientId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = TokenEntityPagedResult;
      return this.apiClient.callApi(
        '/api/v1/token/client/{clientId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getTokenById operation.
     * @callback module:api/TokenApi~getTokenByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TokenEntity} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get token details by Id.
     * Get token details by Id.
     * @param {String} tknCde Token identifier
     * @param {module:api/TokenApi~getTokenByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TokenEntity}
     */
    getTokenById(tknCde, callback) {
      let postBody = null;
      // verify the required parameter 'tknCde' is set
      if (tknCde === undefined || tknCde === null) {
        throw new Error("Missing the required parameter 'tknCde' when calling getTokenById");
      }

      let pathParams = {
        'tknCde': tknCde
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = TokenEntity;
      return this.apiClient.callApi(
        '/api/v1/token/tknCde/{tknCde}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the revokeToken operation.
     * @callback module:api/TokenApi~revokeTokenCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Revoke client token.
     * Revoke client token.
     * @param {String} tknCde Token Code
     * @param {module:api/TokenApi~revokeTokenCallback} callback The callback function, accepting three arguments: error, data, response
     */
    revokeToken(tknCde, callback) {
      let postBody = null;
      // verify the required parameter 'tknCde' is set
      if (tknCde === undefined || tknCde === null) {
        throw new Error("Missing the required parameter 'tknCde' when calling revokeToken");
      }

      let pathParams = {
        'tknCde': tknCde
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/token/revoke/{tknCde}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the searchToken operation.
     * @callback module:api/TokenApi~searchTokenCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TokenEntityPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Search tokens
     * Search tokens
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'tknCde')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/TokenApi~searchTokenCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TokenEntityPagedResult}
     */
    searchToken(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = TokenEntityPagedResult;
      return this.apiClient.callApi(
        '/api/v1/token/search', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
