/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import CustomScope from '../model/CustomScope';
import PagedResult from '../model/PagedResult';
import Scope from '../model/Scope';

/**
* OAuthScopes service.
* @module api/OAuthScopesApi
* @version OAS Version
*/
export default class OAuthScopesApi {

    /**
    * Constructs a new OAuthScopesApi. 
    * @alias module:api/OAuthScopesApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteOauthScopesByInum operation.
     * @callback module:api/OAuthScopesApi~deleteOauthScopesByInumCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete Scope
     * Delete Scope
     * @param {String} inum Scope identifier
     * @param {module:api/OAuthScopesApi~deleteOauthScopesByInumCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteOauthScopesByInum(inum, callback) {
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteOauthScopesByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/scopes/{inum}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getOauthScopes operation.
     * @callback module:api/OAuthScopesApi~getOauthScopesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of Scopes
     * Gets list of Scopes
     * @param {Object} opts Optional parameters
     * @param {String} opts.type Scope type (default to '')
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {Boolean} opts.withAssociatedClients Boolean fag to indicate if clients associated with the scope are to be returned (default to false)
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/OAuthScopesApi~getOauthScopesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
    getOauthScopes(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'type': opts['type'],
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'withAssociatedClients': opts['withAssociatedClients'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PagedResult;
      return this.apiClient.callApi(
        '/api/v1/scopes', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getOauthScopesByInum operation.
     * @callback module:api/OAuthScopesApi~getOauthScopesByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Scope by Inum
     * Get Scope by Inum
     * @param {String} inum Scope identifier
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.withAssociatedClients  (default to false)
     * @param {module:api/OAuthScopesApi~getOauthScopesByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScope}
     */
    getOauthScopesByInum(inum, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getOauthScopesByInum");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
        'withAssociatedClients': opts['withAssociatedClients']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = CustomScope;
      return this.apiClient.callApi(
        '/api/v1/scopes/{inum}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getScopeByCreator operation.
     * @callback module:api/OAuthScopesApi~getScopeByCreatorCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/CustomScope>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Scope by creatorId
     * Get Scope by creatorId
     * @param {String} creatorId Id of the scope creator. If creator is client then client_id if user then user_id
     * @param {module:api/OAuthScopesApi~getScopeByCreatorCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/CustomScope>}
     */
    getScopeByCreator(creatorId, callback) {
      let postBody = null;
      // verify the required parameter 'creatorId' is set
      if (creatorId === undefined || creatorId === null) {
        throw new Error("Missing the required parameter 'creatorId' when calling getScopeByCreator");
      }

      let pathParams = {
        'creatorId': creatorId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [CustomScope];
      return this.apiClient.callApi(
        '/api/v1/scopes/creator/{creatorId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getScopeByType operation.
     * @callback module:api/OAuthScopesApi~getScopeByTypeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/CustomScope>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Scope by type
     * Get Scope by type
     * @param {String} type Type of the scope
     * @param {module:api/OAuthScopesApi~getScopeByTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/CustomScope>}
     */
    getScopeByType(type, callback) {
      let postBody = null;
      // verify the required parameter 'type' is set
      if (type === undefined || type === null) {
        throw new Error("Missing the required parameter 'type' when calling getScopeByType");
      }

      let pathParams = {
        'type': type
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [CustomScope];
      return this.apiClient.callApi(
        '/api/v1/scopes/type/{type}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchOauthScopesById operation.
     * @callback module:api/OAuthScopesApi~patchOauthScopesByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Scope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch Scope
     * Patch Scope
     * @param {String} inum Scope identifier
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/OAuthScopesApi~patchOauthScopesByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Scope}
     */
    patchOauthScopesById(inum, opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchOauthScopesById");
      }

      let pathParams = {
        'inum': inum
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = Scope;
      return this.apiClient.callApi(
        '/api/v1/scopes/{inum}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postOauthScopes operation.
     * @callback module:api/OAuthScopesApi~postOauthScopesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Scope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create Scope
     * Create Scope
     * @param {Object} opts Optional parameters
     * @param {module:model/Scope} opts.scope Scope object
     * @param {module:api/OAuthScopesApi~postOauthScopesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Scope}
     */
    postOauthScopes(opts, callback) {
      opts = opts || {};
      let postBody = opts['scope'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = Scope;
      return this.apiClient.callApi(
        '/api/v1/scopes', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putOauthScopes operation.
     * @callback module:api/OAuthScopesApi~putOauthScopesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Scope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update Scope
     * Update Scope
     * @param {Object} opts Optional parameters
     * @param {module:model/Scope} opts.scope Scope object
     * @param {module:api/OAuthScopesApi~putOauthScopesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Scope}
     */
    putOauthScopes(opts, callback) {
      opts = opts || {};
      let postBody = opts['scope'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = Scope;
      return this.apiClient.callApi(
        '/api/v1/scopes', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
