import { TypeaheadProps, TypeaheadState } from '../types';
type Props = TypeaheadProps;
export declare function getInitialState(props: Props): TypeaheadState;
export declare function clearTypeahead(state: TypeaheadState, props: Props): {
    isFocused: boolean;
    selected: never[];
    text: string;
    activeIndex: number;
    activeItem?: import("../types").Option | undefined;
    initialItem?: import("../types").Option | undefined;
    showMenu: boolean;
    shownResults: number;
};
export declare function clickOrFocusInput(state: TypeaheadState): {
    isFocused: boolean;
    showMenu: boolean;
    activeIndex: number;
    activeItem?: import("../types").Option | undefined;
    initialItem?: import("../types").Option | undefined;
    selected: import("../types").Option[];
    shownResults: number;
    text: string;
};
export declare function hideMenu(state: TypeaheadState, props: Props): {
    activeIndex: number;
    activeItem: import("../types").Option | undefined;
    initialItem: import("../types").Option | undefined;
    showMenu: boolean;
    shownResults: number;
    isFocused: boolean;
    selected: import("../types").Option[];
    text: string;
};
export declare function toggleMenu(state: TypeaheadState, props: Props): {
    showMenu: boolean;
    activeIndex: number;
    activeItem?: import("../types").Option | undefined;
    initialItem?: import("../types").Option | undefined;
    isFocused: boolean;
    selected: import("../types").Option[];
    shownResults: number;
    text: string;
};
export {};
