import cx from 'classnames';
import React, { useState } from 'react';
import Typeahead from './Typeahead';
import Hint from '../Hint';
import Menu from '../Menu';
import MenuItem from '../MenuItem';
import options from '../../tests/data';
import { noop } from '../../tests/helpers';
export default {
    title: 'Components/Typeahead',
    component: Typeahead,
    argTypes: {
        align: {
            options: ['justify', 'left', 'right'],
            control: { type: 'radio' },
        },
        disabled: {
            control: { type: 'boolean' },
        },
        size: {
            options: ['default', 'sm', 'lg'],
            control: { type: 'radio' },
        },
    },
    parameters: {
        actions: {
            argTypesRegex: '^on.*',
        },
    },
};
const defaultProps = {
    allowNew: false,
    clearButton: false,
    flip: true,
    id: 'rbt-id',
    isLoading: undefined,
    labelKey: 'name',
    multiple: false,
    onBlur: noop,
    onChange: noop,
    onFocus: noop,
    onInputChange: noop,
    onKeyDown: noop,
    options,
    placeholder: 'Choose a state...',
    positionFixed: true,
};
const Template = (args) => (React.createElement(Typeahead, { ...args }));
export const Default = Template.bind({});
Default.args = {
    ...defaultProps,
};
export const MultiSelect = Template.bind({});
MultiSelect.args = {
    ...defaultProps,
    defaultSelected: options.slice(0, 4),
    multiple: true,
};
export const ClearButton = Template.bind({});
ClearButton.args = {
    ...defaultProps,
    clearButton: true,
    defaultSelected: options.slice(0, 1),
};
export const LoadingState = Template.bind({});
LoadingState.args = {
    ...defaultProps,
    isLoading: true,
};
export const Pagination = Template.bind({});
Pagination.args = {
    ...defaultProps,
    maxResults: 10,
    paginate: true,
};
export const AllowNew = Template.bind({});
AllowNew.args = {
    ...defaultProps,
    allowNew: true,
};
export const DisabledItem = Template.bind({});
DisabledItem.args = {
    ...defaultProps,
    options: options.map((option) => option.name === 'Alabama'
        ? { ...option, disabled: true }
        : { ...option, disabled: false }),
};
export const CustomInput = Template.bind({});
CustomInput.args = {
    ...defaultProps,
    renderInput: ({ inputRef, referenceElementRef, ...inputProps }) => (React.createElement(Hint, null,
        React.createElement("div", { className: "form-floating" },
            React.createElement("input", { ...inputProps, className: "form-control", id: "floatingInput", ref: (node) => {
                    inputRef(node);
                    referenceElementRef(node);
                } }),
            React.createElement("label", { htmlFor: "floatingInput" }, inputProps.placeholder)))),
};
export const CustomMenu = Template.bind({});
CustomMenu.args = {
    ...defaultProps,
    renderMenu: (results, menuProps) => (React.createElement(Menu, { ...menuProps }, results
        .slice()
        .reverse()
        .map((r, index) => (React.createElement(MenuItem, { key: r.name, option: r, position: index }, r.name))))),
};
export const InputGrouping = (args) => (React.createElement("div", { className: cx('input-group', {
        'input-group-sm': args.size === 'sm',
        'input-group-lg': args.size === 'lg',
    }) },
    React.createElement("span", { className: "input-group-text" }, "$"),
    React.createElement(Typeahead, { ...args }),
    React.createElement("span", { className: "input-group-text" }, ".00")));
InputGrouping.args = {
    ...defaultProps,
};
export const Controlled = (args) => {
    const [selected, setSelected] = useState(args.selected || []);
    return React.createElement(Typeahead, { ...args, onChange: setSelected, selected: selected });
};
Controlled.args = {
    ...defaultProps,
};
export const InputValidation = (args) => {
    let feedback;
    if (args.isValid) {
        feedback = 'Looks good!';
    }
    if (args.isInvalid) {
        feedback = 'Please provide a value!';
    }
    return (React.createElement("div", { className: "form-group" },
        React.createElement(Typeahead, { ...args }),
        React.createElement("div", { className: cx({
                'valid-feedback': args.isValid,
                'invalid-feedback': args.isInvalid,
            }) }, feedback)));
};
InputValidation.args = {
    ...defaultProps,
    isValid: true,
    isInvalid: false,
};
