"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFunction = isFunction;
exports.isString = isString;
exports.noop = noop;
exports.pick = pick;
exports.uniqueId = uniqueId;
var idCounter = 0;

// eslint-disable-next-line @typescript-eslint/ban-types
function isFunction(value) {
  return typeof value === 'function';
}
function isString(value) {
  return typeof value === 'string';
}
function noop() {}
function pick(obj, keys) {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  var result = {};
  keys.forEach(function (key) {
    result[key] = obj[key];
  });
  return result;
}
function uniqueId(prefix) {
  idCounter += 1;
  return (prefix == null ? '' : String(prefix)) + idCounter;
}