import PropTypes from 'prop-types';
import { Requireable } from 'react';
import type { TypeaheadProps } from './types';
export declare const sizeType: PropTypes.Requireable<"lg" | "sm">;
type Props = TypeaheadProps;
type PropName = keyof Props;
type Callback = (props: Props, propName: PropName, componentName: string) => void;
type Validator = Requireable<unknown>;
export declare function checkPropType(validator: Validator, callback: Callback): (props: Props, propName: PropName, componentName: string) => void;
export declare function caseSensitiveType(props: Props): void;
export declare function deprecated(validator: Validator, reason: string): (props: Props, propName: PropName, componentName: string) => void;
export declare function defaultInputValueType(props: Props): void;
export declare function defaultSelectedType(props: Props): void;
export declare function highlightOnlyResultType({ allowNew, highlightOnlyResult, }: Props): void;
export declare function ignoreDiacriticsType(props: Props): void;
export declare function inputPropsType({ inputProps }: Props): void;
export declare function isRequiredForA11y(props: Props, propName: PropName, componentName: string): void;
export declare function labelKeyType({ allowNew, labelKey }: Props): void;
export declare const optionType: PropTypes.Requireable<NonNullable<string | object | null | undefined>>;
export declare function selectedType({ multiple, onChange, selected }: Props): void;
export {};
