declare const _exports: {
    collections: {
        operations: string[];
        parameters: string[];
        patchOperations: string[];
        paths: string[];
        requestBodySchemas: string[];
        responseSchemas: string[];
        schemas: string[];
        securitySchemes: string[];
        unresolvedRequestBodySchemas: string[];
        unresolvedResponseSchemas: string[];
        unresolvedSchemas: string[];
    };
    validateComposedSchemas: typeof import("./utils/validate-composed-schemas");
    validateNestedSchemas: typeof import("./utils/validate-nested-schemas");
    validateSubschemas: typeof import("./utils/validate-subschemas");
    getNodes: typeof import("./utils/spectral-context-utils").getNodes;
    getResolvedSpec: typeof import("./utils/spectral-context-utils").getResolvedSpec;
    getUnresolvedSpec: typeof import("./utils/spectral-context-utils").getUnresolvedSpec;
    isObject: typeof import("./utils/is-object");
    schemaHasConstraint: typeof import("./utils/schema-has-constraint");
    schemaHasProperty: typeof import("./utils/schema-has-property");
    schemaLooselyHasConstraint: typeof import("./utils/schema-loosely-has-constraint");
    schemaRequiresProperty: typeof import("./utils/schema-requires-property");
    SchemaType: {
        ARRAY: symbol;
        BINARY: symbol;
        BOOLEAN: symbol;
        BYTE: symbol;
        DATE: symbol;
        DATE_TIME: symbol;
        DOUBLE: symbol;
        ENUMERATION: symbol;
        FLOAT: symbol;
        INT32: symbol;
        INT64: symbol;
        INTEGER: symbol;
        NUMBER: symbol;
        OBJECT: symbol;
        STRING: symbol;
        UNKNOWN: symbol;
    };
    getSchemaType: typeof import("./utils/get-schema-type").getSchemaType;
    isArraySchema: typeof import("./utils/get-schema-type").isArraySchema;
    isBinarySchema: typeof import("./utils/get-schema-type").isBinarySchema;
    isBooleanSchema: typeof import("./utils/get-schema-type").isBooleanSchema;
    isByteSchema: typeof import("./utils/get-schema-type").isByteSchema;
    isDateSchema: typeof import("./utils/get-schema-type").isDateSchema;
    isDateTimeSchema: typeof import("./utils/get-schema-type").isDateTimeSchema;
    isDoubleSchema: typeof import("./utils/get-schema-type").isDoubleSchema;
    isEnumerationSchema: typeof import("./utils/get-schema-type").isEnumerationSchema;
    isFloatSchema: typeof import("./utils/get-schema-type").isFloatSchema;
    isInt32Schema: typeof import("./utils/get-schema-type").isInt32Schema;
    isInt64Schema: typeof import("./utils/get-schema-type").isInt64Schema;
    isIntegerSchema: typeof import("./utils/get-schema-type").isIntegerSchema;
    isNumberSchema: typeof import("./utils/get-schema-type").isNumberSchema;
    isObjectSchema: typeof import("./utils/get-schema-type").isObjectSchema;
    isPrimitiveSchema: typeof import("./utils/get-schema-type").isPrimitiveSchema;
    isStringSchema: typeof import("./utils/get-schema-type").isStringSchema;
    schemaIsOfType: typeof import("./utils/get-schema-type").schemaIsOfType;
    collectFromComposedSchemas: typeof import("./utils/collect-from-composed-schemas");
    getExamplesForSchema: typeof import("./utils/get-examples-for-schema");
    getPropertyNamesForSchema: typeof import("./utils/get-property-names-for-schema");
};
export = _exports;
//# sourceMappingURL=index.d.ts.map