/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import AuthenticationFilter from './AuthenticationFilter';
import AuthenticationProtectionConfiguration from './AuthenticationProtectionConfiguration';
import AuthorizationRequestCustomParameter from './AuthorizationRequestCustomParameter';
import CIBAEndUserNotificationConfig from './CIBAEndUserNotificationConfig';
import ClientAuthenticationFilter from './ClientAuthenticationFilter';
import ConnectionServiceConfiguration from './ConnectionServiceConfiguration';
import CorsConfigurationFilter from './CorsConfigurationFilter';
import EngineConfig from './EngineConfig';
import LockMessageConfig from './LockMessageConfig';
import SsaConfiguration from './SsaConfiguration';
import SsaValidationConfig from './SsaValidationConfig';
import TrustedIssuerConfig from './TrustedIssuerConfig';

/**
 * The AppConfiguration model module.
 * @module model/AppConfiguration
 * @version OAS Version
 */
class AppConfiguration {
    /**
     * Constructs a new <code>AppConfiguration</code>.
     * @alias module:model/AppConfiguration
     */
    constructor() { 
        
        AppConfiguration.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>AppConfiguration</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/AppConfiguration} obj Optional instance to populate.
     * @return {module:model/AppConfiguration} The populated <code>AppConfiguration</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new AppConfiguration();

            if (data.hasOwnProperty('issuer')) {
                obj['issuer'] = ApiClient.convertToType(data['issuer'], 'String');
            }
            if (data.hasOwnProperty('baseEndpoint')) {
                obj['baseEndpoint'] = ApiClient.convertToType(data['baseEndpoint'], 'String');
            }
            if (data.hasOwnProperty('authorizationEndpoint')) {
                obj['authorizationEndpoint'] = ApiClient.convertToType(data['authorizationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('authorizationChallengeEndpoint')) {
                obj['authorizationChallengeEndpoint'] = ApiClient.convertToType(data['authorizationChallengeEndpoint'], 'String');
            }
            if (data.hasOwnProperty('tokenEndpoint')) {
                obj['tokenEndpoint'] = ApiClient.convertToType(data['tokenEndpoint'], 'String');
            }
            if (data.hasOwnProperty('tokenRevocationEndpoint')) {
                obj['tokenRevocationEndpoint'] = ApiClient.convertToType(data['tokenRevocationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('userInfoEndpoint')) {
                obj['userInfoEndpoint'] = ApiClient.convertToType(data['userInfoEndpoint'], 'String');
            }
            if (data.hasOwnProperty('clientInfoEndpoint')) {
                obj['clientInfoEndpoint'] = ApiClient.convertToType(data['clientInfoEndpoint'], 'String');
            }
            if (data.hasOwnProperty('checkSessionIFrame')) {
                obj['checkSessionIFrame'] = ApiClient.convertToType(data['checkSessionIFrame'], 'String');
            }
            if (data.hasOwnProperty('endSessionEndpoint')) {
                obj['endSessionEndpoint'] = ApiClient.convertToType(data['endSessionEndpoint'], 'String');
            }
            if (data.hasOwnProperty('jwksUri')) {
                obj['jwksUri'] = ApiClient.convertToType(data['jwksUri'], 'String');
            }
            if (data.hasOwnProperty('archivedJwksUri')) {
                obj['archivedJwksUri'] = ApiClient.convertToType(data['archivedJwksUri'], 'String');
            }
            if (data.hasOwnProperty('registrationEndpoint')) {
                obj['registrationEndpoint'] = ApiClient.convertToType(data['registrationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('openIdDiscoveryEndpoint')) {
                obj['openIdDiscoveryEndpoint'] = ApiClient.convertToType(data['openIdDiscoveryEndpoint'], 'String');
            }
            if (data.hasOwnProperty('openIdConfigurationEndpoint')) {
                obj['openIdConfigurationEndpoint'] = ApiClient.convertToType(data['openIdConfigurationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('idGenerationEndpoint')) {
                obj['idGenerationEndpoint'] = ApiClient.convertToType(data['idGenerationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('introspectionEndpoint')) {
                obj['introspectionEndpoint'] = ApiClient.convertToType(data['introspectionEndpoint'], 'String');
            }
            if (data.hasOwnProperty('parEndpoint')) {
                obj['parEndpoint'] = ApiClient.convertToType(data['parEndpoint'], 'String');
            }
            if (data.hasOwnProperty('allowClientAssertionAudWithoutStrictIssuerMatch')) {
                obj['allowClientAssertionAudWithoutStrictIssuerMatch'] = ApiClient.convertToType(data['allowClientAssertionAudWithoutStrictIssuerMatch'], 'Boolean');
            }
            if (data.hasOwnProperty('requirePar')) {
                obj['requirePar'] = ApiClient.convertToType(data['requirePar'], 'Boolean');
            }
            if (data.hasOwnProperty('parForbidPublicClient')) {
                obj['parForbidPublicClient'] = ApiClient.convertToType(data['parForbidPublicClient'], 'Boolean');
            }
            if (data.hasOwnProperty('deviceAuthzEndpoint')) {
                obj['deviceAuthzEndpoint'] = ApiClient.convertToType(data['deviceAuthzEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsAuthorizationEndpoint')) {
                obj['mtlsAuthorizationEndpoint'] = ApiClient.convertToType(data['mtlsAuthorizationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsAuthorizationChallengeEndpoint')) {
                obj['mtlsAuthorizationChallengeEndpoint'] = ApiClient.convertToType(data['mtlsAuthorizationChallengeEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsTokenEndpoint')) {
                obj['mtlsTokenEndpoint'] = ApiClient.convertToType(data['mtlsTokenEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsTokenRevocationEndpoint')) {
                obj['mtlsTokenRevocationEndpoint'] = ApiClient.convertToType(data['mtlsTokenRevocationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsUserInfoEndpoint')) {
                obj['mtlsUserInfoEndpoint'] = ApiClient.convertToType(data['mtlsUserInfoEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsClientInfoEndpoint')) {
                obj['mtlsClientInfoEndpoint'] = ApiClient.convertToType(data['mtlsClientInfoEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsCheckSessionIFrame')) {
                obj['mtlsCheckSessionIFrame'] = ApiClient.convertToType(data['mtlsCheckSessionIFrame'], 'String');
            }
            if (data.hasOwnProperty('mtlsEndSessionEndpoint')) {
                obj['mtlsEndSessionEndpoint'] = ApiClient.convertToType(data['mtlsEndSessionEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsJwksUri')) {
                obj['mtlsJwksUri'] = ApiClient.convertToType(data['mtlsJwksUri'], 'String');
            }
            if (data.hasOwnProperty('mtlsRegistrationEndpoint')) {
                obj['mtlsRegistrationEndpoint'] = ApiClient.convertToType(data['mtlsRegistrationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsIdGenerationEndpoint')) {
                obj['mtlsIdGenerationEndpoint'] = ApiClient.convertToType(data['mtlsIdGenerationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsIntrospectionEndpoint')) {
                obj['mtlsIntrospectionEndpoint'] = ApiClient.convertToType(data['mtlsIntrospectionEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsParEndpoint')) {
                obj['mtlsParEndpoint'] = ApiClient.convertToType(data['mtlsParEndpoint'], 'String');
            }
            if (data.hasOwnProperty('mtlsDeviceAuthzEndpoint')) {
                obj['mtlsDeviceAuthzEndpoint'] = ApiClient.convertToType(data['mtlsDeviceAuthzEndpoint'], 'String');
            }
            if (data.hasOwnProperty('accessEvaluationAllowBasicClientAuthorization')) {
                obj['accessEvaluationAllowBasicClientAuthorization'] = ApiClient.convertToType(data['accessEvaluationAllowBasicClientAuthorization'], 'Boolean');
            }
            if (data.hasOwnProperty('accessEvaluationScriptName')) {
                obj['accessEvaluationScriptName'] = ApiClient.convertToType(data['accessEvaluationScriptName'], 'String');
            }
            if (data.hasOwnProperty('accessEvaluationDiscoveryCacheLifetimeInMinutes')) {
                obj['accessEvaluationDiscoveryCacheLifetimeInMinutes'] = ApiClient.convertToType(data['accessEvaluationDiscoveryCacheLifetimeInMinutes'], 'Number');
            }
            if (data.hasOwnProperty('requireRequestObjectEncryption')) {
                obj['requireRequestObjectEncryption'] = ApiClient.convertToType(data['requireRequestObjectEncryption'], 'Boolean');
            }
            if (data.hasOwnProperty('requirePkce')) {
                obj['requirePkce'] = ApiClient.convertToType(data['requirePkce'], 'Boolean');
            }
            if (data.hasOwnProperty('allowAllValueForRevokeEndpoint')) {
                obj['allowAllValueForRevokeEndpoint'] = ApiClient.convertToType(data['allowAllValueForRevokeEndpoint'], 'Boolean');
            }
            if (data.hasOwnProperty('allowRevokeForOtherClients')) {
                obj['allowRevokeForOtherClients'] = ApiClient.convertToType(data['allowRevokeForOtherClients'], 'Boolean');
            }
            if (data.hasOwnProperty('sectorIdentifierCacheLifetimeInMinutes')) {
                obj['sectorIdentifierCacheLifetimeInMinutes'] = ApiClient.convertToType(data['sectorIdentifierCacheLifetimeInMinutes'], 'Number');
            }
            if (data.hasOwnProperty('archivedJwkLifetimeInSeconds')) {
                obj['archivedJwkLifetimeInSeconds'] = ApiClient.convertToType(data['archivedJwkLifetimeInSeconds'], 'Number');
            }
            if (data.hasOwnProperty('uppercaseResponseKeysInAccountAccessConsent')) {
                obj['uppercaseResponseKeysInAccountAccessConsent'] = ApiClient.convertToType(data['uppercaseResponseKeysInAccountAccessConsent'], 'Boolean');
            }
            if (data.hasOwnProperty('umaConfigurationEndpoint')) {
                obj['umaConfigurationEndpoint'] = ApiClient.convertToType(data['umaConfigurationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('umaRptAsJwt')) {
                obj['umaRptAsJwt'] = ApiClient.convertToType(data['umaRptAsJwt'], 'Boolean');
            }
            if (data.hasOwnProperty('umaRptLifetime')) {
                obj['umaRptLifetime'] = ApiClient.convertToType(data['umaRptLifetime'], 'Number');
            }
            if (data.hasOwnProperty('umaTicketLifetime')) {
                obj['umaTicketLifetime'] = ApiClient.convertToType(data['umaTicketLifetime'], 'Number');
            }
            if (data.hasOwnProperty('umaPctLifetime')) {
                obj['umaPctLifetime'] = ApiClient.convertToType(data['umaPctLifetime'], 'Number');
            }
            if (data.hasOwnProperty('umaResourceLifetime')) {
                obj['umaResourceLifetime'] = ApiClient.convertToType(data['umaResourceLifetime'], 'Number');
            }
            if (data.hasOwnProperty('umaAddScopesAutomatically')) {
                obj['umaAddScopesAutomatically'] = ApiClient.convertToType(data['umaAddScopesAutomatically'], 'Boolean');
            }
            if (data.hasOwnProperty('umaValidateClaimToken')) {
                obj['umaValidateClaimToken'] = ApiClient.convertToType(data['umaValidateClaimToken'], 'Boolean');
            }
            if (data.hasOwnProperty('umaGrantAccessIfNoPolicies')) {
                obj['umaGrantAccessIfNoPolicies'] = ApiClient.convertToType(data['umaGrantAccessIfNoPolicies'], 'Boolean');
            }
            if (data.hasOwnProperty('umaRestrictResourceToAssociatedClient')) {
                obj['umaRestrictResourceToAssociatedClient'] = ApiClient.convertToType(data['umaRestrictResourceToAssociatedClient'], 'Boolean');
            }
            if (data.hasOwnProperty('statTimerIntervalInSeconds')) {
                obj['statTimerIntervalInSeconds'] = ApiClient.convertToType(data['statTimerIntervalInSeconds'], 'Number');
            }
            if (data.hasOwnProperty('statAuthorizationScope')) {
                obj['statAuthorizationScope'] = ApiClient.convertToType(data['statAuthorizationScope'], 'String');
            }
            if (data.hasOwnProperty('allowSpontaneousScopes')) {
                obj['allowSpontaneousScopes'] = ApiClient.convertToType(data['allowSpontaneousScopes'], 'Boolean');
            }
            if (data.hasOwnProperty('spontaneousScopeLifetime')) {
                obj['spontaneousScopeLifetime'] = ApiClient.convertToType(data['spontaneousScopeLifetime'], 'Number');
            }
            if (data.hasOwnProperty('statusListBitSize')) {
                obj['statusListBitSize'] = ApiClient.convertToType(data['statusListBitSize'], 'Number');
            }
            if (data.hasOwnProperty('statusListResponseJwtSignatureAlgorithm')) {
                obj['statusListResponseJwtSignatureAlgorithm'] = ApiClient.convertToType(data['statusListResponseJwtSignatureAlgorithm'], 'String');
            }
            if (data.hasOwnProperty('statusListResponseJwtLifetime')) {
                obj['statusListResponseJwtLifetime'] = ApiClient.convertToType(data['statusListResponseJwtLifetime'], 'Number');
            }
            if (data.hasOwnProperty('statusListIndexAllocationBlockSize')) {
                obj['statusListIndexAllocationBlockSize'] = ApiClient.convertToType(data['statusListIndexAllocationBlockSize'], 'Number');
            }
            if (data.hasOwnProperty('openidSubAttribute')) {
                obj['openidSubAttribute'] = ApiClient.convertToType(data['openidSubAttribute'], 'String');
            }
            if (data.hasOwnProperty('publicSubjectIdentifierPerClientEnabled')) {
                obj['publicSubjectIdentifierPerClientEnabled'] = ApiClient.convertToType(data['publicSubjectIdentifierPerClientEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('subjectIdentifiersPerClientSupported')) {
                obj['subjectIdentifiersPerClientSupported'] = ApiClient.convertToType(data['subjectIdentifiersPerClientSupported'], ['String']);
            }
            if (data.hasOwnProperty('applyXFrameOptionsHeaderIfUriContainsAny')) {
                obj['applyXFrameOptionsHeaderIfUriContainsAny'] = ApiClient.convertToType(data['applyXFrameOptionsHeaderIfUriContainsAny'], ['String']);
            }
            if (data.hasOwnProperty('xframeOptionsHeaderValue')) {
                obj['xframeOptionsHeaderValue'] = ApiClient.convertToType(data['xframeOptionsHeaderValue'], 'String');
            }
            if (data.hasOwnProperty('responseTypesSupported')) {
                obj['responseTypesSupported'] = ApiClient.convertToType(data['responseTypesSupported'], [['String']]);
            }
            if (data.hasOwnProperty('responseModesSupported')) {
                obj['responseModesSupported'] = ApiClient.convertToType(data['responseModesSupported'], ['String']);
            }
            if (data.hasOwnProperty('grantTypesSupported')) {
                obj['grantTypesSupported'] = ApiClient.convertToType(data['grantTypesSupported'], ['String']);
            }
            if (data.hasOwnProperty('subjectTypesSupported')) {
                obj['subjectTypesSupported'] = ApiClient.convertToType(data['subjectTypesSupported'], ['String']);
            }
            if (data.hasOwnProperty('defaultSubjectType')) {
                obj['defaultSubjectType'] = ApiClient.convertToType(data['defaultSubjectType'], 'String');
            }
            if (data.hasOwnProperty('authorizationSigningAlgValuesSupported')) {
                obj['authorizationSigningAlgValuesSupported'] = ApiClient.convertToType(data['authorizationSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('authorizationEncryptionAlgValuesSupported')) {
                obj['authorizationEncryptionAlgValuesSupported'] = ApiClient.convertToType(data['authorizationEncryptionAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('authorizationEncryptionEncValuesSupported')) {
                obj['authorizationEncryptionEncValuesSupported'] = ApiClient.convertToType(data['authorizationEncryptionEncValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('userInfoSigningAlgValuesSupported')) {
                obj['userInfoSigningAlgValuesSupported'] = ApiClient.convertToType(data['userInfoSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('userInfoEncryptionAlgValuesSupported')) {
                obj['userInfoEncryptionAlgValuesSupported'] = ApiClient.convertToType(data['userInfoEncryptionAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('userInfoEncryptionEncValuesSupported')) {
                obj['userInfoEncryptionEncValuesSupported'] = ApiClient.convertToType(data['userInfoEncryptionEncValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('introspectionSigningAlgValuesSupported')) {
                obj['introspectionSigningAlgValuesSupported'] = ApiClient.convertToType(data['introspectionSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('introspectionEncryptionAlgValuesSupported')) {
                obj['introspectionEncryptionAlgValuesSupported'] = ApiClient.convertToType(data['introspectionEncryptionAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('introspectionEncryptionEncValuesSupported')) {
                obj['introspectionEncryptionEncValuesSupported'] = ApiClient.convertToType(data['introspectionEncryptionEncValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('logoutStatusJwtSigningAlgValuesSupported')) {
                obj['logoutStatusJwtSigningAlgValuesSupported'] = ApiClient.convertToType(data['logoutStatusJwtSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('txTokenSigningAlgValuesSupported')) {
                obj['txTokenSigningAlgValuesSupported'] = ApiClient.convertToType(data['txTokenSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('txTokenEncryptionAlgValuesSupported')) {
                obj['txTokenEncryptionAlgValuesSupported'] = ApiClient.convertToType(data['txTokenEncryptionAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('txTokenEncryptionEncValuesSupported')) {
                obj['txTokenEncryptionEncValuesSupported'] = ApiClient.convertToType(data['txTokenEncryptionEncValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('idTokenSigningAlgValuesSupported')) {
                obj['idTokenSigningAlgValuesSupported'] = ApiClient.convertToType(data['idTokenSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('idTokenEncryptionAlgValuesSupported')) {
                obj['idTokenEncryptionAlgValuesSupported'] = ApiClient.convertToType(data['idTokenEncryptionAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('idTokenEncryptionEncValuesSupported')) {
                obj['idTokenEncryptionEncValuesSupported'] = ApiClient.convertToType(data['idTokenEncryptionEncValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('accessTokenSigningAlgValuesSupported')) {
                obj['accessTokenSigningAlgValuesSupported'] = ApiClient.convertToType(data['accessTokenSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('forceSignedRequestObject')) {
                obj['forceSignedRequestObject'] = ApiClient.convertToType(data['forceSignedRequestObject'], 'Boolean');
            }
            if (data.hasOwnProperty('requestObjectSigningAlgValuesSupported')) {
                obj['requestObjectSigningAlgValuesSupported'] = ApiClient.convertToType(data['requestObjectSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('requestObjectEncryptionAlgValuesSupported')) {
                obj['requestObjectEncryptionAlgValuesSupported'] = ApiClient.convertToType(data['requestObjectEncryptionAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('requestObjectEncryptionEncValuesSupported')) {
                obj['requestObjectEncryptionEncValuesSupported'] = ApiClient.convertToType(data['requestObjectEncryptionEncValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('tokenEndpointAuthMethodsSupported')) {
                obj['tokenEndpointAuthMethodsSupported'] = ApiClient.convertToType(data['tokenEndpointAuthMethodsSupported'], ['String']);
            }
            if (data.hasOwnProperty('tokenEndpointAuthSigningAlgValuesSupported')) {
                obj['tokenEndpointAuthSigningAlgValuesSupported'] = ApiClient.convertToType(data['tokenEndpointAuthSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('dynamicRegistrationCustomAttributes')) {
                obj['dynamicRegistrationCustomAttributes'] = ApiClient.convertToType(data['dynamicRegistrationCustomAttributes'], ['String']);
            }
            if (data.hasOwnProperty('dynamicRegistrationDefaultCustomAttributes')) {
                obj['dynamicRegistrationDefaultCustomAttributes'] = ApiClient.convertToType(data['dynamicRegistrationDefaultCustomAttributes'], Object);
            }
            if (data.hasOwnProperty('displayValuesSupported')) {
                obj['displayValuesSupported'] = ApiClient.convertToType(data['displayValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('claimTypesSupported')) {
                obj['claimTypesSupported'] = ApiClient.convertToType(data['claimTypesSupported'], ['String']);
            }
            if (data.hasOwnProperty('jwksAlgorithmsSupported')) {
                obj['jwksAlgorithmsSupported'] = ApiClient.convertToType(data['jwksAlgorithmsSupported'], ['String']);
            }
            if (data.hasOwnProperty('serviceDocumentation')) {
                obj['serviceDocumentation'] = ApiClient.convertToType(data['serviceDocumentation'], 'String');
            }
            if (data.hasOwnProperty('claimsLocalesSupported')) {
                obj['claimsLocalesSupported'] = ApiClient.convertToType(data['claimsLocalesSupported'], ['String']);
            }
            if (data.hasOwnProperty('idTokenTokenBindingCnfValuesSupported')) {
                obj['idTokenTokenBindingCnfValuesSupported'] = ApiClient.convertToType(data['idTokenTokenBindingCnfValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('uiLocalesSupported')) {
                obj['uiLocalesSupported'] = ApiClient.convertToType(data['uiLocalesSupported'], ['String']);
            }
            if (data.hasOwnProperty('claimsParameterSupported')) {
                obj['claimsParameterSupported'] = ApiClient.convertToType(data['claimsParameterSupported'], 'Boolean');
            }
            if (data.hasOwnProperty('requestParameterSupported')) {
                obj['requestParameterSupported'] = ApiClient.convertToType(data['requestParameterSupported'], 'Boolean');
            }
            if (data.hasOwnProperty('requestUriParameterSupported')) {
                obj['requestUriParameterSupported'] = ApiClient.convertToType(data['requestUriParameterSupported'], 'Boolean');
            }
            if (data.hasOwnProperty('requestUriHashVerificationEnabled')) {
                obj['requestUriHashVerificationEnabled'] = ApiClient.convertToType(data['requestUriHashVerificationEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('requireRequestUriRegistration')) {
                obj['requireRequestUriRegistration'] = ApiClient.convertToType(data['requireRequestUriRegistration'], 'Boolean');
            }
            if (data.hasOwnProperty('requestUriBlockList')) {
                obj['requestUriBlockList'] = ApiClient.convertToType(data['requestUriBlockList'], ['String']);
            }
            if (data.hasOwnProperty('opPolicyUri')) {
                obj['opPolicyUri'] = ApiClient.convertToType(data['opPolicyUri'], 'String');
            }
            if (data.hasOwnProperty('opTosUri')) {
                obj['opTosUri'] = ApiClient.convertToType(data['opTosUri'], 'String');
            }
            if (data.hasOwnProperty('clientPeriodicUpdateTimerInterval')) {
                obj['clientPeriodicUpdateTimerInterval'] = ApiClient.convertToType(data['clientPeriodicUpdateTimerInterval'], 'Number');
            }
            if (data.hasOwnProperty('authorizationCodeLifetime')) {
                obj['authorizationCodeLifetime'] = ApiClient.convertToType(data['authorizationCodeLifetime'], 'Number');
            }
            if (data.hasOwnProperty('refreshTokenLifetime')) {
                obj['refreshTokenLifetime'] = ApiClient.convertToType(data['refreshTokenLifetime'], 'Number');
            }
            if (data.hasOwnProperty('txTokenLifetime')) {
                obj['txTokenLifetime'] = ApiClient.convertToType(data['txTokenLifetime'], 'Number');
            }
            if (data.hasOwnProperty('idTokenLifetime')) {
                obj['idTokenLifetime'] = ApiClient.convertToType(data['idTokenLifetime'], 'Number');
            }
            if (data.hasOwnProperty('idTokenFilterClaimsBasedOnAccessToken')) {
                obj['idTokenFilterClaimsBasedOnAccessToken'] = ApiClient.convertToType(data['idTokenFilterClaimsBasedOnAccessToken'], 'Boolean');
            }
            if (data.hasOwnProperty('saveTokensInCache')) {
                obj['saveTokensInCache'] = ApiClient.convertToType(data['saveTokensInCache'], 'Boolean');
            }
            if (data.hasOwnProperty('saveTokensInCacheAndDontSaveInPersistence')) {
                obj['saveTokensInCacheAndDontSaveInPersistence'] = ApiClient.convertToType(data['saveTokensInCacheAndDontSaveInPersistence'], 'Boolean');
            }
            if (data.hasOwnProperty('accessTokenLifetime')) {
                obj['accessTokenLifetime'] = ApiClient.convertToType(data['accessTokenLifetime'], 'Number');
            }
            if (data.hasOwnProperty('userInfoLifetime')) {
                obj['userInfoLifetime'] = ApiClient.convertToType(data['userInfoLifetime'], 'Number');
            }
            if (data.hasOwnProperty('keyRegenerationEnabled')) {
                obj['keyRegenerationEnabled'] = ApiClient.convertToType(data['keyRegenerationEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('keyRegenerationInterval')) {
                obj['keyRegenerationInterval'] = ApiClient.convertToType(data['keyRegenerationInterval'], 'Number');
            }
            if (data.hasOwnProperty('defaultSignatureAlgorithm')) {
                obj['defaultSignatureAlgorithm'] = ApiClient.convertToType(data['defaultSignatureAlgorithm'], 'String');
            }
            if (data.hasOwnProperty('jansOpenIdConnectVersion')) {
                obj['jansOpenIdConnectVersion'] = ApiClient.convertToType(data['jansOpenIdConnectVersion'], 'String');
            }
            if (data.hasOwnProperty('jansId')) {
                obj['jansId'] = ApiClient.convertToType(data['jansId'], 'String');
            }
            if (data.hasOwnProperty('dynamicRegistrationExpirationTime')) {
                obj['dynamicRegistrationExpirationTime'] = ApiClient.convertToType(data['dynamicRegistrationExpirationTime'], 'Number');
            }
            if (data.hasOwnProperty('dynamicRegistrationPersistClientAuthorizations')) {
                obj['dynamicRegistrationPersistClientAuthorizations'] = ApiClient.convertToType(data['dynamicRegistrationPersistClientAuthorizations'], 'Boolean');
            }
            if (data.hasOwnProperty('trustedClientEnabled')) {
                obj['trustedClientEnabled'] = ApiClient.convertToType(data['trustedClientEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('skipAuthorizationForOpenIdScopeAndPairwiseId')) {
                obj['skipAuthorizationForOpenIdScopeAndPairwiseId'] = ApiClient.convertToType(data['skipAuthorizationForOpenIdScopeAndPairwiseId'], 'Boolean');
            }
            if (data.hasOwnProperty('dynamicRegistrationScopesParamEnabled')) {
                obj['dynamicRegistrationScopesParamEnabled'] = ApiClient.convertToType(data['dynamicRegistrationScopesParamEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('dynamicRegistrationPasswordGrantTypeEnabled')) {
                obj['dynamicRegistrationPasswordGrantTypeEnabled'] = ApiClient.convertToType(data['dynamicRegistrationPasswordGrantTypeEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('dynamicRegistrationAllowedPasswordGrantScopes')) {
                obj['dynamicRegistrationAllowedPasswordGrantScopes'] = ApiClient.convertToType(data['dynamicRegistrationAllowedPasswordGrantScopes'], ['String']);
            }
            if (data.hasOwnProperty('dynamicRegistrationCustomObjectClass')) {
                obj['dynamicRegistrationCustomObjectClass'] = ApiClient.convertToType(data['dynamicRegistrationCustomObjectClass'], 'String');
            }
            if (data.hasOwnProperty('personCustomObjectClassList')) {
                obj['personCustomObjectClassList'] = ApiClient.convertToType(data['personCustomObjectClassList'], ['String']);
            }
            if (data.hasOwnProperty('persistIdToken')) {
                obj['persistIdToken'] = ApiClient.convertToType(data['persistIdToken'], 'Boolean');
            }
            if (data.hasOwnProperty('persistRefreshToken')) {
                obj['persistRefreshToken'] = ApiClient.convertToType(data['persistRefreshToken'], 'Boolean');
            }
            if (data.hasOwnProperty('allowPostLogoutRedirectWithoutValidation')) {
                obj['allowPostLogoutRedirectWithoutValidation'] = ApiClient.convertToType(data['allowPostLogoutRedirectWithoutValidation'], 'Boolean');
            }
            if (data.hasOwnProperty('invalidateSessionCookiesAfterAuthorizationFlow')) {
                obj['invalidateSessionCookiesAfterAuthorizationFlow'] = ApiClient.convertToType(data['invalidateSessionCookiesAfterAuthorizationFlow'], 'Boolean');
            }
            if (data.hasOwnProperty('returnClientSecretOnRead')) {
                obj['returnClientSecretOnRead'] = ApiClient.convertToType(data['returnClientSecretOnRead'], 'Boolean');
            }
            if (data.hasOwnProperty('rotateClientRegistrationAccessTokenOnUsage')) {
                obj['rotateClientRegistrationAccessTokenOnUsage'] = ApiClient.convertToType(data['rotateClientRegistrationAccessTokenOnUsage'], 'Boolean');
            }
            if (data.hasOwnProperty('rejectJwtWithNoneAlg')) {
                obj['rejectJwtWithNoneAlg'] = ApiClient.convertToType(data['rejectJwtWithNoneAlg'], 'Boolean');
            }
            if (data.hasOwnProperty('expirationNotificatorEnabled')) {
                obj['expirationNotificatorEnabled'] = ApiClient.convertToType(data['expirationNotificatorEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('useNestedJwtDuringEncryption')) {
                obj['useNestedJwtDuringEncryption'] = ApiClient.convertToType(data['useNestedJwtDuringEncryption'], 'Boolean');
            }
            if (data.hasOwnProperty('expirationNotificatorMapSizeLimit')) {
                obj['expirationNotificatorMapSizeLimit'] = ApiClient.convertToType(data['expirationNotificatorMapSizeLimit'], 'Number');
            }
            if (data.hasOwnProperty('expirationNotificatorIntervalInSeconds')) {
                obj['expirationNotificatorIntervalInSeconds'] = ApiClient.convertToType(data['expirationNotificatorIntervalInSeconds'], 'Number');
            }
            if (data.hasOwnProperty('redirectUrisRegexEnabled')) {
                obj['redirectUrisRegexEnabled'] = ApiClient.convertToType(data['redirectUrisRegexEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('useHighestLevelScriptIfAcrScriptNotFound')) {
                obj['useHighestLevelScriptIfAcrScriptNotFound'] = ApiClient.convertToType(data['useHighestLevelScriptIfAcrScriptNotFound'], 'Boolean');
            }
            if (data.hasOwnProperty('acrMappings')) {
                obj['acrMappings'] = ApiClient.convertToType(data['acrMappings'], {'String': 'String'});
            }
            if (data.hasOwnProperty('acrToConsentScriptNameMapping')) {
                obj['acrToConsentScriptNameMapping'] = ApiClient.convertToType(data['acrToConsentScriptNameMapping'], {'String': 'String'});
            }
            if (data.hasOwnProperty('acrToAgamaConsentFlowMapping')) {
                obj['acrToAgamaConsentFlowMapping'] = ApiClient.convertToType(data['acrToAgamaConsentFlowMapping'], {'String': 'String'});
            }
            if (data.hasOwnProperty('authenticationFiltersEnabled')) {
                obj['authenticationFiltersEnabled'] = ApiClient.convertToType(data['authenticationFiltersEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('clientAuthenticationFiltersEnabled')) {
                obj['clientAuthenticationFiltersEnabled'] = ApiClient.convertToType(data['clientAuthenticationFiltersEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('clientRegDefaultToCodeFlowWithRefresh')) {
                obj['clientRegDefaultToCodeFlowWithRefresh'] = ApiClient.convertToType(data['clientRegDefaultToCodeFlowWithRefresh'], 'Boolean');
            }
            if (data.hasOwnProperty('grantTypesAndResponseTypesAutofixEnabled')) {
                obj['grantTypesAndResponseTypesAutofixEnabled'] = ApiClient.convertToType(data['grantTypesAndResponseTypesAutofixEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('authenticationFilters')) {
                obj['authenticationFilters'] = ApiClient.convertToType(data['authenticationFilters'], [AuthenticationFilter]);
            }
            if (data.hasOwnProperty('clientAuthenticationFilters')) {
                obj['clientAuthenticationFilters'] = ApiClient.convertToType(data['clientAuthenticationFilters'], [ClientAuthenticationFilter]);
            }
            if (data.hasOwnProperty('corsConfigurationFilters')) {
                obj['corsConfigurationFilters'] = ApiClient.convertToType(data['corsConfigurationFilters'], [CorsConfigurationFilter]);
            }
            if (data.hasOwnProperty('sessionIdUnusedLifetime')) {
                obj['sessionIdUnusedLifetime'] = ApiClient.convertToType(data['sessionIdUnusedLifetime'], 'Number');
            }
            if (data.hasOwnProperty('sessionIdUnauthenticatedUnusedLifetime')) {
                obj['sessionIdUnauthenticatedUnusedLifetime'] = ApiClient.convertToType(data['sessionIdUnauthenticatedUnusedLifetime'], 'Number');
            }
            if (data.hasOwnProperty('sessionIdPersistOnPromptNone')) {
                obj['sessionIdPersistOnPromptNone'] = ApiClient.convertToType(data['sessionIdPersistOnPromptNone'], 'Boolean');
            }
            if (data.hasOwnProperty('sessionIdRequestParameterEnabled')) {
                obj['sessionIdRequestParameterEnabled'] = ApiClient.convertToType(data['sessionIdRequestParameterEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('changeSessionIdOnAuthentication')) {
                obj['changeSessionIdOnAuthentication'] = ApiClient.convertToType(data['changeSessionIdOnAuthentication'], 'Boolean');
            }
            if (data.hasOwnProperty('sessionIdPersistInCache')) {
                obj['sessionIdPersistInCache'] = ApiClient.convertToType(data['sessionIdPersistInCache'], 'Boolean');
            }
            if (data.hasOwnProperty('sessionIdUserClaimsInAttributes')) {
                obj['sessionIdUserClaimsInAttributes'] = ApiClient.convertToType(data['sessionIdUserClaimsInAttributes'], ['String']);
            }
            if (data.hasOwnProperty('includeSidInResponse')) {
                obj['includeSidInResponse'] = ApiClient.convertToType(data['includeSidInResponse'], 'Boolean');
            }
            if (data.hasOwnProperty('includeRefreshTokenLifetimeInTokenResponse')) {
                obj['includeRefreshTokenLifetimeInTokenResponse'] = ApiClient.convertToType(data['includeRefreshTokenLifetimeInTokenResponse'], 'Boolean');
            }
            if (data.hasOwnProperty('disablePromptLogin')) {
                obj['disablePromptLogin'] = ApiClient.convertToType(data['disablePromptLogin'], 'Boolean');
            }
            if (data.hasOwnProperty('disablePromptConsent')) {
                obj['disablePromptConsent'] = ApiClient.convertToType(data['disablePromptConsent'], 'Boolean');
            }
            if (data.hasOwnProperty('logoutStatusJwtLifetime')) {
                obj['logoutStatusJwtLifetime'] = ApiClient.convertToType(data['logoutStatusJwtLifetime'], 'Number');
            }
            if (data.hasOwnProperty('sessionIdCookieLifetime')) {
                obj['sessionIdCookieLifetime'] = ApiClient.convertToType(data['sessionIdCookieLifetime'], 'Number');
            }
            if (data.hasOwnProperty('sessionIdLifetime')) {
                obj['sessionIdLifetime'] = ApiClient.convertToType(data['sessionIdLifetime'], 'Number');
            }
            if (data.hasOwnProperty('activeSessionAuthorizationScope')) {
                obj['activeSessionAuthorizationScope'] = ApiClient.convertToType(data['activeSessionAuthorizationScope'], 'String');
            }
            if (data.hasOwnProperty('configurationUpdateInterval')) {
                obj['configurationUpdateInterval'] = ApiClient.convertToType(data['configurationUpdateInterval'], 'Number');
            }
            if (data.hasOwnProperty('logNotFoundEntityAsError')) {
                obj['logNotFoundEntityAsError'] = ApiClient.convertToType(data['logNotFoundEntityAsError'], 'Boolean');
            }
            if (data.hasOwnProperty('enableClientGrantTypeUpdate')) {
                obj['enableClientGrantTypeUpdate'] = ApiClient.convertToType(data['enableClientGrantTypeUpdate'], 'Boolean');
            }
            if (data.hasOwnProperty('grantTypesSupportedByDynamicRegistration')) {
                obj['grantTypesSupportedByDynamicRegistration'] = ApiClient.convertToType(data['grantTypesSupportedByDynamicRegistration'], ['String']);
            }
            if (data.hasOwnProperty('cssLocation')) {
                obj['cssLocation'] = ApiClient.convertToType(data['cssLocation'], 'String');
            }
            if (data.hasOwnProperty('jsLocation')) {
                obj['jsLocation'] = ApiClient.convertToType(data['jsLocation'], 'String');
            }
            if (data.hasOwnProperty('imgLocation')) {
                obj['imgLocation'] = ApiClient.convertToType(data['imgLocation'], 'String');
            }
            if (data.hasOwnProperty('metricReporterInterval')) {
                obj['metricReporterInterval'] = ApiClient.convertToType(data['metricReporterInterval'], 'Number');
            }
            if (data.hasOwnProperty('metricReporterKeepDataDays')) {
                obj['metricReporterKeepDataDays'] = ApiClient.convertToType(data['metricReporterKeepDataDays'], 'Number');
            }
            if (data.hasOwnProperty('pairwiseIdType')) {
                obj['pairwiseIdType'] = ApiClient.convertToType(data['pairwiseIdType'], 'String');
            }
            if (data.hasOwnProperty('pairwiseCalculationKey')) {
                obj['pairwiseCalculationKey'] = ApiClient.convertToType(data['pairwiseCalculationKey'], 'String');
            }
            if (data.hasOwnProperty('pairwiseCalculationSalt')) {
                obj['pairwiseCalculationSalt'] = ApiClient.convertToType(data['pairwiseCalculationSalt'], 'String');
            }
            if (data.hasOwnProperty('shareSubjectIdBetweenClientsWithSameSectorId')) {
                obj['shareSubjectIdBetweenClientsWithSameSectorId'] = ApiClient.convertToType(data['shareSubjectIdBetweenClientsWithSameSectorId'], 'Boolean');
            }
            if (data.hasOwnProperty('useOpenidSubAttributeValueForPairwiseLocalAccountId')) {
                obj['useOpenidSubAttributeValueForPairwiseLocalAccountId'] = ApiClient.convertToType(data['useOpenidSubAttributeValueForPairwiseLocalAccountId'], 'Boolean');
            }
            if (data.hasOwnProperty('webKeysStorage')) {
                obj['webKeysStorage'] = ApiClient.convertToType(data['webKeysStorage'], 'String');
            }
            if (data.hasOwnProperty('dnName')) {
                obj['dnName'] = ApiClient.convertToType(data['dnName'], 'String');
            }
            if (data.hasOwnProperty('keyStoreFile')) {
                obj['keyStoreFile'] = ApiClient.convertToType(data['keyStoreFile'], 'String');
            }
            if (data.hasOwnProperty('keyStoreSecret')) {
                obj['keyStoreSecret'] = ApiClient.convertToType(data['keyStoreSecret'], 'String');
            }
            if (data.hasOwnProperty('keySelectionStrategy')) {
                obj['keySelectionStrategy'] = ApiClient.convertToType(data['keySelectionStrategy'], 'String');
            }
            if (data.hasOwnProperty('keyAlgsAllowedForGeneration')) {
                obj['keyAlgsAllowedForGeneration'] = ApiClient.convertToType(data['keyAlgsAllowedForGeneration'], ['String']);
            }
            if (data.hasOwnProperty('keySignWithSameKeyButDiffAlg')) {
                obj['keySignWithSameKeyButDiffAlg'] = ApiClient.convertToType(data['keySignWithSameKeyButDiffAlg'], 'Boolean');
            }
            if (data.hasOwnProperty('staticKid')) {
                obj['staticKid'] = ApiClient.convertToType(data['staticKid'], 'String');
            }
            if (data.hasOwnProperty('staticDecryptionKid')) {
                obj['staticDecryptionKid'] = ApiClient.convertToType(data['staticDecryptionKid'], 'String');
            }
            if (data.hasOwnProperty('introspectionAccessTokenMustHaveUmaProtectionScope')) {
                obj['introspectionAccessTokenMustHaveUmaProtectionScope'] = ApiClient.convertToType(data['introspectionAccessTokenMustHaveUmaProtectionScope'], 'Boolean');
            }
            if (data.hasOwnProperty('introspectionAccessTokenMustHaveIntrospectionScope')) {
                obj['introspectionAccessTokenMustHaveIntrospectionScope'] = ApiClient.convertToType(data['introspectionAccessTokenMustHaveIntrospectionScope'], 'Boolean');
            }
            if (data.hasOwnProperty('introspectionSkipAuthorization')) {
                obj['introspectionSkipAuthorization'] = ApiClient.convertToType(data['introspectionSkipAuthorization'], 'Boolean');
            }
            if (data.hasOwnProperty('introspectionRestrictBasicAuthnToOwnTokens')) {
                obj['introspectionRestrictBasicAuthnToOwnTokens'] = ApiClient.convertToType(data['introspectionRestrictBasicAuthnToOwnTokens'], 'Boolean');
            }
            if (data.hasOwnProperty('endSessionWithAccessToken')) {
                obj['endSessionWithAccessToken'] = ApiClient.convertToType(data['endSessionWithAccessToken'], 'Boolean');
            }
            if (data.hasOwnProperty('disablePromptCreate')) {
                obj['disablePromptCreate'] = ApiClient.convertToType(data['disablePromptCreate'], 'Boolean');
            }
            if (data.hasOwnProperty('cookieDomain')) {
                obj['cookieDomain'] = ApiClient.convertToType(data['cookieDomain'], 'String');
            }
            if (data.hasOwnProperty('enabledOAuthAuditLogging')) {
                obj['enabledOAuthAuditLogging'] = ApiClient.convertToType(data['enabledOAuthAuditLogging'], 'Boolean');
            }
            if (data.hasOwnProperty('jmsBrokerURISet')) {
                obj['jmsBrokerURISet'] = ApiClient.convertToType(data['jmsBrokerURISet'], ['String']);
            }
            if (data.hasOwnProperty('jmsUserName')) {
                obj['jmsUserName'] = ApiClient.convertToType(data['jmsUserName'], 'String');
            }
            if (data.hasOwnProperty('jmsPassword')) {
                obj['jmsPassword'] = ApiClient.convertToType(data['jmsPassword'], 'String');
            }
            if (data.hasOwnProperty('externalUriWhiteList')) {
                obj['externalUriWhiteList'] = ApiClient.convertToType(data['externalUriWhiteList'], ['String']);
            }
            if (data.hasOwnProperty('clientWhiteList')) {
                obj['clientWhiteList'] = ApiClient.convertToType(data['clientWhiteList'], ['String']);
            }
            if (data.hasOwnProperty('clientBlackList')) {
                obj['clientBlackList'] = ApiClient.convertToType(data['clientBlackList'], ['String']);
            }
            if (data.hasOwnProperty('legacyIdTokenClaims')) {
                obj['legacyIdTokenClaims'] = ApiClient.convertToType(data['legacyIdTokenClaims'], 'Boolean');
            }
            if (data.hasOwnProperty('customHeadersWithAuthorizationResponse')) {
                obj['customHeadersWithAuthorizationResponse'] = ApiClient.convertToType(data['customHeadersWithAuthorizationResponse'], 'Boolean');
            }
            if (data.hasOwnProperty('frontChannelLogoutSessionSupported')) {
                obj['frontChannelLogoutSessionSupported'] = ApiClient.convertToType(data['frontChannelLogoutSessionSupported'], 'Boolean');
            }
            if (data.hasOwnProperty('loggingLevel')) {
                obj['loggingLevel'] = ApiClient.convertToType(data['loggingLevel'], 'String');
            }
            if (data.hasOwnProperty('loggingLayout')) {
                obj['loggingLayout'] = ApiClient.convertToType(data['loggingLayout'], 'String');
            }
            if (data.hasOwnProperty('updateUserLastLogonTime')) {
                obj['updateUserLastLogonTime'] = ApiClient.convertToType(data['updateUserLastLogonTime'], 'Boolean');
            }
            if (data.hasOwnProperty('updateClientAccessTime')) {
                obj['updateClientAccessTime'] = ApiClient.convertToType(data['updateClientAccessTime'], 'Boolean');
            }
            if (data.hasOwnProperty('logClientIdOnClientAuthentication')) {
                obj['logClientIdOnClientAuthentication'] = ApiClient.convertToType(data['logClientIdOnClientAuthentication'], 'Boolean');
            }
            if (data.hasOwnProperty('logClientNameOnClientAuthentication')) {
                obj['logClientNameOnClientAuthentication'] = ApiClient.convertToType(data['logClientNameOnClientAuthentication'], 'Boolean');
            }
            if (data.hasOwnProperty('disableJdkLogger')) {
                obj['disableJdkLogger'] = ApiClient.convertToType(data['disableJdkLogger'], 'Boolean');
            }
            if (data.hasOwnProperty('authorizationRequestCustomAllowedParameters')) {
                obj['authorizationRequestCustomAllowedParameters'] = ApiClient.convertToType(data['authorizationRequestCustomAllowedParameters'], [AuthorizationRequestCustomParameter]);
            }
            if (data.hasOwnProperty('openidScopeBackwardCompatibility')) {
                obj['openidScopeBackwardCompatibility'] = ApiClient.convertToType(data['openidScopeBackwardCompatibility'], 'Boolean');
            }
            if (data.hasOwnProperty('disableU2fEndpoint')) {
                obj['disableU2fEndpoint'] = ApiClient.convertToType(data['disableU2fEndpoint'], 'Boolean');
            }
            if (data.hasOwnProperty('authorizationChallengeSessionLifetimeInSeconds')) {
                obj['authorizationChallengeSessionLifetimeInSeconds'] = ApiClient.convertToType(data['authorizationChallengeSessionLifetimeInSeconds'], 'Number');
            }
            if (data.hasOwnProperty('rateLimitRegistrationRequestCount')) {
                obj['rateLimitRegistrationRequestCount'] = ApiClient.convertToType(data['rateLimitRegistrationRequestCount'], 'Number');
            }
            if (data.hasOwnProperty('rateLimitRegistrationPeriodInSeconds')) {
                obj['rateLimitRegistrationPeriodInSeconds'] = ApiClient.convertToType(data['rateLimitRegistrationPeriodInSeconds'], 'Number');
            }
            if (data.hasOwnProperty('rotateDeviceSecret')) {
                obj['rotateDeviceSecret'] = ApiClient.convertToType(data['rotateDeviceSecret'], 'Boolean');
            }
            if (data.hasOwnProperty('returnDeviceSecretFromAuthzEndpoint')) {
                obj['returnDeviceSecretFromAuthzEndpoint'] = ApiClient.convertToType(data['returnDeviceSecretFromAuthzEndpoint'], 'Boolean');
            }
            if (data.hasOwnProperty('dcrForbidExpirationTimeInRequest')) {
                obj['dcrForbidExpirationTimeInRequest'] = ApiClient.convertToType(data['dcrForbidExpirationTimeInRequest'], 'Boolean');
            }
            if (data.hasOwnProperty('dcrSignatureValidationEnabled')) {
                obj['dcrSignatureValidationEnabled'] = ApiClient.convertToType(data['dcrSignatureValidationEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('dcrSignatureValidationSharedSecret')) {
                obj['dcrSignatureValidationSharedSecret'] = ApiClient.convertToType(data['dcrSignatureValidationSharedSecret'], 'String');
            }
            if (data.hasOwnProperty('dcrSignatureValidationSoftwareStatementJwksURIClaim')) {
                obj['dcrSignatureValidationSoftwareStatementJwksURIClaim'] = ApiClient.convertToType(data['dcrSignatureValidationSoftwareStatementJwksURIClaim'], 'String');
            }
            if (data.hasOwnProperty('dcrSignatureValidationSoftwareStatementJwksClaim')) {
                obj['dcrSignatureValidationSoftwareStatementJwksClaim'] = ApiClient.convertToType(data['dcrSignatureValidationSoftwareStatementJwksClaim'], 'String');
            }
            if (data.hasOwnProperty('dcrSignatureValidationJwks')) {
                obj['dcrSignatureValidationJwks'] = ApiClient.convertToType(data['dcrSignatureValidationJwks'], 'String');
            }
            if (data.hasOwnProperty('dcrSignatureValidationJwksUri')) {
                obj['dcrSignatureValidationJwksUri'] = ApiClient.convertToType(data['dcrSignatureValidationJwksUri'], 'String');
            }
            if (data.hasOwnProperty('dcrAuthorizationWithClientCredentials')) {
                obj['dcrAuthorizationWithClientCredentials'] = ApiClient.convertToType(data['dcrAuthorizationWithClientCredentials'], 'Boolean');
            }
            if (data.hasOwnProperty('dcrAuthorizationWithMTLS')) {
                obj['dcrAuthorizationWithMTLS'] = ApiClient.convertToType(data['dcrAuthorizationWithMTLS'], 'Boolean');
            }
            if (data.hasOwnProperty('dcrAttestationEvidenceRequired')) {
                obj['dcrAttestationEvidenceRequired'] = ApiClient.convertToType(data['dcrAttestationEvidenceRequired'], 'Boolean');
            }
            if (data.hasOwnProperty('trustedSsaIssuers')) {
                obj['trustedSsaIssuers'] = ApiClient.convertToType(data['trustedSsaIssuers'], {'String': TrustedIssuerConfig});
            }
            if (data.hasOwnProperty('useLocalCache')) {
                obj['useLocalCache'] = ApiClient.convertToType(data['useLocalCache'], 'Boolean');
            }
            if (data.hasOwnProperty('fapiCompatibility')) {
                obj['fapiCompatibility'] = ApiClient.convertToType(data['fapiCompatibility'], 'Boolean');
            }
            if (data.hasOwnProperty('forceIdTokenHintPresence')) {
                obj['forceIdTokenHintPresence'] = ApiClient.convertToType(data['forceIdTokenHintPresence'], 'Boolean');
            }
            if (data.hasOwnProperty('rejectEndSessionIfIdTokenExpired')) {
                obj['rejectEndSessionIfIdTokenExpired'] = ApiClient.convertToType(data['rejectEndSessionIfIdTokenExpired'], 'Boolean');
            }
            if (data.hasOwnProperty('allowEndSessionWithUnmatchedSid')) {
                obj['allowEndSessionWithUnmatchedSid'] = ApiClient.convertToType(data['allowEndSessionWithUnmatchedSid'], 'Boolean');
            }
            if (data.hasOwnProperty('forceOfflineAccessScopeToEnableRefreshToken')) {
                obj['forceOfflineAccessScopeToEnableRefreshToken'] = ApiClient.convertToType(data['forceOfflineAccessScopeToEnableRefreshToken'], 'Boolean');
            }
            if (data.hasOwnProperty('errorReasonEnabled')) {
                obj['errorReasonEnabled'] = ApiClient.convertToType(data['errorReasonEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('removeRefreshTokensForClientOnLogout')) {
                obj['removeRefreshTokensForClientOnLogout'] = ApiClient.convertToType(data['removeRefreshTokensForClientOnLogout'], 'Boolean');
            }
            if (data.hasOwnProperty('skipRefreshTokenDuringRefreshing')) {
                obj['skipRefreshTokenDuringRefreshing'] = ApiClient.convertToType(data['skipRefreshTokenDuringRefreshing'], 'Boolean');
            }
            if (data.hasOwnProperty('refreshTokenExtendLifetimeOnRotation')) {
                obj['refreshTokenExtendLifetimeOnRotation'] = ApiClient.convertToType(data['refreshTokenExtendLifetimeOnRotation'], 'Boolean');
            }
            if (data.hasOwnProperty('allowBlankValuesInDiscoveryResponse')) {
                obj['allowBlankValuesInDiscoveryResponse'] = ApiClient.convertToType(data['allowBlankValuesInDiscoveryResponse'], 'Boolean');
            }
            if (data.hasOwnProperty('checkUserPresenceOnRefreshToken')) {
                obj['checkUserPresenceOnRefreshToken'] = ApiClient.convertToType(data['checkUserPresenceOnRefreshToken'], 'Boolean');
            }
            if (data.hasOwnProperty('consentGatheringScriptBackwardCompatibility')) {
                obj['consentGatheringScriptBackwardCompatibility'] = ApiClient.convertToType(data['consentGatheringScriptBackwardCompatibility'], 'Boolean');
            }
            if (data.hasOwnProperty('introspectionScriptBackwardCompatibility')) {
                obj['introspectionScriptBackwardCompatibility'] = ApiClient.convertToType(data['introspectionScriptBackwardCompatibility'], 'Boolean');
            }
            if (data.hasOwnProperty('introspectionResponseScopesBackwardCompatibility')) {
                obj['introspectionResponseScopesBackwardCompatibility'] = ApiClient.convertToType(data['introspectionResponseScopesBackwardCompatibility'], 'Boolean');
            }
            if (data.hasOwnProperty('softwareStatementValidationType')) {
                obj['softwareStatementValidationType'] = ApiClient.convertToType(data['softwareStatementValidationType'], 'String');
            }
            if (data.hasOwnProperty('softwareStatementValidationClaimName')) {
                obj['softwareStatementValidationClaimName'] = ApiClient.convertToType(data['softwareStatementValidationClaimName'], 'String');
            }
            if (data.hasOwnProperty('authenticationProtectionConfiguration')) {
                obj['authenticationProtectionConfiguration'] = AuthenticationProtectionConfiguration.constructFromObject(data['authenticationProtectionConfiguration']);
            }
            if (data.hasOwnProperty('errorHandlingMethod')) {
                obj['errorHandlingMethod'] = ApiClient.convertToType(data['errorHandlingMethod'], 'String');
            }
            if (data.hasOwnProperty('disableAuthnForMaxAgeZero')) {
                obj['disableAuthnForMaxAgeZero'] = ApiClient.convertToType(data['disableAuthnForMaxAgeZero'], 'Boolean');
            }
            if (data.hasOwnProperty('keepAuthenticatorAttributesOnAcrChange')) {
                obj['keepAuthenticatorAttributesOnAcrChange'] = ApiClient.convertToType(data['keepAuthenticatorAttributesOnAcrChange'], 'Boolean');
            }
            if (data.hasOwnProperty('deviceAuthzRequestExpiresIn')) {
                obj['deviceAuthzRequestExpiresIn'] = ApiClient.convertToType(data['deviceAuthzRequestExpiresIn'], 'Number');
            }
            if (data.hasOwnProperty('deviceAuthzTokenPollInterval')) {
                obj['deviceAuthzTokenPollInterval'] = ApiClient.convertToType(data['deviceAuthzTokenPollInterval'], 'Number');
            }
            if (data.hasOwnProperty('deviceAuthzResponseTypeToProcessAuthz')) {
                obj['deviceAuthzResponseTypeToProcessAuthz'] = ApiClient.convertToType(data['deviceAuthzResponseTypeToProcessAuthz'], 'String');
            }
            if (data.hasOwnProperty('deviceAuthzAcr')) {
                obj['deviceAuthzAcr'] = ApiClient.convertToType(data['deviceAuthzAcr'], 'String');
            }
            if (data.hasOwnProperty('backchannelClientId')) {
                obj['backchannelClientId'] = ApiClient.convertToType(data['backchannelClientId'], 'String');
            }
            if (data.hasOwnProperty('backchannelRedirectUri')) {
                obj['backchannelRedirectUri'] = ApiClient.convertToType(data['backchannelRedirectUri'], 'String');
            }
            if (data.hasOwnProperty('backchannelAuthenticationEndpoint')) {
                obj['backchannelAuthenticationEndpoint'] = ApiClient.convertToType(data['backchannelAuthenticationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('backchannelDeviceRegistrationEndpoint')) {
                obj['backchannelDeviceRegistrationEndpoint'] = ApiClient.convertToType(data['backchannelDeviceRegistrationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('backchannelTokenDeliveryModesSupported')) {
                obj['backchannelTokenDeliveryModesSupported'] = ApiClient.convertToType(data['backchannelTokenDeliveryModesSupported'], ['String']);
            }
            if (data.hasOwnProperty('backchannelAuthenticationRequestSigningAlgValuesSupported')) {
                obj['backchannelAuthenticationRequestSigningAlgValuesSupported'] = ApiClient.convertToType(data['backchannelAuthenticationRequestSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('backchannelUserCodeParameterSupported')) {
                obj['backchannelUserCodeParameterSupported'] = ApiClient.convertToType(data['backchannelUserCodeParameterSupported'], 'Boolean');
            }
            if (data.hasOwnProperty('backchannelBindingMessagePattern')) {
                obj['backchannelBindingMessagePattern'] = ApiClient.convertToType(data['backchannelBindingMessagePattern'], 'String');
            }
            if (data.hasOwnProperty('backchannelAuthenticationResponseExpiresIn')) {
                obj['backchannelAuthenticationResponseExpiresIn'] = ApiClient.convertToType(data['backchannelAuthenticationResponseExpiresIn'], 'Number');
            }
            if (data.hasOwnProperty('backchannelAuthenticationResponseInterval')) {
                obj['backchannelAuthenticationResponseInterval'] = ApiClient.convertToType(data['backchannelAuthenticationResponseInterval'], 'Number');
            }
            if (data.hasOwnProperty('backchannelLoginHintClaims')) {
                obj['backchannelLoginHintClaims'] = ApiClient.convertToType(data['backchannelLoginHintClaims'], ['String']);
            }
            if (data.hasOwnProperty('cibaEndUserNotificationConfig')) {
                obj['cibaEndUserNotificationConfig'] = CIBAEndUserNotificationConfig.constructFromObject(data['cibaEndUserNotificationConfig']);
            }
            if (data.hasOwnProperty('backchannelRequestsProcessorJobIntervalSec')) {
                obj['backchannelRequestsProcessorJobIntervalSec'] = ApiClient.convertToType(data['backchannelRequestsProcessorJobIntervalSec'], 'Number');
            }
            if (data.hasOwnProperty('backchannelRequestsProcessorJobChunkSize')) {
                obj['backchannelRequestsProcessorJobChunkSize'] = ApiClient.convertToType(data['backchannelRequestsProcessorJobChunkSize'], 'Number');
            }
            if (data.hasOwnProperty('cibaGrantLifeExtraTimeSec')) {
                obj['cibaGrantLifeExtraTimeSec'] = ApiClient.convertToType(data['cibaGrantLifeExtraTimeSec'], 'Number');
            }
            if (data.hasOwnProperty('cibaMaxExpirationTimeAllowedSec')) {
                obj['cibaMaxExpirationTimeAllowedSec'] = ApiClient.convertToType(data['cibaMaxExpirationTimeAllowedSec'], 'Number');
            }
            if (data.hasOwnProperty('dpopSigningAlgValuesSupported')) {
                obj['dpopSigningAlgValuesSupported'] = ApiClient.convertToType(data['dpopSigningAlgValuesSupported'], ['String']);
            }
            if (data.hasOwnProperty('dpopTimeframe')) {
                obj['dpopTimeframe'] = ApiClient.convertToType(data['dpopTimeframe'], 'Number');
            }
            if (data.hasOwnProperty('dpopJtiCacheTime')) {
                obj['dpopJtiCacheTime'] = ApiClient.convertToType(data['dpopJtiCacheTime'], 'Number');
            }
            if (data.hasOwnProperty('dpopUseNonce')) {
                obj['dpopUseNonce'] = ApiClient.convertToType(data['dpopUseNonce'], 'Boolean');
            }
            if (data.hasOwnProperty('dpopNonceCacheTime')) {
                obj['dpopNonceCacheTime'] = ApiClient.convertToType(data['dpopNonceCacheTime'], 'Number');
            }
            if (data.hasOwnProperty('dpopJktForceForAuthorizationCode')) {
                obj['dpopJktForceForAuthorizationCode'] = ApiClient.convertToType(data['dpopJktForceForAuthorizationCode'], 'Boolean');
            }
            if (data.hasOwnProperty('allowIdTokenWithoutImplicitGrantType')) {
                obj['allowIdTokenWithoutImplicitGrantType'] = ApiClient.convertToType(data['allowIdTokenWithoutImplicitGrantType'], 'Boolean');
            }
            if (data.hasOwnProperty('forceRopcInAuthorizationEndpoint')) {
                obj['forceRopcInAuthorizationEndpoint'] = ApiClient.convertToType(data['forceRopcInAuthorizationEndpoint'], 'Boolean');
            }
            if (data.hasOwnProperty('discoveryCacheLifetimeInMinutes')) {
                obj['discoveryCacheLifetimeInMinutes'] = ApiClient.convertToType(data['discoveryCacheLifetimeInMinutes'], 'Number');
            }
            if (data.hasOwnProperty('discoveryAllowedKeys')) {
                obj['discoveryAllowedKeys'] = ApiClient.convertToType(data['discoveryAllowedKeys'], ['String']);
            }
            if (data.hasOwnProperty('discoveryDenyKeys')) {
                obj['discoveryDenyKeys'] = ApiClient.convertToType(data['discoveryDenyKeys'], ['String']);
            }
            if (data.hasOwnProperty('featureFlags')) {
                obj['featureFlags'] = ApiClient.convertToType(data['featureFlags'], ['String']);
            }
            if (data.hasOwnProperty('httpLoggingEnabled')) {
                obj['httpLoggingEnabled'] = ApiClient.convertToType(data['httpLoggingEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('httpLoggingExcludePaths')) {
                obj['httpLoggingExcludePaths'] = ApiClient.convertToType(data['httpLoggingExcludePaths'], ['String']);
            }
            if (data.hasOwnProperty('externalLoggerConfiguration')) {
                obj['externalLoggerConfiguration'] = ApiClient.convertToType(data['externalLoggerConfiguration'], 'String');
            }
            if (data.hasOwnProperty('agamaConfiguration')) {
                obj['agamaConfiguration'] = EngineConfig.constructFromObject(data['agamaConfiguration']);
            }
            if (data.hasOwnProperty('dcrSsaValidationConfigs')) {
                obj['dcrSsaValidationConfigs'] = ApiClient.convertToType(data['dcrSsaValidationConfigs'], [SsaValidationConfig]);
            }
            if (data.hasOwnProperty('ssaConfiguration')) {
                obj['ssaConfiguration'] = SsaConfiguration.constructFromObject(data['ssaConfiguration']);
            }
            if (data.hasOwnProperty('blockWebviewAuthorizationEnabled')) {
                obj['blockWebviewAuthorizationEnabled'] = ApiClient.convertToType(data['blockWebviewAuthorizationEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('authorizationChallengeDefaultAcr')) {
                obj['authorizationChallengeDefaultAcr'] = ApiClient.convertToType(data['authorizationChallengeDefaultAcr'], 'String');
            }
            if (data.hasOwnProperty('authorizationChallengeShouldGenerateSession')) {
                obj['authorizationChallengeShouldGenerateSession'] = ApiClient.convertToType(data['authorizationChallengeShouldGenerateSession'], 'Boolean');
            }
            if (data.hasOwnProperty('dateFormatterPatterns')) {
                obj['dateFormatterPatterns'] = ApiClient.convertToType(data['dateFormatterPatterns'], {'String': 'String'});
            }
            if (data.hasOwnProperty('httpLoggingResponseBodyContent')) {
                obj['httpLoggingResponseBodyContent'] = ApiClient.convertToType(data['httpLoggingResponseBodyContent'], 'Boolean');
            }
            if (data.hasOwnProperty('skipAuthenticationFilterOptionsMethod')) {
                obj['skipAuthenticationFilterOptionsMethod'] = ApiClient.convertToType(data['skipAuthenticationFilterOptionsMethod'], 'Boolean');
            }
            if (data.hasOwnProperty('lockMessageConfig')) {
                obj['lockMessageConfig'] = LockMessageConfig.constructFromObject(data['lockMessageConfig']);
            }
            if (data.hasOwnProperty('connectionServiceConfiguration')) {
                obj['connectionServiceConfiguration'] = ConnectionServiceConfiguration.constructFromObject(data['connectionServiceConfiguration']);
            }
            if (data.hasOwnProperty('fapi')) {
                obj['fapi'] = ApiClient.convertToType(data['fapi'], 'Boolean');
            }
            if (data.hasOwnProperty('allResponseTypesSupported')) {
                obj['allResponseTypesSupported'] = ApiClient.convertToType(data['allResponseTypesSupported'], ['String']);
            }
        }
        return obj;
    }


}

/**
 * @member {String} issuer
 */
AppConfiguration.prototype['issuer'] = undefined;

/**
 * @member {String} baseEndpoint
 */
AppConfiguration.prototype['baseEndpoint'] = undefined;

/**
 * @member {String} authorizationEndpoint
 */
AppConfiguration.prototype['authorizationEndpoint'] = undefined;

/**
 * @member {String} authorizationChallengeEndpoint
 */
AppConfiguration.prototype['authorizationChallengeEndpoint'] = undefined;

/**
 * @member {String} tokenEndpoint
 */
AppConfiguration.prototype['tokenEndpoint'] = undefined;

/**
 * @member {String} tokenRevocationEndpoint
 */
AppConfiguration.prototype['tokenRevocationEndpoint'] = undefined;

/**
 * @member {String} userInfoEndpoint
 */
AppConfiguration.prototype['userInfoEndpoint'] = undefined;

/**
 * @member {String} clientInfoEndpoint
 */
AppConfiguration.prototype['clientInfoEndpoint'] = undefined;

/**
 * @member {String} checkSessionIFrame
 */
AppConfiguration.prototype['checkSessionIFrame'] = undefined;

/**
 * @member {String} endSessionEndpoint
 */
AppConfiguration.prototype['endSessionEndpoint'] = undefined;

/**
 * @member {String} jwksUri
 */
AppConfiguration.prototype['jwksUri'] = undefined;

/**
 * @member {String} archivedJwksUri
 */
AppConfiguration.prototype['archivedJwksUri'] = undefined;

/**
 * @member {String} registrationEndpoint
 */
AppConfiguration.prototype['registrationEndpoint'] = undefined;

/**
 * @member {String} openIdDiscoveryEndpoint
 */
AppConfiguration.prototype['openIdDiscoveryEndpoint'] = undefined;

/**
 * @member {String} openIdConfigurationEndpoint
 */
AppConfiguration.prototype['openIdConfigurationEndpoint'] = undefined;

/**
 * @member {String} idGenerationEndpoint
 */
AppConfiguration.prototype['idGenerationEndpoint'] = undefined;

/**
 * @member {String} introspectionEndpoint
 */
AppConfiguration.prototype['introspectionEndpoint'] = undefined;

/**
 * @member {String} parEndpoint
 */
AppConfiguration.prototype['parEndpoint'] = undefined;

/**
 * @member {Boolean} allowClientAssertionAudWithoutStrictIssuerMatch
 */
AppConfiguration.prototype['allowClientAssertionAudWithoutStrictIssuerMatch'] = undefined;

/**
 * @member {Boolean} requirePar
 */
AppConfiguration.prototype['requirePar'] = undefined;

/**
 * @member {Boolean} parForbidPublicClient
 */
AppConfiguration.prototype['parForbidPublicClient'] = undefined;

/**
 * @member {String} deviceAuthzEndpoint
 */
AppConfiguration.prototype['deviceAuthzEndpoint'] = undefined;

/**
 * @member {String} mtlsAuthorizationEndpoint
 */
AppConfiguration.prototype['mtlsAuthorizationEndpoint'] = undefined;

/**
 * @member {String} mtlsAuthorizationChallengeEndpoint
 */
AppConfiguration.prototype['mtlsAuthorizationChallengeEndpoint'] = undefined;

/**
 * @member {String} mtlsTokenEndpoint
 */
AppConfiguration.prototype['mtlsTokenEndpoint'] = undefined;

/**
 * @member {String} mtlsTokenRevocationEndpoint
 */
AppConfiguration.prototype['mtlsTokenRevocationEndpoint'] = undefined;

/**
 * @member {String} mtlsUserInfoEndpoint
 */
AppConfiguration.prototype['mtlsUserInfoEndpoint'] = undefined;

/**
 * @member {String} mtlsClientInfoEndpoint
 */
AppConfiguration.prototype['mtlsClientInfoEndpoint'] = undefined;

/**
 * @member {String} mtlsCheckSessionIFrame
 */
AppConfiguration.prototype['mtlsCheckSessionIFrame'] = undefined;

/**
 * @member {String} mtlsEndSessionEndpoint
 */
AppConfiguration.prototype['mtlsEndSessionEndpoint'] = undefined;

/**
 * @member {String} mtlsJwksUri
 */
AppConfiguration.prototype['mtlsJwksUri'] = undefined;

/**
 * @member {String} mtlsRegistrationEndpoint
 */
AppConfiguration.prototype['mtlsRegistrationEndpoint'] = undefined;

/**
 * @member {String} mtlsIdGenerationEndpoint
 */
AppConfiguration.prototype['mtlsIdGenerationEndpoint'] = undefined;

/**
 * @member {String} mtlsIntrospectionEndpoint
 */
AppConfiguration.prototype['mtlsIntrospectionEndpoint'] = undefined;

/**
 * @member {String} mtlsParEndpoint
 */
AppConfiguration.prototype['mtlsParEndpoint'] = undefined;

/**
 * @member {String} mtlsDeviceAuthzEndpoint
 */
AppConfiguration.prototype['mtlsDeviceAuthzEndpoint'] = undefined;

/**
 * @member {Boolean} accessEvaluationAllowBasicClientAuthorization
 */
AppConfiguration.prototype['accessEvaluationAllowBasicClientAuthorization'] = undefined;

/**
 * @member {String} accessEvaluationScriptName
 */
AppConfiguration.prototype['accessEvaluationScriptName'] = undefined;

/**
 * @member {Number} accessEvaluationDiscoveryCacheLifetimeInMinutes
 */
AppConfiguration.prototype['accessEvaluationDiscoveryCacheLifetimeInMinutes'] = undefined;

/**
 * @member {Boolean} requireRequestObjectEncryption
 */
AppConfiguration.prototype['requireRequestObjectEncryption'] = undefined;

/**
 * @member {Boolean} requirePkce
 */
AppConfiguration.prototype['requirePkce'] = undefined;

/**
 * @member {Boolean} allowAllValueForRevokeEndpoint
 */
AppConfiguration.prototype['allowAllValueForRevokeEndpoint'] = undefined;

/**
 * @member {Boolean} allowRevokeForOtherClients
 */
AppConfiguration.prototype['allowRevokeForOtherClients'] = undefined;

/**
 * @member {Number} sectorIdentifierCacheLifetimeInMinutes
 */
AppConfiguration.prototype['sectorIdentifierCacheLifetimeInMinutes'] = undefined;

/**
 * @member {Number} archivedJwkLifetimeInSeconds
 */
AppConfiguration.prototype['archivedJwkLifetimeInSeconds'] = undefined;

/**
 * @member {Boolean} uppercaseResponseKeysInAccountAccessConsent
 */
AppConfiguration.prototype['uppercaseResponseKeysInAccountAccessConsent'] = undefined;

/**
 * @member {String} umaConfigurationEndpoint
 */
AppConfiguration.prototype['umaConfigurationEndpoint'] = undefined;

/**
 * @member {Boolean} umaRptAsJwt
 */
AppConfiguration.prototype['umaRptAsJwt'] = undefined;

/**
 * @member {Number} umaRptLifetime
 */
AppConfiguration.prototype['umaRptLifetime'] = undefined;

/**
 * @member {Number} umaTicketLifetime
 */
AppConfiguration.prototype['umaTicketLifetime'] = undefined;

/**
 * @member {Number} umaPctLifetime
 */
AppConfiguration.prototype['umaPctLifetime'] = undefined;

/**
 * @member {Number} umaResourceLifetime
 */
AppConfiguration.prototype['umaResourceLifetime'] = undefined;

/**
 * @member {Boolean} umaAddScopesAutomatically
 */
AppConfiguration.prototype['umaAddScopesAutomatically'] = undefined;

/**
 * @member {Boolean} umaValidateClaimToken
 */
AppConfiguration.prototype['umaValidateClaimToken'] = undefined;

/**
 * @member {Boolean} umaGrantAccessIfNoPolicies
 */
AppConfiguration.prototype['umaGrantAccessIfNoPolicies'] = undefined;

/**
 * @member {Boolean} umaRestrictResourceToAssociatedClient
 */
AppConfiguration.prototype['umaRestrictResourceToAssociatedClient'] = undefined;

/**
 * @member {Number} statTimerIntervalInSeconds
 */
AppConfiguration.prototype['statTimerIntervalInSeconds'] = undefined;

/**
 * @member {String} statAuthorizationScope
 */
AppConfiguration.prototype['statAuthorizationScope'] = undefined;

/**
 * @member {Boolean} allowSpontaneousScopes
 */
AppConfiguration.prototype['allowSpontaneousScopes'] = undefined;

/**
 * @member {Number} spontaneousScopeLifetime
 */
AppConfiguration.prototype['spontaneousScopeLifetime'] = undefined;

/**
 * @member {Number} statusListBitSize
 */
AppConfiguration.prototype['statusListBitSize'] = undefined;

/**
 * @member {String} statusListResponseJwtSignatureAlgorithm
 */
AppConfiguration.prototype['statusListResponseJwtSignatureAlgorithm'] = undefined;

/**
 * @member {Number} statusListResponseJwtLifetime
 */
AppConfiguration.prototype['statusListResponseJwtLifetime'] = undefined;

/**
 * @member {Number} statusListIndexAllocationBlockSize
 */
AppConfiguration.prototype['statusListIndexAllocationBlockSize'] = undefined;

/**
 * @member {String} openidSubAttribute
 */
AppConfiguration.prototype['openidSubAttribute'] = undefined;

/**
 * @member {Boolean} publicSubjectIdentifierPerClientEnabled
 */
AppConfiguration.prototype['publicSubjectIdentifierPerClientEnabled'] = undefined;

/**
 * @member {Array.<String>} subjectIdentifiersPerClientSupported
 */
AppConfiguration.prototype['subjectIdentifiersPerClientSupported'] = undefined;

/**
 * @member {Array.<String>} applyXFrameOptionsHeaderIfUriContainsAny
 */
AppConfiguration.prototype['applyXFrameOptionsHeaderIfUriContainsAny'] = undefined;

/**
 * @member {module:model/AppConfiguration.XframeOptionsHeaderValueEnum} xframeOptionsHeaderValue
 */
AppConfiguration.prototype['xframeOptionsHeaderValue'] = undefined;

/**
 * @member {Array.<Array.<module:model/AppConfiguration.ResponseTypesSupportedEnum>>} responseTypesSupported
 */
AppConfiguration.prototype['responseTypesSupported'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.ResponseModesSupportedEnum>} responseModesSupported
 */
AppConfiguration.prototype['responseModesSupported'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.GrantTypesSupportedEnum>} grantTypesSupported
 */
AppConfiguration.prototype['grantTypesSupported'] = undefined;

/**
 * @member {Array.<String>} subjectTypesSupported
 */
AppConfiguration.prototype['subjectTypesSupported'] = undefined;

/**
 * @member {String} defaultSubjectType
 */
AppConfiguration.prototype['defaultSubjectType'] = undefined;

/**
 * @member {Array.<String>} authorizationSigningAlgValuesSupported
 */
AppConfiguration.prototype['authorizationSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} authorizationEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['authorizationEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} authorizationEncryptionEncValuesSupported
 */
AppConfiguration.prototype['authorizationEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} userInfoSigningAlgValuesSupported
 */
AppConfiguration.prototype['userInfoSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} userInfoEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['userInfoEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} userInfoEncryptionEncValuesSupported
 */
AppConfiguration.prototype['userInfoEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} introspectionSigningAlgValuesSupported
 */
AppConfiguration.prototype['introspectionSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} introspectionEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['introspectionEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} introspectionEncryptionEncValuesSupported
 */
AppConfiguration.prototype['introspectionEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} logoutStatusJwtSigningAlgValuesSupported
 */
AppConfiguration.prototype['logoutStatusJwtSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} txTokenSigningAlgValuesSupported
 */
AppConfiguration.prototype['txTokenSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} txTokenEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['txTokenEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} txTokenEncryptionEncValuesSupported
 */
AppConfiguration.prototype['txTokenEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} idTokenSigningAlgValuesSupported
 */
AppConfiguration.prototype['idTokenSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} idTokenEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['idTokenEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} idTokenEncryptionEncValuesSupported
 */
AppConfiguration.prototype['idTokenEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} accessTokenSigningAlgValuesSupported
 */
AppConfiguration.prototype['accessTokenSigningAlgValuesSupported'] = undefined;

/**
 * @member {Boolean} forceSignedRequestObject
 */
AppConfiguration.prototype['forceSignedRequestObject'] = undefined;

/**
 * @member {Array.<String>} requestObjectSigningAlgValuesSupported
 */
AppConfiguration.prototype['requestObjectSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} requestObjectEncryptionAlgValuesSupported
 */
AppConfiguration.prototype['requestObjectEncryptionAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} requestObjectEncryptionEncValuesSupported
 */
AppConfiguration.prototype['requestObjectEncryptionEncValuesSupported'] = undefined;

/**
 * @member {Array.<String>} tokenEndpointAuthMethodsSupported
 */
AppConfiguration.prototype['tokenEndpointAuthMethodsSupported'] = undefined;

/**
 * @member {Array.<String>} tokenEndpointAuthSigningAlgValuesSupported
 */
AppConfiguration.prototype['tokenEndpointAuthSigningAlgValuesSupported'] = undefined;

/**
 * @member {Array.<String>} dynamicRegistrationCustomAttributes
 */
AppConfiguration.prototype['dynamicRegistrationCustomAttributes'] = undefined;

/**
 * @member {Object} dynamicRegistrationDefaultCustomAttributes
 */
AppConfiguration.prototype['dynamicRegistrationDefaultCustomAttributes'] = undefined;

/**
 * @member {Array.<String>} displayValuesSupported
 */
AppConfiguration.prototype['displayValuesSupported'] = undefined;

/**
 * @member {Array.<String>} claimTypesSupported
 */
AppConfiguration.prototype['claimTypesSupported'] = undefined;

/**
 * @member {Array.<String>} jwksAlgorithmsSupported
 */
AppConfiguration.prototype['jwksAlgorithmsSupported'] = undefined;

/**
 * @member {String} serviceDocumentation
 */
AppConfiguration.prototype['serviceDocumentation'] = undefined;

/**
 * @member {Array.<String>} claimsLocalesSupported
 */
AppConfiguration.prototype['claimsLocalesSupported'] = undefined;

/**
 * @member {Array.<String>} idTokenTokenBindingCnfValuesSupported
 */
AppConfiguration.prototype['idTokenTokenBindingCnfValuesSupported'] = undefined;

/**
 * @member {Array.<String>} uiLocalesSupported
 */
AppConfiguration.prototype['uiLocalesSupported'] = undefined;

/**
 * @member {Boolean} claimsParameterSupported
 */
AppConfiguration.prototype['claimsParameterSupported'] = undefined;

/**
 * @member {Boolean} requestParameterSupported
 */
AppConfiguration.prototype['requestParameterSupported'] = undefined;

/**
 * @member {Boolean} requestUriParameterSupported
 */
AppConfiguration.prototype['requestUriParameterSupported'] = undefined;

/**
 * @member {Boolean} requestUriHashVerificationEnabled
 */
AppConfiguration.prototype['requestUriHashVerificationEnabled'] = undefined;

/**
 * @member {Boolean} requireRequestUriRegistration
 */
AppConfiguration.prototype['requireRequestUriRegistration'] = undefined;

/**
 * @member {Array.<String>} requestUriBlockList
 */
AppConfiguration.prototype['requestUriBlockList'] = undefined;

/**
 * @member {String} opPolicyUri
 */
AppConfiguration.prototype['opPolicyUri'] = undefined;

/**
 * @member {String} opTosUri
 */
AppConfiguration.prototype['opTosUri'] = undefined;

/**
 * @member {Number} clientPeriodicUpdateTimerInterval
 */
AppConfiguration.prototype['clientPeriodicUpdateTimerInterval'] = undefined;

/**
 * @member {Number} authorizationCodeLifetime
 */
AppConfiguration.prototype['authorizationCodeLifetime'] = undefined;

/**
 * @member {Number} refreshTokenLifetime
 */
AppConfiguration.prototype['refreshTokenLifetime'] = undefined;

/**
 * @member {Number} txTokenLifetime
 */
AppConfiguration.prototype['txTokenLifetime'] = undefined;

/**
 * @member {Number} idTokenLifetime
 */
AppConfiguration.prototype['idTokenLifetime'] = undefined;

/**
 * @member {Boolean} idTokenFilterClaimsBasedOnAccessToken
 */
AppConfiguration.prototype['idTokenFilterClaimsBasedOnAccessToken'] = undefined;

/**
 * @member {Boolean} saveTokensInCache
 */
AppConfiguration.prototype['saveTokensInCache'] = undefined;

/**
 * @member {Boolean} saveTokensInCacheAndDontSaveInPersistence
 */
AppConfiguration.prototype['saveTokensInCacheAndDontSaveInPersistence'] = undefined;

/**
 * @member {Number} accessTokenLifetime
 */
AppConfiguration.prototype['accessTokenLifetime'] = undefined;

/**
 * @member {Number} userInfoLifetime
 */
AppConfiguration.prototype['userInfoLifetime'] = undefined;

/**
 * @member {Boolean} keyRegenerationEnabled
 */
AppConfiguration.prototype['keyRegenerationEnabled'] = undefined;

/**
 * @member {Number} keyRegenerationInterval
 */
AppConfiguration.prototype['keyRegenerationInterval'] = undefined;

/**
 * @member {String} defaultSignatureAlgorithm
 */
AppConfiguration.prototype['defaultSignatureAlgorithm'] = undefined;

/**
 * @member {String} jansOpenIdConnectVersion
 */
AppConfiguration.prototype['jansOpenIdConnectVersion'] = undefined;

/**
 * @member {String} jansId
 */
AppConfiguration.prototype['jansId'] = undefined;

/**
 * @member {Number} dynamicRegistrationExpirationTime
 */
AppConfiguration.prototype['dynamicRegistrationExpirationTime'] = undefined;

/**
 * @member {Boolean} dynamicRegistrationPersistClientAuthorizations
 */
AppConfiguration.prototype['dynamicRegistrationPersistClientAuthorizations'] = undefined;

/**
 * @member {Boolean} trustedClientEnabled
 */
AppConfiguration.prototype['trustedClientEnabled'] = undefined;

/**
 * @member {Boolean} skipAuthorizationForOpenIdScopeAndPairwiseId
 */
AppConfiguration.prototype['skipAuthorizationForOpenIdScopeAndPairwiseId'] = undefined;

/**
 * @member {Boolean} dynamicRegistrationScopesParamEnabled
 */
AppConfiguration.prototype['dynamicRegistrationScopesParamEnabled'] = undefined;

/**
 * @member {Boolean} dynamicRegistrationPasswordGrantTypeEnabled
 */
AppConfiguration.prototype['dynamicRegistrationPasswordGrantTypeEnabled'] = undefined;

/**
 * @member {Array.<String>} dynamicRegistrationAllowedPasswordGrantScopes
 */
AppConfiguration.prototype['dynamicRegistrationAllowedPasswordGrantScopes'] = undefined;

/**
 * @member {String} dynamicRegistrationCustomObjectClass
 */
AppConfiguration.prototype['dynamicRegistrationCustomObjectClass'] = undefined;

/**
 * @member {Array.<String>} personCustomObjectClassList
 */
AppConfiguration.prototype['personCustomObjectClassList'] = undefined;

/**
 * @member {Boolean} persistIdToken
 */
AppConfiguration.prototype['persistIdToken'] = undefined;

/**
 * @member {Boolean} persistRefreshToken
 */
AppConfiguration.prototype['persistRefreshToken'] = undefined;

/**
 * @member {Boolean} allowPostLogoutRedirectWithoutValidation
 */
AppConfiguration.prototype['allowPostLogoutRedirectWithoutValidation'] = undefined;

/**
 * @member {Boolean} invalidateSessionCookiesAfterAuthorizationFlow
 */
AppConfiguration.prototype['invalidateSessionCookiesAfterAuthorizationFlow'] = undefined;

/**
 * @member {Boolean} returnClientSecretOnRead
 */
AppConfiguration.prototype['returnClientSecretOnRead'] = undefined;

/**
 * @member {Boolean} rotateClientRegistrationAccessTokenOnUsage
 */
AppConfiguration.prototype['rotateClientRegistrationAccessTokenOnUsage'] = undefined;

/**
 * @member {Boolean} rejectJwtWithNoneAlg
 */
AppConfiguration.prototype['rejectJwtWithNoneAlg'] = undefined;

/**
 * @member {Boolean} expirationNotificatorEnabled
 */
AppConfiguration.prototype['expirationNotificatorEnabled'] = undefined;

/**
 * @member {Boolean} useNestedJwtDuringEncryption
 */
AppConfiguration.prototype['useNestedJwtDuringEncryption'] = undefined;

/**
 * @member {Number} expirationNotificatorMapSizeLimit
 */
AppConfiguration.prototype['expirationNotificatorMapSizeLimit'] = undefined;

/**
 * @member {Number} expirationNotificatorIntervalInSeconds
 */
AppConfiguration.prototype['expirationNotificatorIntervalInSeconds'] = undefined;

/**
 * @member {Boolean} redirectUrisRegexEnabled
 */
AppConfiguration.prototype['redirectUrisRegexEnabled'] = undefined;

/**
 * @member {Boolean} useHighestLevelScriptIfAcrScriptNotFound
 */
AppConfiguration.prototype['useHighestLevelScriptIfAcrScriptNotFound'] = undefined;

/**
 * @member {Object.<String, String>} acrMappings
 */
AppConfiguration.prototype['acrMappings'] = undefined;

/**
 * @member {Object.<String, String>} acrToConsentScriptNameMapping
 */
AppConfiguration.prototype['acrToConsentScriptNameMapping'] = undefined;

/**
 * @member {Object.<String, String>} acrToAgamaConsentFlowMapping
 */
AppConfiguration.prototype['acrToAgamaConsentFlowMapping'] = undefined;

/**
 * @member {Boolean} authenticationFiltersEnabled
 */
AppConfiguration.prototype['authenticationFiltersEnabled'] = undefined;

/**
 * @member {Boolean} clientAuthenticationFiltersEnabled
 */
AppConfiguration.prototype['clientAuthenticationFiltersEnabled'] = undefined;

/**
 * @member {Boolean} clientRegDefaultToCodeFlowWithRefresh
 */
AppConfiguration.prototype['clientRegDefaultToCodeFlowWithRefresh'] = undefined;

/**
 * @member {Boolean} grantTypesAndResponseTypesAutofixEnabled
 */
AppConfiguration.prototype['grantTypesAndResponseTypesAutofixEnabled'] = undefined;

/**
 * @member {Array.<module:model/AuthenticationFilter>} authenticationFilters
 */
AppConfiguration.prototype['authenticationFilters'] = undefined;

/**
 * @member {Array.<module:model/ClientAuthenticationFilter>} clientAuthenticationFilters
 */
AppConfiguration.prototype['clientAuthenticationFilters'] = undefined;

/**
 * @member {Array.<module:model/CorsConfigurationFilter>} corsConfigurationFilters
 */
AppConfiguration.prototype['corsConfigurationFilters'] = undefined;

/**
 * @member {Number} sessionIdUnusedLifetime
 */
AppConfiguration.prototype['sessionIdUnusedLifetime'] = undefined;

/**
 * @member {Number} sessionIdUnauthenticatedUnusedLifetime
 */
AppConfiguration.prototype['sessionIdUnauthenticatedUnusedLifetime'] = undefined;

/**
 * @member {Boolean} sessionIdPersistOnPromptNone
 */
AppConfiguration.prototype['sessionIdPersistOnPromptNone'] = undefined;

/**
 * @member {Boolean} sessionIdRequestParameterEnabled
 */
AppConfiguration.prototype['sessionIdRequestParameterEnabled'] = undefined;

/**
 * @member {Boolean} changeSessionIdOnAuthentication
 */
AppConfiguration.prototype['changeSessionIdOnAuthentication'] = undefined;

/**
 * @member {Boolean} sessionIdPersistInCache
 */
AppConfiguration.prototype['sessionIdPersistInCache'] = undefined;

/**
 * @member {Array.<String>} sessionIdUserClaimsInAttributes
 */
AppConfiguration.prototype['sessionIdUserClaimsInAttributes'] = undefined;

/**
 * @member {Boolean} includeSidInResponse
 */
AppConfiguration.prototype['includeSidInResponse'] = undefined;

/**
 * @member {Boolean} includeRefreshTokenLifetimeInTokenResponse
 */
AppConfiguration.prototype['includeRefreshTokenLifetimeInTokenResponse'] = undefined;

/**
 * @member {Boolean} disablePromptLogin
 */
AppConfiguration.prototype['disablePromptLogin'] = undefined;

/**
 * @member {Boolean} disablePromptConsent
 */
AppConfiguration.prototype['disablePromptConsent'] = undefined;

/**
 * @member {Number} logoutStatusJwtLifetime
 */
AppConfiguration.prototype['logoutStatusJwtLifetime'] = undefined;

/**
 * @member {Number} sessionIdCookieLifetime
 */
AppConfiguration.prototype['sessionIdCookieLifetime'] = undefined;

/**
 * @member {Number} sessionIdLifetime
 */
AppConfiguration.prototype['sessionIdLifetime'] = undefined;

/**
 * @member {String} activeSessionAuthorizationScope
 */
AppConfiguration.prototype['activeSessionAuthorizationScope'] = undefined;

/**
 * @member {Number} configurationUpdateInterval
 */
AppConfiguration.prototype['configurationUpdateInterval'] = undefined;

/**
 * @member {Boolean} logNotFoundEntityAsError
 */
AppConfiguration.prototype['logNotFoundEntityAsError'] = undefined;

/**
 * @member {Boolean} enableClientGrantTypeUpdate
 */
AppConfiguration.prototype['enableClientGrantTypeUpdate'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.GrantTypesSupportedByDynamicRegistrationEnum>} grantTypesSupportedByDynamicRegistration
 */
AppConfiguration.prototype['grantTypesSupportedByDynamicRegistration'] = undefined;

/**
 * @member {String} cssLocation
 */
AppConfiguration.prototype['cssLocation'] = undefined;

/**
 * @member {String} jsLocation
 */
AppConfiguration.prototype['jsLocation'] = undefined;

/**
 * @member {String} imgLocation
 */
AppConfiguration.prototype['imgLocation'] = undefined;

/**
 * @member {Number} metricReporterInterval
 */
AppConfiguration.prototype['metricReporterInterval'] = undefined;

/**
 * @member {Number} metricReporterKeepDataDays
 */
AppConfiguration.prototype['metricReporterKeepDataDays'] = undefined;

/**
 * @member {String} pairwiseIdType
 */
AppConfiguration.prototype['pairwiseIdType'] = undefined;

/**
 * @member {String} pairwiseCalculationKey
 */
AppConfiguration.prototype['pairwiseCalculationKey'] = undefined;

/**
 * @member {String} pairwiseCalculationSalt
 */
AppConfiguration.prototype['pairwiseCalculationSalt'] = undefined;

/**
 * @member {Boolean} shareSubjectIdBetweenClientsWithSameSectorId
 */
AppConfiguration.prototype['shareSubjectIdBetweenClientsWithSameSectorId'] = undefined;

/**
 * @member {Boolean} useOpenidSubAttributeValueForPairwiseLocalAccountId
 */
AppConfiguration.prototype['useOpenidSubAttributeValueForPairwiseLocalAccountId'] = undefined;

/**
 * @member {module:model/AppConfiguration.WebKeysStorageEnum} webKeysStorage
 */
AppConfiguration.prototype['webKeysStorage'] = undefined;

/**
 * @member {String} dnName
 */
AppConfiguration.prototype['dnName'] = undefined;

/**
 * @member {String} keyStoreFile
 */
AppConfiguration.prototype['keyStoreFile'] = undefined;

/**
 * @member {String} keyStoreSecret
 */
AppConfiguration.prototype['keyStoreSecret'] = undefined;

/**
 * @member {module:model/AppConfiguration.KeySelectionStrategyEnum} keySelectionStrategy
 */
AppConfiguration.prototype['keySelectionStrategy'] = undefined;

/**
 * @member {Array.<String>} keyAlgsAllowedForGeneration
 */
AppConfiguration.prototype['keyAlgsAllowedForGeneration'] = undefined;

/**
 * @member {Boolean} keySignWithSameKeyButDiffAlg
 */
AppConfiguration.prototype['keySignWithSameKeyButDiffAlg'] = undefined;

/**
 * @member {String} staticKid
 */
AppConfiguration.prototype['staticKid'] = undefined;

/**
 * @member {String} staticDecryptionKid
 */
AppConfiguration.prototype['staticDecryptionKid'] = undefined;

/**
 * @member {Boolean} introspectionAccessTokenMustHaveUmaProtectionScope
 */
AppConfiguration.prototype['introspectionAccessTokenMustHaveUmaProtectionScope'] = undefined;

/**
 * @member {Boolean} introspectionAccessTokenMustHaveIntrospectionScope
 */
AppConfiguration.prototype['introspectionAccessTokenMustHaveIntrospectionScope'] = undefined;

/**
 * @member {Boolean} introspectionSkipAuthorization
 */
AppConfiguration.prototype['introspectionSkipAuthorization'] = undefined;

/**
 * @member {Boolean} introspectionRestrictBasicAuthnToOwnTokens
 */
AppConfiguration.prototype['introspectionRestrictBasicAuthnToOwnTokens'] = undefined;

/**
 * @member {Boolean} endSessionWithAccessToken
 */
AppConfiguration.prototype['endSessionWithAccessToken'] = undefined;

/**
 * @member {Boolean} disablePromptCreate
 */
AppConfiguration.prototype['disablePromptCreate'] = undefined;

/**
 * @member {String} cookieDomain
 */
AppConfiguration.prototype['cookieDomain'] = undefined;

/**
 * @member {Boolean} enabledOAuthAuditLogging
 */
AppConfiguration.prototype['enabledOAuthAuditLogging'] = undefined;

/**
 * @member {Array.<String>} jmsBrokerURISet
 */
AppConfiguration.prototype['jmsBrokerURISet'] = undefined;

/**
 * @member {String} jmsUserName
 */
AppConfiguration.prototype['jmsUserName'] = undefined;

/**
 * @member {String} jmsPassword
 */
AppConfiguration.prototype['jmsPassword'] = undefined;

/**
 * @member {Array.<String>} externalUriWhiteList
 */
AppConfiguration.prototype['externalUriWhiteList'] = undefined;

/**
 * @member {Array.<String>} clientWhiteList
 */
AppConfiguration.prototype['clientWhiteList'] = undefined;

/**
 * @member {Array.<String>} clientBlackList
 */
AppConfiguration.prototype['clientBlackList'] = undefined;

/**
 * @member {Boolean} legacyIdTokenClaims
 */
AppConfiguration.prototype['legacyIdTokenClaims'] = undefined;

/**
 * @member {Boolean} customHeadersWithAuthorizationResponse
 */
AppConfiguration.prototype['customHeadersWithAuthorizationResponse'] = undefined;

/**
 * @member {Boolean} frontChannelLogoutSessionSupported
 */
AppConfiguration.prototype['frontChannelLogoutSessionSupported'] = undefined;

/**
 * @member {String} loggingLevel
 */
AppConfiguration.prototype['loggingLevel'] = undefined;

/**
 * @member {String} loggingLayout
 */
AppConfiguration.prototype['loggingLayout'] = undefined;

/**
 * @member {Boolean} updateUserLastLogonTime
 */
AppConfiguration.prototype['updateUserLastLogonTime'] = undefined;

/**
 * @member {Boolean} updateClientAccessTime
 */
AppConfiguration.prototype['updateClientAccessTime'] = undefined;

/**
 * @member {Boolean} logClientIdOnClientAuthentication
 */
AppConfiguration.prototype['logClientIdOnClientAuthentication'] = undefined;

/**
 * @member {Boolean} logClientNameOnClientAuthentication
 */
AppConfiguration.prototype['logClientNameOnClientAuthentication'] = undefined;

/**
 * @member {Boolean} disableJdkLogger
 */
AppConfiguration.prototype['disableJdkLogger'] = undefined;

/**
 * @member {Array.<module:model/AuthorizationRequestCustomParameter>} authorizationRequestCustomAllowedParameters
 */
AppConfiguration.prototype['authorizationRequestCustomAllowedParameters'] = undefined;

/**
 * @member {Boolean} openidScopeBackwardCompatibility
 */
AppConfiguration.prototype['openidScopeBackwardCompatibility'] = undefined;

/**
 * @member {Boolean} disableU2fEndpoint
 */
AppConfiguration.prototype['disableU2fEndpoint'] = undefined;

/**
 * @member {Number} authorizationChallengeSessionLifetimeInSeconds
 */
AppConfiguration.prototype['authorizationChallengeSessionLifetimeInSeconds'] = undefined;

/**
 * @member {Number} rateLimitRegistrationRequestCount
 */
AppConfiguration.prototype['rateLimitRegistrationRequestCount'] = undefined;

/**
 * @member {Number} rateLimitRegistrationPeriodInSeconds
 */
AppConfiguration.prototype['rateLimitRegistrationPeriodInSeconds'] = undefined;

/**
 * @member {Boolean} rotateDeviceSecret
 */
AppConfiguration.prototype['rotateDeviceSecret'] = undefined;

/**
 * @member {Boolean} returnDeviceSecretFromAuthzEndpoint
 */
AppConfiguration.prototype['returnDeviceSecretFromAuthzEndpoint'] = undefined;

/**
 * @member {Boolean} dcrForbidExpirationTimeInRequest
 */
AppConfiguration.prototype['dcrForbidExpirationTimeInRequest'] = undefined;

/**
 * @member {Boolean} dcrSignatureValidationEnabled
 */
AppConfiguration.prototype['dcrSignatureValidationEnabled'] = undefined;

/**
 * @member {String} dcrSignatureValidationSharedSecret
 */
AppConfiguration.prototype['dcrSignatureValidationSharedSecret'] = undefined;

/**
 * @member {String} dcrSignatureValidationSoftwareStatementJwksURIClaim
 */
AppConfiguration.prototype['dcrSignatureValidationSoftwareStatementJwksURIClaim'] = undefined;

/**
 * @member {String} dcrSignatureValidationSoftwareStatementJwksClaim
 */
AppConfiguration.prototype['dcrSignatureValidationSoftwareStatementJwksClaim'] = undefined;

/**
 * @member {String} dcrSignatureValidationJwks
 */
AppConfiguration.prototype['dcrSignatureValidationJwks'] = undefined;

/**
 * @member {String} dcrSignatureValidationJwksUri
 */
AppConfiguration.prototype['dcrSignatureValidationJwksUri'] = undefined;

/**
 * @member {Boolean} dcrAuthorizationWithClientCredentials
 */
AppConfiguration.prototype['dcrAuthorizationWithClientCredentials'] = undefined;

/**
 * @member {Boolean} dcrAuthorizationWithMTLS
 */
AppConfiguration.prototype['dcrAuthorizationWithMTLS'] = undefined;

/**
 * @member {Boolean} dcrAttestationEvidenceRequired
 */
AppConfiguration.prototype['dcrAttestationEvidenceRequired'] = undefined;

/**
 * @member {Object.<String, module:model/TrustedIssuerConfig>} trustedSsaIssuers
 */
AppConfiguration.prototype['trustedSsaIssuers'] = undefined;

/**
 * @member {Boolean} useLocalCache
 */
AppConfiguration.prototype['useLocalCache'] = undefined;

/**
 * @member {Boolean} fapiCompatibility
 */
AppConfiguration.prototype['fapiCompatibility'] = undefined;

/**
 * @member {Boolean} forceIdTokenHintPresence
 */
AppConfiguration.prototype['forceIdTokenHintPresence'] = undefined;

/**
 * @member {Boolean} rejectEndSessionIfIdTokenExpired
 */
AppConfiguration.prototype['rejectEndSessionIfIdTokenExpired'] = undefined;

/**
 * @member {Boolean} allowEndSessionWithUnmatchedSid
 */
AppConfiguration.prototype['allowEndSessionWithUnmatchedSid'] = undefined;

/**
 * @member {Boolean} forceOfflineAccessScopeToEnableRefreshToken
 */
AppConfiguration.prototype['forceOfflineAccessScopeToEnableRefreshToken'] = undefined;

/**
 * @member {Boolean} errorReasonEnabled
 */
AppConfiguration.prototype['errorReasonEnabled'] = undefined;

/**
 * @member {Boolean} removeRefreshTokensForClientOnLogout
 */
AppConfiguration.prototype['removeRefreshTokensForClientOnLogout'] = undefined;

/**
 * @member {Boolean} skipRefreshTokenDuringRefreshing
 */
AppConfiguration.prototype['skipRefreshTokenDuringRefreshing'] = undefined;

/**
 * @member {Boolean} refreshTokenExtendLifetimeOnRotation
 */
AppConfiguration.prototype['refreshTokenExtendLifetimeOnRotation'] = undefined;

/**
 * @member {Boolean} allowBlankValuesInDiscoveryResponse
 */
AppConfiguration.prototype['allowBlankValuesInDiscoveryResponse'] = undefined;

/**
 * @member {Boolean} checkUserPresenceOnRefreshToken
 */
AppConfiguration.prototype['checkUserPresenceOnRefreshToken'] = undefined;

/**
 * @member {Boolean} consentGatheringScriptBackwardCompatibility
 */
AppConfiguration.prototype['consentGatheringScriptBackwardCompatibility'] = undefined;

/**
 * @member {Boolean} introspectionScriptBackwardCompatibility
 */
AppConfiguration.prototype['introspectionScriptBackwardCompatibility'] = undefined;

/**
 * @member {Boolean} introspectionResponseScopesBackwardCompatibility
 */
AppConfiguration.prototype['introspectionResponseScopesBackwardCompatibility'] = undefined;

/**
 * @member {String} softwareStatementValidationType
 */
AppConfiguration.prototype['softwareStatementValidationType'] = undefined;

/**
 * @member {String} softwareStatementValidationClaimName
 */
AppConfiguration.prototype['softwareStatementValidationClaimName'] = undefined;

/**
 * @member {module:model/AuthenticationProtectionConfiguration} authenticationProtectionConfiguration
 */
AppConfiguration.prototype['authenticationProtectionConfiguration'] = undefined;

/**
 * @member {module:model/AppConfiguration.ErrorHandlingMethodEnum} errorHandlingMethod
 */
AppConfiguration.prototype['errorHandlingMethod'] = undefined;

/**
 * @member {Boolean} disableAuthnForMaxAgeZero
 */
AppConfiguration.prototype['disableAuthnForMaxAgeZero'] = undefined;

/**
 * @member {Boolean} keepAuthenticatorAttributesOnAcrChange
 */
AppConfiguration.prototype['keepAuthenticatorAttributesOnAcrChange'] = undefined;

/**
 * @member {Number} deviceAuthzRequestExpiresIn
 */
AppConfiguration.prototype['deviceAuthzRequestExpiresIn'] = undefined;

/**
 * @member {Number} deviceAuthzTokenPollInterval
 */
AppConfiguration.prototype['deviceAuthzTokenPollInterval'] = undefined;

/**
 * @member {String} deviceAuthzResponseTypeToProcessAuthz
 */
AppConfiguration.prototype['deviceAuthzResponseTypeToProcessAuthz'] = undefined;

/**
 * @member {String} deviceAuthzAcr
 */
AppConfiguration.prototype['deviceAuthzAcr'] = undefined;

/**
 * @member {String} backchannelClientId
 */
AppConfiguration.prototype['backchannelClientId'] = undefined;

/**
 * @member {String} backchannelRedirectUri
 */
AppConfiguration.prototype['backchannelRedirectUri'] = undefined;

/**
 * @member {String} backchannelAuthenticationEndpoint
 */
AppConfiguration.prototype['backchannelAuthenticationEndpoint'] = undefined;

/**
 * @member {String} backchannelDeviceRegistrationEndpoint
 */
AppConfiguration.prototype['backchannelDeviceRegistrationEndpoint'] = undefined;

/**
 * @member {Array.<String>} backchannelTokenDeliveryModesSupported
 */
AppConfiguration.prototype['backchannelTokenDeliveryModesSupported'] = undefined;

/**
 * @member {Array.<String>} backchannelAuthenticationRequestSigningAlgValuesSupported
 */
AppConfiguration.prototype['backchannelAuthenticationRequestSigningAlgValuesSupported'] = undefined;

/**
 * @member {Boolean} backchannelUserCodeParameterSupported
 */
AppConfiguration.prototype['backchannelUserCodeParameterSupported'] = undefined;

/**
 * @member {String} backchannelBindingMessagePattern
 */
AppConfiguration.prototype['backchannelBindingMessagePattern'] = undefined;

/**
 * @member {Number} backchannelAuthenticationResponseExpiresIn
 */
AppConfiguration.prototype['backchannelAuthenticationResponseExpiresIn'] = undefined;

/**
 * @member {Number} backchannelAuthenticationResponseInterval
 */
AppConfiguration.prototype['backchannelAuthenticationResponseInterval'] = undefined;

/**
 * @member {Array.<String>} backchannelLoginHintClaims
 */
AppConfiguration.prototype['backchannelLoginHintClaims'] = undefined;

/**
 * @member {module:model/CIBAEndUserNotificationConfig} cibaEndUserNotificationConfig
 */
AppConfiguration.prototype['cibaEndUserNotificationConfig'] = undefined;

/**
 * @member {Number} backchannelRequestsProcessorJobIntervalSec
 */
AppConfiguration.prototype['backchannelRequestsProcessorJobIntervalSec'] = undefined;

/**
 * @member {Number} backchannelRequestsProcessorJobChunkSize
 */
AppConfiguration.prototype['backchannelRequestsProcessorJobChunkSize'] = undefined;

/**
 * @member {Number} cibaGrantLifeExtraTimeSec
 */
AppConfiguration.prototype['cibaGrantLifeExtraTimeSec'] = undefined;

/**
 * @member {Number} cibaMaxExpirationTimeAllowedSec
 */
AppConfiguration.prototype['cibaMaxExpirationTimeAllowedSec'] = undefined;

/**
 * @member {Array.<String>} dpopSigningAlgValuesSupported
 */
AppConfiguration.prototype['dpopSigningAlgValuesSupported'] = undefined;

/**
 * @member {Number} dpopTimeframe
 */
AppConfiguration.prototype['dpopTimeframe'] = undefined;

/**
 * @member {Number} dpopJtiCacheTime
 */
AppConfiguration.prototype['dpopJtiCacheTime'] = undefined;

/**
 * @member {Boolean} dpopUseNonce
 */
AppConfiguration.prototype['dpopUseNonce'] = undefined;

/**
 * @member {Number} dpopNonceCacheTime
 */
AppConfiguration.prototype['dpopNonceCacheTime'] = undefined;

/**
 * @member {Boolean} dpopJktForceForAuthorizationCode
 */
AppConfiguration.prototype['dpopJktForceForAuthorizationCode'] = undefined;

/**
 * @member {Boolean} allowIdTokenWithoutImplicitGrantType
 */
AppConfiguration.prototype['allowIdTokenWithoutImplicitGrantType'] = undefined;

/**
 * @member {Boolean} forceRopcInAuthorizationEndpoint
 */
AppConfiguration.prototype['forceRopcInAuthorizationEndpoint'] = undefined;

/**
 * @member {Number} discoveryCacheLifetimeInMinutes
 */
AppConfiguration.prototype['discoveryCacheLifetimeInMinutes'] = undefined;

/**
 * @member {Array.<String>} discoveryAllowedKeys
 */
AppConfiguration.prototype['discoveryAllowedKeys'] = undefined;

/**
 * @member {Array.<String>} discoveryDenyKeys
 */
AppConfiguration.prototype['discoveryDenyKeys'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.FeatureFlagsEnum>} featureFlags
 */
AppConfiguration.prototype['featureFlags'] = undefined;

/**
 * @member {Boolean} httpLoggingEnabled
 */
AppConfiguration.prototype['httpLoggingEnabled'] = undefined;

/**
 * @member {Array.<String>} httpLoggingExcludePaths
 */
AppConfiguration.prototype['httpLoggingExcludePaths'] = undefined;

/**
 * @member {String} externalLoggerConfiguration
 */
AppConfiguration.prototype['externalLoggerConfiguration'] = undefined;

/**
 * @member {module:model/EngineConfig} agamaConfiguration
 */
AppConfiguration.prototype['agamaConfiguration'] = undefined;

/**
 * @member {Array.<module:model/SsaValidationConfig>} dcrSsaValidationConfigs
 */
AppConfiguration.prototype['dcrSsaValidationConfigs'] = undefined;

/**
 * @member {module:model/SsaConfiguration} ssaConfiguration
 */
AppConfiguration.prototype['ssaConfiguration'] = undefined;

/**
 * @member {Boolean} blockWebviewAuthorizationEnabled
 */
AppConfiguration.prototype['blockWebviewAuthorizationEnabled'] = undefined;

/**
 * @member {String} authorizationChallengeDefaultAcr
 */
AppConfiguration.prototype['authorizationChallengeDefaultAcr'] = undefined;

/**
 * @member {Boolean} authorizationChallengeShouldGenerateSession
 */
AppConfiguration.prototype['authorizationChallengeShouldGenerateSession'] = undefined;

/**
 * @member {Object.<String, String>} dateFormatterPatterns
 */
AppConfiguration.prototype['dateFormatterPatterns'] = undefined;

/**
 * @member {Boolean} httpLoggingResponseBodyContent
 */
AppConfiguration.prototype['httpLoggingResponseBodyContent'] = undefined;

/**
 * @member {Boolean} skipAuthenticationFilterOptionsMethod
 */
AppConfiguration.prototype['skipAuthenticationFilterOptionsMethod'] = undefined;

/**
 * @member {module:model/LockMessageConfig} lockMessageConfig
 */
AppConfiguration.prototype['lockMessageConfig'] = undefined;

/**
 * @member {module:model/ConnectionServiceConfiguration} connectionServiceConfiguration
 */
AppConfiguration.prototype['connectionServiceConfiguration'] = undefined;

/**
 * @member {Boolean} fapi
 */
AppConfiguration.prototype['fapi'] = undefined;

/**
 * @member {Array.<module:model/AppConfiguration.AllResponseTypesSupportedEnum>} allResponseTypesSupported
 */
AppConfiguration.prototype['allResponseTypesSupported'] = undefined;





/**
 * Allowed values for the <code>xframeOptionsHeaderValue</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['XframeOptionsHeaderValueEnum'] = {

    /**
     * value: "SAMEORIGIN"
     * @const
     */
    "SAMEORIGIN": "SAMEORIGIN",

    /**
     * value: "DENY"
     * @const
     */
    "DENY": "DENY"
};


/**
 * Allowed values for the <code>responseModesSupported</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['ResponseModesSupportedEnum'] = {

    /**
     * value: "query"
     * @const
     */
    "query": "query",

    /**
     * value: "fragment"
     * @const
     */
    "fragment": "fragment",

    /**
     * value: "form_post"
     * @const
     */
    "form_post": "form_post",

    /**
     * value: "query.jwt"
     * @const
     */
    "query.jwt": "query.jwt",

    /**
     * value: "fragment.jwt"
     * @const
     */
    "fragment.jwt": "fragment.jwt",

    /**
     * value: "form_post.jwt"
     * @const
     */
    "form_post.jwt": "form_post.jwt",

    /**
     * value: "jwt"
     * @const
     */
    "jwt": "jwt"
};


/**
 * Allowed values for the <code>grantTypesSupported</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['GrantTypesSupportedEnum'] = {

    /**
     * value: "none"
     * @const
     */
    "none": "none",

    /**
     * value: "authorization_code"
     * @const
     */
    "authorization_code": "authorization_code",

    /**
     * value: "implicit"
     * @const
     */
    "implicit": "implicit",

    /**
     * value: "password"
     * @const
     */
    "password": "password",

    /**
     * value: "client_credentials"
     * @const
     */
    "client_credentials": "client_credentials",

    /**
     * value: "refresh_token"
     * @const
     */
    "refresh_token": "refresh_token",

    /**
     * value: "urn:ietf:params:oauth:grant-type:uma-ticket"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:uma-ticket": "urn:ietf:params:oauth:grant-type:uma-ticket",

    /**
     * value: "urn:ietf:params:oauth:grant-type:token-exchange"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:token-exchange": "urn:ietf:params:oauth:grant-type:token-exchange",

    /**
     * value: "urn:openid:params:grant-type:ciba"
     * @const
     */
    "urn:openid:params:grant-type:ciba": "urn:openid:params:grant-type:ciba",

    /**
     * value: "urn:ietf:params:oauth:grant-type:device_code"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:device_code": "urn:ietf:params:oauth:grant-type:device_code"
};


/**
 * Allowed values for the <code>grantTypesSupportedByDynamicRegistration</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['GrantTypesSupportedByDynamicRegistrationEnum'] = {

    /**
     * value: "none"
     * @const
     */
    "none": "none",

    /**
     * value: "authorization_code"
     * @const
     */
    "authorization_code": "authorization_code",

    /**
     * value: "implicit"
     * @const
     */
    "implicit": "implicit",

    /**
     * value: "password"
     * @const
     */
    "password": "password",

    /**
     * value: "client_credentials"
     * @const
     */
    "client_credentials": "client_credentials",

    /**
     * value: "refresh_token"
     * @const
     */
    "refresh_token": "refresh_token",

    /**
     * value: "urn:ietf:params:oauth:grant-type:uma-ticket"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:uma-ticket": "urn:ietf:params:oauth:grant-type:uma-ticket",

    /**
     * value: "urn:ietf:params:oauth:grant-type:token-exchange"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:token-exchange": "urn:ietf:params:oauth:grant-type:token-exchange",

    /**
     * value: "urn:openid:params:grant-type:ciba"
     * @const
     */
    "urn:openid:params:grant-type:ciba": "urn:openid:params:grant-type:ciba",

    /**
     * value: "urn:ietf:params:oauth:grant-type:device_code"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:device_code": "urn:ietf:params:oauth:grant-type:device_code"
};


/**
 * Allowed values for the <code>webKeysStorage</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['WebKeysStorageEnum'] = {

    /**
     * value: "keystore"
     * @const
     */
    "keystore": "keystore",

    /**
     * value: "pkcs11"
     * @const
     */
    "pkcs11": "pkcs11"
};


/**
 * Allowed values for the <code>keySelectionStrategy</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['KeySelectionStrategyEnum'] = {

    /**
     * value: "OLDER"
     * @const
     */
    "OLDER": "OLDER",

    /**
     * value: "NEWER"
     * @const
     */
    "NEWER": "NEWER",

    /**
     * value: "FIRST"
     * @const
     */
    "FIRST": "FIRST"
};


/**
 * Allowed values for the <code>errorHandlingMethod</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['ErrorHandlingMethodEnum'] = {

    /**
     * value: "internal"
     * @const
     */
    "internal": "internal",

    /**
     * value: "remote"
     * @const
     */
    "remote": "remote"
};


/**
 * Allowed values for the <code>featureFlags</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['FeatureFlagsEnum'] = {

    /**
     * value: "UNKNOWN"
     * @const
     */
    "UNKNOWN": "UNKNOWN",

    /**
     * value: "HEALTH_CHECK"
     * @const
     */
    "HEALTH_CHECK": "HEALTH_CHECK",

    /**
     * value: "USERINFO"
     * @const
     */
    "USERINFO": "USERINFO",

    /**
     * value: "CLIENTINFO"
     * @const
     */
    "CLIENTINFO": "CLIENTINFO",

    /**
     * value: "ID_GENERATION"
     * @const
     */
    "ID_GENERATION": "ID_GENERATION",

    /**
     * value: "REGISTRATION"
     * @const
     */
    "REGISTRATION": "REGISTRATION",

    /**
     * value: "INTROSPECTION"
     * @const
     */
    "INTROSPECTION": "INTROSPECTION",

    /**
     * value: "REVOKE_TOKEN"
     * @const
     */
    "REVOKE_TOKEN": "REVOKE_TOKEN",

    /**
     * value: "REVOKE_SESSION"
     * @const
     */
    "REVOKE_SESSION": "REVOKE_SESSION",

    /**
     * value: "GLOBAL_TOKEN_REVOCATION"
     * @const
     */
    "GLOBAL_TOKEN_REVOCATION": "GLOBAL_TOKEN_REVOCATION",

    /**
     * value: "STATUS_LIST"
     * @const
     */
    "STATUS_LIST": "STATUS_LIST",

    /**
     * value: "LOGOUT_STATUS_JWT"
     * @const
     */
    "LOGOUT_STATUS_JWT": "LOGOUT_STATUS_JWT",

    /**
     * value: "ACTIVE_SESSION"
     * @const
     */
    "ACTIVE_SESSION": "ACTIVE_SESSION",

    /**
     * value: "END_SESSION"
     * @const
     */
    "END_SESSION": "END_SESSION",

    /**
     * value: "STATUS_SESSION"
     * @const
     */
    "STATUS_SESSION": "STATUS_SESSION",

    /**
     * value: "JANS_CONFIGURATION"
     * @const
     */
    "JANS_CONFIGURATION": "JANS_CONFIGURATION",

    /**
     * value: "CIBA"
     * @const
     */
    "CIBA": "CIBA",

    /**
     * value: "UMA"
     * @const
     */
    "UMA": "UMA",

    /**
     * value: "U2F"
     * @const
     */
    "U2F": "U2F",

    /**
     * value: "DEVICE_AUTHZ"
     * @const
     */
    "DEVICE_AUTHZ": "DEVICE_AUTHZ",

    /**
     * value: "METRIC"
     * @const
     */
    "METRIC": "METRIC",

    /**
     * value: "STAT"
     * @const
     */
    "STAT": "STAT",

    /**
     * value: "PAR"
     * @const
     */
    "PAR": "PAR",

    /**
     * value: "ACCESS_EVALUATION"
     * @const
     */
    "ACCESS_EVALUATION": "ACCESS_EVALUATION",

    /**
     * value: "RATE_LIMIT"
     * @const
     */
    "RATE_LIMIT": "RATE_LIMIT",

    /**
     * value: "SSA"
     * @const
     */
    "SSA": "SSA"
};


/**
 * Allowed values for the <code>allResponseTypesSupported</code> property.
 * @enum {String}
 * @readonly
 */
AppConfiguration['AllResponseTypesSupportedEnum'] = {

    /**
     * value: "code"
     * @const
     */
    "code": "code",

    /**
     * value: "token"
     * @const
     */
    "token": "token",

    /**
     * value: "id_token"
     * @const
     */
    "id_token": "id_token"
};



export default AppConfiguration;

