/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import ClientAuth from '../model/ClientAuth';

/**
* ClientAuthorization service.
* @module api/ClientAuthorizationApi
* @version OAS Version
*/
export default class ClientAuthorizationApi {

    /**
    * Constructs a new ClientAuthorizationApi. 
    * @alias module:api/ClientAuthorizationApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteClientAuthorization operation.
     * @callback module:api/ClientAuthorizationApi~deleteClientAuthorizationCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Revoke client authorization
     * Revoke client authorizations
     * @param {String} userId User identifier
     * @param {String} clientId Client identifier
     * @param {String} username User name
     * @param {module:api/ClientAuthorizationApi~deleteClientAuthorizationCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteClientAuthorization(userId, clientId, username, callback) {
      let postBody = null;
      // verify the required parameter 'userId' is set
      if (userId === undefined || userId === null) {
        throw new Error("Missing the required parameter 'userId' when calling deleteClientAuthorization");
      }
      // verify the required parameter 'clientId' is set
      if (clientId === undefined || clientId === null) {
        throw new Error("Missing the required parameter 'clientId' when calling deleteClientAuthorization");
      }
      // verify the required parameter 'username' is set
      if (username === undefined || username === null) {
        throw new Error("Missing the required parameter 'username' when calling deleteClientAuthorization");
      }

      let pathParams = {
        'userId': userId,
        'clientId': clientId,
        'username': username
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/clients/authorizations/{userId}/{clientId}/{username}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getClientAuthorization operation.
     * @callback module:api/ClientAuthorizationApi~getClientAuthorizationCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ClientAuth} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of client authorization
     * Gets list of client authorizations
     * @param {String} userId User identifier
     * @param {module:api/ClientAuthorizationApi~getClientAuthorizationCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ClientAuth}
     */
    getClientAuthorization(userId, callback) {
      let postBody = null;
      // verify the required parameter 'userId' is set
      if (userId === undefined || userId === null) {
        throw new Error("Missing the required parameter 'userId' when calling getClientAuthorization");
      }

      let pathParams = {
        'userId': userId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ClientAuth;
      return this.apiClient.callApi(
        '/api/v1/clients/authorizations/{userId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
