# JansConfigApi.SCIMConfigManagementApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getScimConfig**](SCIMConfigManagementApi.md#getScimConfig) | **GET** /scim/scim-config | Retrieves SCIM App configuration
[**patchScimConfig**](SCIMConfigManagementApi.md#patchScimConfig) | **PATCH** /scim/scim-config | Patch SCIM App configuration



## getScimConfig

> AppConfiguration3 getScimConfig()

Retrieves SCIM App configuration

Retrieves SCIM App configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SCIMConfigManagementApi();
apiInstance.getScimConfig((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**AppConfiguration3**](AppConfiguration3.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchScimConfig

> AppConfiguration3 patchScimConfig(opts)

Patch SCIM App configuration

Patch SCIM App configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SCIMConfigManagementApi();
let opts = {
  'requestBody': [ {op:replace, path: loggingLevel, value: DEBUG } ] // [Object] | String representing patch-document.
};
apiInstance.patchScimConfig(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**AppConfiguration3**](AppConfiguration3.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json

