# JansConfigApi.LogsApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAuditData**](LogsApi.md#getAuditData) | **GET** /api/v1/audit | Get audit details.



## getAuditData

> LogPagedResult getAuditData(opts)

Get audit details.

Get audit details.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.LogsApi();
let opts = {
  'pattern': "pattern_example", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'limit': 50, // Number | Search size - max size of the results to return
  'startDate': "startDate_example", // String | Start-Date for which the log entries report is to be fetched
  'endDate': "endDate_example" // String | End-Date for which the log entries is to be fetched
};
apiInstance.getAuditData(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pattern** | **String**| Search pattern | [optional] 
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **startDate** | **String**| Start-Date for which the log entries report is to be fetched | [optional] 
 **endDate** | **String**| End-Date for which the log entries is to be fetched | [optional] 

### Return type

[**LogPagedResult**](LogPagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

