# JansConfigApi.CacheConfigurationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigCache**](CacheConfigurationApi.md#getConfigCache) | **GET** /api/v1/config/cache | Returns cache configuration.
[**patchConfigCache**](CacheConfigurationApi.md#patchConfigCache) | **PATCH** /api/v1/config/cache | Patch cache configuration.



## getConfigCache

> CacheConfiguration getConfigCache()

Returns cache configuration.

Returns cache configuration.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationApi();
apiInstance.getConfigCache((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**CacheConfiguration**](CacheConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigCache

> CacheConfiguration patchConfigCache(opts)

Patch cache configuration.

Patch cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationApi();
let opts = {
  'requestBody': [{ "op": "replace", "path": "/memcachedConfiguration", "value": {
        "servers": "localhost:11211",
        "maxOperationQueueLength": 100000,
        "bufferSize": 32768,
        "defaultPutExpiration":80,
        "connectionFactoryType": "DEFAULT"
    }}] 
 // [Object] | String representing patch-document.
};
apiInstance.patchConfigCache(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**CacheConfiguration**](CacheConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json

