"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _CustomScope = _interopRequireDefault(require("../model/CustomScope"));
var _PagedResult = _interopRequireDefault(require("../model/PagedResult"));
var _Scope = _interopRequireDefault(require("../model/Scope"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* OAuthScopes service.
* @module api/OAuthScopesApi
* @version OAS Version
*/
var OAuthScopesApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new OAuthScopesApi. 
  * @alias module:api/OAuthScopesApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function OAuthScopesApi(apiClient) {
    _classCallCheck(this, OAuthScopesApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteOauthScopesByInum operation.
   * @callback module:api/OAuthScopesApi~deleteOauthScopesByInumCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete Scope
   * Delete Scope
   * @param {String} inum Scope identifier
   * @param {module:api/OAuthScopesApi~deleteOauthScopesByInumCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(OAuthScopesApi, [{
    key: "deleteOauthScopesByInum",
    value: function deleteOauthScopesByInum(inum, callback) {
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling deleteOauthScopesByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/scopes/{inum}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getOauthScopes operation.
     * @callback module:api/OAuthScopesApi~getOauthScopesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of Scopes
     * Gets list of Scopes
     * @param {Object} opts Optional parameters
     * @param {String} opts.type Scope type (default to '')
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {Boolean} opts.withAssociatedClients Boolean fag to indicate if clients associated with the scope are to be returned (default to false)
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/OAuthScopesApi~getOauthScopesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
  }, {
    key: "getOauthScopes",
    value: function getOauthScopes(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'type': opts['type'],
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'withAssociatedClients': opts['withAssociatedClients'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PagedResult["default"];
      return this.apiClient.callApi('/api/v1/scopes', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getOauthScopesByInum operation.
     * @callback module:api/OAuthScopesApi~getOauthScopesByInumCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CustomScope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Scope by Inum
     * Get Scope by Inum
     * @param {String} inum Scope identifier
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.withAssociatedClients  (default to false)
     * @param {module:api/OAuthScopesApi~getOauthScopesByInumCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CustomScope}
     */
  }, {
    key: "getOauthScopesByInum",
    value: function getOauthScopesByInum(inum, opts, callback) {
      opts = opts || {};
      var postBody = null;
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling getOauthScopesByInum");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {
        'withAssociatedClients': opts['withAssociatedClients']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _CustomScope["default"];
      return this.apiClient.callApi('/api/v1/scopes/{inum}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getScopeByCreator operation.
     * @callback module:api/OAuthScopesApi~getScopeByCreatorCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/CustomScope>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Scope by creatorId
     * Get Scope by creatorId
     * @param {String} creatorId Id of the scope creator. If creator is client then client_id if user then user_id
     * @param {module:api/OAuthScopesApi~getScopeByCreatorCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/CustomScope>}
     */
  }, {
    key: "getScopeByCreator",
    value: function getScopeByCreator(creatorId, callback) {
      var postBody = null;
      // verify the required parameter 'creatorId' is set
      if (creatorId === undefined || creatorId === null) {
        throw new Error("Missing the required parameter 'creatorId' when calling getScopeByCreator");
      }
      var pathParams = {
        'creatorId': creatorId
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_CustomScope["default"]];
      return this.apiClient.callApi('/api/v1/scopes/creator/{creatorId}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getScopeByType operation.
     * @callback module:api/OAuthScopesApi~getScopeByTypeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/CustomScope>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Scope by type
     * Get Scope by type
     * @param {String} type Type of the scope
     * @param {module:api/OAuthScopesApi~getScopeByTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/CustomScope>}
     */
  }, {
    key: "getScopeByType",
    value: function getScopeByType(type, callback) {
      var postBody = null;
      // verify the required parameter 'type' is set
      if (type === undefined || type === null) {
        throw new Error("Missing the required parameter 'type' when calling getScopeByType");
      }
      var pathParams = {
        'type': type
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_CustomScope["default"]];
      return this.apiClient.callApi('/api/v1/scopes/type/{type}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchOauthScopesById operation.
     * @callback module:api/OAuthScopesApi~patchOauthScopesByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Scope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch Scope
     * Patch Scope
     * @param {String} inum Scope identifier
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/OAuthScopesApi~patchOauthScopesByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Scope}
     */
  }, {
    key: "patchOauthScopesById",
    value: function patchOauthScopesById(inum, opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      // verify the required parameter 'inum' is set
      if (inum === undefined || inum === null) {
        throw new Error("Missing the required parameter 'inum' when calling patchOauthScopesById");
      }
      var pathParams = {
        'inum': inum
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _Scope["default"];
      return this.apiClient.callApi('/api/v1/scopes/{inum}', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postOauthScopes operation.
     * @callback module:api/OAuthScopesApi~postOauthScopesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Scope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create Scope
     * Create Scope
     * @param {Object} opts Optional parameters
     * @param {module:model/Scope} opts.scope Scope object
     * @param {module:api/OAuthScopesApi~postOauthScopesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Scope}
     */
  }, {
    key: "postOauthScopes",
    value: function postOauthScopes(opts, callback) {
      opts = opts || {};
      var postBody = opts['scope'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _Scope["default"];
      return this.apiClient.callApi('/api/v1/scopes', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putOauthScopes operation.
     * @callback module:api/OAuthScopesApi~putOauthScopesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Scope} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update Scope
     * Update Scope
     * @param {Object} opts Optional parameters
     * @param {module:model/Scope} opts.scope Scope object
     * @param {module:api/OAuthScopesApi~putOauthScopesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Scope}
     */
  }, {
    key: "putOauthScopes",
    value: function putOauthScopes(opts, callback) {
      opts = opts || {};
      var postBody = opts['scope'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _Scope["default"];
      return this.apiClient.callApi('/api/v1/scopes', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();