"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _LogPagedResult = _interopRequireDefault(require("../model/LogPagedResult"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* Logs service.
* @module api/LogsApi
* @version OAS Version
*/
var LogsApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new LogsApi. 
  * @alias module:api/LogsApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function LogsApi(apiClient) {
    _classCallCheck(this, LogsApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the getAuditData operation.
   * @callback module:api/LogsApi~getAuditDataCallback
   * @param {String} error Error message, if any.
   * @param {module:model/LogPagedResult} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Get audit details.
   * Get audit details.
   * @param {Object} opts Optional parameters
   * @param {String} opts.pattern Search pattern
   * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
   * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
   * @param {String} opts.startDate Start-Date for which the log entries report is to be fetched
   * @param {String} opts.endDate End-Date for which the log entries is to be fetched
   * @param {module:api/LogsApi~getAuditDataCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link module:model/LogPagedResult}
   */
  return _createClass(LogsApi, [{
    key: "getAuditData",
    value: function getAuditData(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'limit': opts['limit'],
        'start_date': opts['startDate'],
        'end_date': opts['endDate']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _LogPagedResult["default"];
      return this.apiClient.callApi('/api/v1/audit', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();